/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.builtintypes.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractTable;
import org.eclipse.papyrus.model2doc.core.builtintypes.BuiltInTypesPackage;
import org.eclipse.papyrus.model2doc.core.builtintypes.Cell;
import org.eclipse.papyrus.model2doc.core.builtintypes.Row;

public abstract class AbstractTableImpl
extends MinimalEObjectImpl.Container
implements AbstractTable {
    protected static final String CAPTION_EDEFAULT = null;
    protected String caption = CAPTION_EDEFAULT;
    protected EList<Row> rows;

    protected AbstractTableImpl() {
    }

    protected EClass eStaticClass() {
        return BuiltInTypesPackage.Literals.ABSTRACT_TABLE;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public void setCaption(String newCaption) {
        String oldCaption = this.caption;
        this.caption = newCaption;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldCaption, (Object)this.caption));
        }
    }

    @Override
    public EList<Row> getRows() {
        if (this.rows == null) {
            this.rows = new EObjectContainmentEList(Row.class, (InternalEObject)this, 1);
        }
        return this.rows;
    }

    @Override
    public int getRowsNumber() {
        return this.getRows().size();
    }

    @Override
    public int getColumnsNumber() {
        Row firstRow;
        if (this.getRowsNumber() > 0 && (firstRow = (Row)this.getRows().get(0)) != null) {
            return firstRow.getCells().size();
        }
        return 0;
    }

    @Override
    public EList<Cell> getAllCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (Row row : this.getRows()) {
            cells.addAll((Collection<Cell>)row.getCells());
        }
        return ECollections.toEList(cells);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getRows()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getCaption();
            }
            case 1: {
                return this.getRows();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setCaption((String)newValue);
                return;
            }
            case 1: {
                this.getRows().clear();
                this.getRows().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setCaption(CAPTION_EDEFAULT);
                return;
            }
            case 1: {
                this.getRows().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return CAPTION_EDEFAULT == null ? this.caption != null : !CAPTION_EDEFAULT.equals(this.caption);
            }
            case 1: {
                return this.rows != null && !this.rows.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.getRowsNumber();
            }
            case 1: {
                return this.getColumnsNumber();
            }
            case 2: {
                return this.getAllCells();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (caption: ");
        result.append(this.caption);
        result.append(')');
        return result.toString();
    }
}

