/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.docx.internal.poi;

import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.eclipse.papyrus.model2doc.docx.Activator;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;

public class CustomXWPFTable
extends XWPFTable {
    public CustomXWPFTable(CTTbl table, IBody part) {
        super(table, part);
    }

    public CustomXWPFTable(CTTbl table, IBody part, int row, int col) {
        super(table, part, row, col);
    }

    public void horizontalCellMerge(int rowIndex, int startCellIndex, int endCellIndex) {
        if (rowIndex >= this.getNumberOfRows()) {
            Activator.log.warn("The merge of cells is not possible since the range of cells is out of bounds");
        }
        if (startCellIndex >= this.getRow(rowIndex).getTableCells().size() || endCellIndex >= this.getRow(rowIndex).getTableCells().size()) {
            Activator.log.warn("The merge of cells is not possible since the range of cells is out of bounds");
        }
        CTHMerge startMerge = CTHMerge.Factory.newInstance();
        startMerge.setVal(STMerge.RESTART);
        CTHMerge continueMerge = CTHMerge.Factory.newInstance();
        continueMerge.setVal(STMerge.CONTINUE);
        XWPFTableCell startCell = this.getRow(rowIndex).getCell(startCellIndex);
        startCell.getCTTc().addNewTcPr().setHMerge(startMerge);
        int index = startCellIndex + 1;
        while (index <= endCellIndex) {
            XWPFTableCell continueCell = this.getRow(rowIndex).getCell(index);
            CTTcPr tcpr = continueCell.getCTTc().getTcPr();
            if (tcpr == null) {
                tcpr = continueCell.getCTTc().addNewTcPr();
            }
            tcpr.setHMerge(continueMerge);
            ++index;
        }
    }

    public void verticalCellMerge(int columnIndex, int startRowIndex, int endRowIndex) {
        if (startRowIndex >= this.getNumberOfRows() || endRowIndex >= this.getNumberOfRows()) {
            Activator.log.warn("The merge of cells is not possible since the range of cells is out of bounds");
        }
        if (columnIndex >= this.getRow(0).getTableCells().size()) {
            Activator.log.warn("The merge of cells is not possible since the range of cells is out of bounds");
        }
        CTVMerge startMerge = CTVMerge.Factory.newInstance();
        startMerge.setVal(STMerge.RESTART);
        CTVMerge continueMerge = CTVMerge.Factory.newInstance();
        continueMerge.setVal(STMerge.CONTINUE);
        XWPFTableCell startCell = this.getRow(startRowIndex).getCell(columnIndex);
        startCell.getCTTc().addNewTcPr().setVMerge(startMerge);
        int index = startRowIndex + 1;
        while (index <= endRowIndex) {
            XWPFTableCell continueCell = this.getRow(index).getCell(columnIndex);
            CTTcPr tcpr = continueCell.getCTTc().getTcPr();
            if (tcpr == null) {
                tcpr = continueCell.getCTTc().addNewTcPr();
            }
            tcpr.setVMerge(continueMerge);
            ++index;
        }
    }
}

