/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.time.scheduling.de;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.AbstractPushPullStrategy;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.Event;

public class DefaultPushPullStrategy
extends AbstractPushPullStrategy {
    @Override
    public List<Event> pullEvents(double date) {
        ArrayList<Event> selectedEvents = new ArrayList<Event>();
        int i = 0;
        while (i < this.scheduler.getEvents().size() && this.scheduler.getEvents().get(i).getAbsoluteDate() == date) {
            selectedEvents.add(this.scheduler.getEvents().get(i));
            ++i;
        }
        this.scheduler.removeAllEvents(selectedEvents);
        return selectedEvents;
    }

    @Override
    public void pushEvent(Event event) {
        double absoluteDate = this.scheduler.getCurrentTime() + event.getRelativeDate();
        this.pushEvent(event, absoluteDate);
    }

    @Override
    public void pushEvent(Event event, double absoluteDate) {
        event.setAbsoluteDate(absoluteDate);
        event.setScheduler(this.scheduler);
        int i = 0;
        int insertAt = 0;
        boolean foundInsertion = false;
        while (i < this.scheduler.getEvents().size() && !foundInsertion) {
            if (this.scheduler.getEvents().get(i).getAbsoluteDate() < event.getAbsoluteDate()) {
                insertAt = i + 1;
                ++i;
                continue;
            }
            foundInsertion = true;
        }
        if (insertAt < this.scheduler.getEvents().size()) {
            this.scheduler.addEventAt(insertAt, event);
        } else {
            this.scheduler.addEvent(event);
        }
    }
}

