/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.actions.ActionActivation;
import org.eclipse.papyrus.moka.fuml.actions.ExpansionActivationGroup;
import org.eclipse.papyrus.moka.fuml.actions.ExpansionNodeActivation;
import org.eclipse.papyrus.moka.fuml.actions.IExpansionActivationGroup;
import org.eclipse.papyrus.moka.fuml.actions.IExpansionRegionActivation;
import org.eclipse.papyrus.moka.fuml.actions.IOutputPinActivation;
import org.eclipse.papyrus.moka.fuml.actions.IPinActivation;
import org.eclipse.papyrus.moka.fuml.actions.OutputPinActivation;
import org.eclipse.papyrus.moka.fuml.actions.TokenSet;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.profiling.actions.AcceptEventActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityEdgeInstanceProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.CallActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ObjectNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ExpansionKind;
import org.eclipse.uml2.uml.ExpansionNode;
import org.eclipse.uml2.uml.ExpansionRegion;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class ExpansionRegionActivation
extends ActionActivation
implements IExpansionRegionActivation {
    public List<IExpansionActivationGroup> activationGroups = new ArrayList<IExpansionActivationGroup>();
    public List<TokenSet> inputTokens = new ArrayList<TokenSet>();
    public List<TokenSet> inputExpansionTokens = new ArrayList<TokenSet>();
    public Integer next;

    @Override
    public List<IToken> takeOfferedTokens() {
        super.takeOfferedTokens();
        ExpansionRegion region = (ExpansionRegion)this.node;
        EList inputPins = region.getInputs();
        EList inputElements = region.getInputElements();
        this.inputTokens.clear();
        this.inputExpansionTokens.clear();
        int i = 0;
        while (i < inputPins.size()) {
            InputPin inputPin = (InputPin)inputPins.get(i);
            TokenSet tokenSet = new TokenSet();
            tokenSet.tokens = this.getPinActivation((Pin)inputPin).takeTokens();
            this.inputTokens.add(tokenSet);
            ++i;
        }
        int n = this.numberOfValues();
        int i2 = 0;
        while (i2 < inputElements.size()) {
            ExpansionNode inputElement = (ExpansionNode)inputElements.get(i2);
            ExpansionNodeActivation expansionNodeActivation = this.getExpansionNodeActivation(inputElement);
            List<IToken> list = expansionNodeActivation.takeOfferedTokens();
            ExpansionNodeActivation expansionNodeActivation2 = expansionNodeActivation;
            ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityNodeActivationProfiler$1$e1c57393(expansionNodeActivation2, list);
            expansionNodeActivation2.fire(list);
            List<IToken> tokens = expansionNodeActivation.takeTokens();
            TokenSet tokenSet = new TokenSet();
            int j = 1;
            while (j <= n) {
                tokenSet.tokens.add(tokens.get(j - 1));
                ++j;
            }
            this.inputExpansionTokens.add(tokenSet);
            ++i2;
        }
        return new ArrayList<IToken>();
    }

    @Override
    public void doAction() {
        block19: {
            if (((StructuredActivityNode)this.node).isMustIsolate()) {
                ExpansionRegionActivation expansionRegionActivation = this;
                ActivityEdgeInstanceProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
                ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
                ObjectNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
                PinActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
                AcceptEventActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
                CallActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
                expansionRegionActivation._beginIsolation();
                this.doStructuredActivity();
                ExpansionRegionActivation expansionRegionActivation2 = this;
                try {
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        expansionRegionActivation2._endIsolation();
                                        break block19;
                                    }
                                    finally {
                                        ActivityEdgeInstanceProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                                    }
                                }
                                finally {
                                    ActivityNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                                }
                            }
                            finally {
                                ObjectNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                            }
                        }
                        finally {
                            PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                        }
                    }
                    finally {
                        AcceptEventActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                    }
                }
                finally {
                    CallActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                }
            }
            this.doStructuredActivity();
        }
    }

    public void doStructuredActivity() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        EList inputPins = region.getInputs();
        EList inputElements = region.getInputElements();
        EList outputElements = region.getOutputElements();
        this.activationGroups.clear();
        int n = this.inputExpansionTokens.get((int)0).tokens.size();
        int k = 1;
        while (k <= n) {
            ExpansionActivationGroup activationGroup = new ExpansionActivationGroup();
            activationGroup.setRegionActivation(this);
            activationGroup.setIndex(k);
            int j = 1;
            while (j <= inputPins.size()) {
                OutputPinActivation regionInput = new OutputPinActivation();
                regionInput.run();
                activationGroup.getRegionInputs().add(regionInput);
                ++j;
            }
            j = 1;
            while (j <= inputElements.size()) {
                OutputPinActivation groupInput = new OutputPinActivation();
                groupInput.run();
                activationGroup.getGroupInputs().add(groupInput);
                ++j;
            }
            j = 1;
            while (j <= outputElements.size()) {
                OutputPinActivation groupOutput = new OutputPinActivation();
                groupOutput.run();
                activationGroup.getGroupOutputs().add(groupOutput);
                ++j;
            }
            activationGroup.createNodeActivations((List)region.getNodes());
            activationGroup.createEdgeInstances((List)region.getEdges());
            this.activationGroups.add(activationGroup);
            ++k;
        }
        if (region.getMode() == ExpansionKind.ITERATIVE_LITERAL) {
            Debug.println("[doStructuredActivity] Expansion mode = iterative");
            this.next = 1;
            this.runIterative();
        } else if (region.getMode() == ExpansionKind.PARALLEL_LITERAL) {
            Debug.println("[doStructuredActivity] Expansion mode = parallel");
            this.runParallel();
        }
        this.doOutput();
    }

    public void runIterative() {
        List<IExpansionActivationGroup> activationGroups = this.activationGroups;
        while (this.next <= activationGroups.size() & this.isSuspended() == false) {
            IExpansionActivationGroup activationGroup = activationGroups.get(this.next - 1);
            this.runGroup(activationGroup);
            this.next = this.next + 1;
        }
    }

    public void runParallel() {
        List<IExpansionActivationGroup> activationGroups = this.activationGroups;
        for (IExpansionActivationGroup activationGroup : activationGroups) {
            this.runGroup(activationGroup);
        }
    }

    public void doOutput() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        EList outputElements = region.getOutputElements();
        Debug.println("[doOutput] Expansion region " + region.getName() + " is " + (this.isSuspended() != false ? "suspended." : "completed."));
        if (!this.isSuspended().booleanValue()) {
            int i = 0;
            while (i < this.activationGroups.size()) {
                IExpansionActivationGroup activationGroup = this.activationGroups.get(i);
                List groupOutputs = activationGroup.getGroupOutputs();
                int j = 0;
                while (j < groupOutputs.size()) {
                    IOutputPinActivation groupOutput = (IOutputPinActivation)groupOutputs.get(j);
                    ExpansionNode outputElement = (ExpansionNode)outputElements.get(j);
                    List list = groupOutput.takeTokens();
                    ExpansionNodeActivation expansionNodeActivation = this.getExpansionNodeActivation(outputElement);
                    try {
                        expansionNodeActivation.addTokens(list);
                    }
                    finally {
                        if (expansionNodeActivation instanceof IPinActivation) {
                            PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$1$44250678((IPinActivation)expansionNodeActivation, list);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void terminate() {
        List<IExpansionActivationGroup> activationGroups = this.activationGroups;
        int i = 0;
        while (i < activationGroups.size()) {
            IExpansionActivationGroup activationGroup = this.activationGroups.get(i);
            List groupOutputs = activationGroup.getGroupOutputs();
            ExpansionRegionActivation expansionRegionActivation = this;
            ActivityEdgeInstanceProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
            ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
            ObjectNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
            PinActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
            AcceptEventActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
            CallActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(expansionRegionActivation);
            expansionRegionActivation._beginIsolation();
            int j = 0;
            while (j < groupOutputs.size()) {
                IOutputPinActivation groupOutput = (IOutputPinActivation)groupOutputs.get(j);
                List list = groupOutput.takeOfferedTokens();
                IOutputPinActivation iOutputPinActivation = groupOutput;
                ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityNodeActivationProfiler$1$e1c57393((IActivityNodeActivation)iOutputPinActivation, list);
                iOutputPinActivation.fire(list);
                ++j;
            }
            activationGroup.terminateAll();
            ExpansionRegionActivation expansionRegionActivation2 = this;
            try {
                try {
                    try {
                        try {
                            try {
                                try {
                                    expansionRegionActivation2._endIsolation();
                                }
                                finally {
                                    ActivityEdgeInstanceProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                                }
                            }
                            finally {
                                ActivityNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                            }
                        }
                        finally {
                            ObjectNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                        }
                    }
                    finally {
                        PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                    }
                }
                finally {
                    AcceptEventActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
                }
            }
            finally {
                CallActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(expansionRegionActivation2);
            }
            ++i;
        }
        super.terminate();
    }

    @Override
    public void sendOffers() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        EList outputElements = region.getOutputElements();
        for (ExpansionNode outputElement : outputElements) {
            this.getExpansionNodeActivation(outputElement).sendUnofferedTokens();
        }
        super.sendOffers();
    }

    public void runGroup(IExpansionActivationGroup activationGroup) {
        if (this.isRunning().booleanValue()) {
            Debug.println("[runGroup] groupInput[0] = " + this.inputExpansionTokens.get((int)0).tokens.get(activationGroup.getIndex() - 1).getValue());
            List<TokenSet> inputTokens = this.inputTokens;
            int j = 0;
            while (j < inputTokens.size()) {
                TokenSet tokenSet = inputTokens.get(j);
                IOutputPinActivation regionInput = (IOutputPinActivation)activationGroup.getRegionInputs().get(j);
                regionInput.clearTokens();
                List<IToken> list = tokenSet.tokens;
                IOutputPinActivation iOutputPinActivation = regionInput;
                try {
                    iOutputPinActivation.addTokens(list);
                }
                finally {
                    PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$1$44250678((IPinActivation)iOutputPinActivation, list);
                }
                regionInput.sendUnofferedTokens();
                ++j;
            }
            List<TokenSet> inputExpansionTokens = this.inputExpansionTokens;
            int j2 = 0;
            while (j2 < inputExpansionTokens.size()) {
                TokenSet tokenSet = inputExpansionTokens.get(j2);
                IOutputPinActivation groupInput = (IOutputPinActivation)activationGroup.getGroupInputs().get(j2);
                groupInput.clearTokens();
                if (tokenSet.tokens.size() >= activationGroup.getIndex()) {
                    groupInput.addToken(tokenSet.tokens.get(activationGroup.getIndex() - 1));
                }
                groupInput.sendUnofferedTokens();
                ++j2;
            }
            activationGroup.run(activationGroup.getActivityNodeActivations());
            this.terminateGroup(activationGroup);
        }
    }

    public void terminateGroup(IExpansionActivationGroup activationGroup) {
        if (this.isRunning() & this.isSuspended() == false) {
            List groupOutputs = activationGroup.getGroupOutputs();
            int i = 0;
            while (i < groupOutputs.size()) {
                IOutputPinActivation groupOutput = (IOutputPinActivation)groupOutputs.get(i);
                List list = groupOutput.takeOfferedTokens();
                IOutputPinActivation iOutputPinActivation = groupOutput;
                ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_activities_ActivityNodeActivationProfiler$1$e1c57393((IActivityNodeActivation)iOutputPinActivation, list);
                iOutputPinActivation.fire(list);
                ++i;
            }
            activationGroup.terminateAll();
        }
    }

    public ExpansionNodeActivation getExpansionNodeActivation(ExpansionNode node) {
        return (ExpansionNodeActivation)this.group.getNodeActivation((ActivityNode)node);
    }

    public Integer numberOfValues() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        EList inputElements = region.getInputElements();
        int n = this.getExpansionNodeActivation((ExpansionNode)inputElements.get(0)).countOfferedValues();
        int i = 2;
        while (i <= inputElements.size()) {
            int count = this.getExpansionNodeActivation((ExpansionNode)inputElements.get(i - 1)).countOfferedValues();
            if (count < n) {
                n = count;
            }
            ++i;
        }
        return n;
    }

    public Boolean isSuspended() {
        boolean suspended = false;
        int i = 1;
        while (i <= this.activationGroups.size() & !suspended) {
            IActivityNodeActivationGroup group = (IActivityNodeActivationGroup)this.activationGroups.get(i - 1);
            suspended = group.isSuspended();
            ++i;
        }
        return suspended;
    }

    public void resume(IExpansionActivationGroup activationGroup) {
        ExpansionRegion region = (ExpansionRegion)this.node;
        this.resume();
        this.terminateGroup(activationGroup);
        if (region.getMode() == ExpansionKind.ITERATIVE_LITERAL) {
            this.runIterative();
        }
        this.doOutput();
    }

    public List<IExpansionActivationGroup> getExpansionActivationGroups() {
        return this.activationGroups;
    }
}

