/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.metrics.commands;

import java.util.ArrayList;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.metrics.commands.helper.MetricsCalculatorHelper;
import org.eclipse.papyrus.metrics.commands.helper.RegistersHelper;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IDefaultQuerySwitch;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IRecognizerSwitch;
import org.eclipse.papyrus.metrics.extensionpoints.interfaces.IResultsViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.omg.smm.Measure;
import org.omg.smm.SmmModel;

public abstract class AbstractCalculateMeasuresCommand
extends AbstractCommand {
    protected ArrayList<Measure> measures = new ArrayList();
    protected ArrayList<IResultsViewer> resultsViewers = new ArrayList();
    protected Element observationScope = null;
    protected SmmModel smmModel = null;
    protected IRecognizerSwitch recognizerSwitch = null;
    protected IDefaultQuerySwitch defaultQuerySwitch = null;

    public AbstractCalculateMeasuresCommand(Element observationScope) {
        super("AbstractCalculateMeasuresCommand", "Abstract command to calculate Measures according to the SMM metamodel");
        this.isPrepared = true;
        this.isExecutable = true;
        RegistersHelper registersHelper = new RegistersHelper();
        this.resultsViewers = registersHelper.getViewers();
        this.recognizerSwitch = registersHelper.getRecognizerSwitch();
        this.defaultQuerySwitch = registersHelper.getDefaultQuerySwitch();
        this.observationScope = observationScope;
    }

    protected abstract ArrayList<Measure> getMeasures();

    public boolean canExecute() {
        return true;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }

    public void execute() {
        this.measures = this.getMeasures();
        if (this.measures == null || this.resultsViewers == null || this.observationScope == null || this.resultsViewers == null || this.recognizerSwitch == null || this.defaultQuerySwitch == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Imposible to start metrics calculation\n Please read the details in the log.");
            return;
        }
        if (this.measures.isEmpty()) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Information", (String)"There are no measures to calculate");
            return;
        }
        MetricsCalculatorHelper helper = new MetricsCalculatorHelper(this.measures, this.observationScope, this.resultsViewers, this.recognizerSwitch, this.defaultQuerySwitch);
        helper.run();
    }
}

