/*
 * Decompiled with CFR 0.152.
 */
package org.omg.smm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Accumulator implements Enumerator
{
    SUM(0, "sum", "sum"),
    MAXIMUM(1, "maximum", "maximum"),
    MINIMUM(2, "minimum", "minimum"),
    AVERAGE(3, "average", "average"),
    STANDARD_DEVIATION(4, "standardDeviation", "standardDeviation"),
    PRODUCT(5, "product", "product"),
    CUSTOM(6, "custom", "custom");

    public static final int SUM_VALUE = 0;
    public static final int MAXIMUM_VALUE = 1;
    public static final int MINIMUM_VALUE = 2;
    public static final int AVERAGE_VALUE = 3;
    public static final int STANDARD_DEVIATION_VALUE = 4;
    public static final int PRODUCT_VALUE = 5;
    public static final int CUSTOM_VALUE = 6;
    private static final Accumulator[] VALUES_ARRAY;
    public static final List<Accumulator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Accumulator[]{SUM, MAXIMUM, MINIMUM, AVERAGE, STANDARD_DEVIATION, PRODUCT, CUSTOM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Accumulator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Accumulator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Accumulator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Accumulator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Accumulator get(int value) {
        switch (value) {
            case 0: {
                return SUM;
            }
            case 1: {
                return MAXIMUM;
            }
            case 2: {
                return MINIMUM;
            }
            case 3: {
                return AVERAGE;
            }
            case 4: {
                return STANDARD_DEVIATION;
            }
            case 5: {
                return PRODUCT;
            }
            case 6: {
                return CUSTOM;
            }
        }
        return null;
    }

    private Accumulator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

