/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.provider;

import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

public abstract class AbstractFilterProvider
extends EncapsulatedContentProvider {
    AbstractFilterProvider(IStaticContentProvider encapsulated) {
        super((IStructuredContentProvider)encapsulated);
    }

    public Object[] getElements() {
        return this.filteredList(super.getElements());
    }

    public Object[] getElements(Object inputElement) {
        return this.filteredList(super.getElements(inputElement));
    }

    public Object[] getChildren(Object parentElement) {
        return this.filteredList(super.getChildren(parentElement));
    }

    public boolean isValidValue(Object element) {
        return super.isValidValue(element);
    }

    protected Object[] filteredList(Object[] list) {
        ArrayList<Object> filteredElements = new ArrayList<Object>();
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            EObject eObj = null;
            if (element instanceof EObject) {
                eObj = (EObject)element;
            } else if (element instanceof EObjectTreeElement) {
                eObj = ((EObjectTreeElement)element).getEObject();
            } else if (element instanceof EReferenceTreeElement) {
                filteredElements.add(element);
            } else {
                Activator.log.debug("element must be either EObject, EObjectTreeElement or EReferenceTreeElement");
            }
            if (eObj != null) {
                if (this.hasChildren(element) && this.hasFilteredChildren(eObj)) {
                    filteredElements.add(element);
                } else if (this.isValid(eObj)) {
                    filteredElements.add(eObj);
                }
            }
            ++n2;
        }
        return filteredElements.toArray();
    }

    protected boolean hasFilteredChildren(EObject eObj) {
        TreeIterator treeIter = eObj.eAllContents();
        while (treeIter.hasNext()) {
            EObject child = (EObject)treeIter.next();
            if (!this.isValid(child)) continue;
            return true;
        }
        return false;
    }

    abstract boolean isValid(Object var1);
}

