/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;

public class InstanceUtils {
    public static List<Property> getCompInstanceList(Class system) {
        UniqueEList instanceList = new UniqueEList();
        for (Property p : system.allAttributes()) {
            if (!StereotypeUtil.isApplied((Element)p, ComponentInstance.class)) continue;
            instanceList.add((Object)p);
        }
        return instanceList;
    }

    public static List<Class> getComponentList(Class system) {
        UniqueEList compList = new UniqueEList();
        for (Property p : InstanceUtils.getCompInstanceList(system)) {
            if (!(p.getType() instanceof Class)) continue;
            compList.add((Object)((Class)p.getType()));
        }
        return compList;
    }

    public static Class getComponentFromPkg(Package pkg) {
        for (PackageableElement pe : pkg.getPackagedElements()) {
            if (pe instanceof Package) {
                Class candidate = InstanceUtils.getComponentFromPkg((Package)pe);
                if (candidate == null) continue;
                return candidate;
            }
            if (!(pe instanceof Class) || !StereotypeUtil.isApplied((Element)pe, ComponentDefinition.class)) continue;
            return (Class)pe;
        }
        return null;
    }

    public static Class getSystemFromPkg(Package pkg) {
        for (PackageableElement pe : pkg.getPackagedElements()) {
            if (pe instanceof Package) {
                Class candidate = InstanceUtils.getSystemFromPkg((Package)pe);
                if (candidate == null) continue;
                return candidate;
            }
            if (!(pe instanceof Class) || !StereotypeUtil.isApplied((Element)pe, System.class)) continue;
            return (Class)pe;
        }
        return null;
    }

    public static Class getSystem(Package cdp) {
        if (!DepUtils.isDeploymentPlan((Package)cdp)) {
            return InstanceUtils.getSystemFromPkg(cdp);
        }
        for (InstanceSpecification is : DepUtils.getTopLevelInstances((Package)cdp)) {
            Classifier cl = DepUtils.getClassifier((InstanceSpecification)is);
            if (!(cl instanceof Class) || !StereotypeUtil.isApplied((Element)cl, System.class)) continue;
            return (Class)cl;
        }
        return null;
    }
}

