/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.base.file.FileSystemAccessFactory;
import org.eclipse.papyrus.designer.languages.common.base.file.ICleanUntouchedTmp;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.core.utils.InstanceUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinitionModel;
import org.eclipse.papyrus.robotics.profile.robotics.components.SystemComponentArchitectureModel;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinitionModel;
import org.eclipse.papyrus.robotics.ros2.base.EnvironmentUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.Activator;
import org.eclipse.papyrus.robotics.ros2.codegen.build.CreateCompCMakeLists;
import org.eclipse.papyrus.robotics.ros2.codegen.build.CreateCompPackageXML;
import org.eclipse.papyrus.robotics.ros2.codegen.component.ComponentTransformations;
import org.eclipse.papyrus.robotics.ros2.codegen.launch.LaunchScript;
import org.eclipse.papyrus.robotics.ros2.codegen.message.CreateMsgPackage;
import org.eclipse.papyrus.robotics.ros2.codegen.skillrealization.CreateSkillRelizationPackage;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.PackageTools;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ProjectTools;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.SkillUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RosTransformations
implements IM2MTrafoCDP {
    private CreateMsgPackage msgPkgCreator;
    private CreateSkillRelizationPackage skrPkgCreator;

    public IProject pkgTrafos(Package pkg) {
        try {
            IPFileSystemAccess fileAccess;
            IProject _xblockexpression_1;
            IProject _xblockexpression = null;
            IProject project = ProjectTools.getProject(PackageTools.getProjectName(TransformationContext.initialSourceRoot));
            IProject _xifexpression = null;
            if (project != null) {
                boolean _not;
                _xblockexpression_1 = null;
                ArrayList<Class> compDefs = PackageTools.getCompDefs(project);
                Class system = PackageTools.getSystem(project);
                fileAccess = FileSystemAccessFactory.create((IProject)project);
                CreateCompCMakeLists.generate(fileAccess, pkg, compDefs, system);
                CreateCompPackageXML.generate(fileAccess, pkg, compDefs, system);
                ProjectTools.configureIncludes(project, MessageUtils.calcDependencies(compDefs));
                if (system != null) {
                    LaunchScript.generateLaunch(fileAccess, system);
                }
                ComponentTransformations ct = new ComponentTransformations(fileAccess, project);
                for (Class compDef : compDefs) {
                    ct.componentTrafo(compDef, this.msgPkgCreator);
                }
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(SkillUtils.getUniqueSkills(system));
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    CreateSkillRelizationPackage _createSkillRelizationPackage;
                    this.skrPkgCreator = _createSkillRelizationPackage = new CreateSkillRelizationPackage(system, compDefs);
                    this.skrPkgCreator.createSkillRealizationPkg(pkg);
                }
                for (Class compDef_1 : compDefs) {
                    ct.componentCodegen(compDef_1, this.msgPkgCreator);
                }
            } else {
                throw new TransformationException(ExecuteTransformationChain.USER_CANCEL);
            }
            ICleanUntouchedTmp cleanup = (ICleanUntouchedTmp)fileAccess;
            IFolder _folder = project.getFolder("src-gen");
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            cleanup.cleanUntouched(_folder, (IProgressMonitor)_nullProgressMonitor);
            IFolder _folder_1 = project.getFolder("src-skel");
            NullProgressMonitor _nullProgressMonitor_1 = new NullProgressMonitor();
            cleanup.cleanUntouched(_folder_1, (IProgressMonitor)_nullProgressMonitor_1);
            _xifexpression = _xblockexpression_1 = (TransformationContext.current.project = project);
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void applyTrafo(M2MTrafo trafo, Package rootPkg) throws TransformationException {
        CreateMsgPackage _createMsgPackage;
        EnvironmentUtils.waitForSetupJob();
        ApplyProfiles.applyCommonProfile((Element)rootPkg);
        ApplyProfiles.applyCppProfile((Element)rootPkg);
        this.msgPkgCreator = _createMsgPackage = new CreateMsgPackage();
        boolean _isApplied = StereotypeUtil.isApplied((Element)rootPkg, ServiceDefinitionModel.class);
        if (_isApplied) {
            this.msgPkgCreator.createMsgPkg(rootPkg);
        } else {
            boolean _isApplied_1 = StereotypeUtil.isApplied((Element)rootPkg, ComponentDefinitionModel.class);
            if (_isApplied_1) {
                Class component = InstanceUtils.getComponentFromPkg((Package)rootPkg);
                if (component != null) {
                    Package pkg = PackageUtil.getRootPackage((Element)component);
                    this.pkgTrafos(pkg);
                }
            } else {
                boolean _isApplied_2 = StereotypeUtil.isApplied((Element)rootPkg, SystemComponentArchitectureModel.class);
                if (_isApplied_2) {
                    Class system = InstanceUtils.getSystem((Package)rootPkg);
                    if (system != null) {
                        ArrayList<Package> pkgList = new ArrayList<Package>();
                        Package systemPkg = PackageUtil.getRootPackage((Element)system);
                        pkgList.add(systemPkg);
                        List _componentList = InstanceUtils.getComponentList((Class)system);
                        for (Class component_1 : _componentList) {
                            boolean _not;
                            Package compPkg = PackageUtil.getRootPackage((Element)system);
                            boolean _contains = pkgList.contains(compPkg);
                            boolean bl = _not = !_contains;
                            if (!_not) continue;
                            pkgList.add(compPkg);
                        }
                        for (Package pkg_1 : pkgList) {
                            this.pkgTrafos(pkg_1);
                        }
                    }
                } else {
                    Activator.log.debug(String.format("model %s is neither a component definition or a component assembly", rootPkg.getName()));
                }
            }
        }
    }
}

