/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.commands;

import java.util.Stack;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.ExecuteTrafoChain;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafoChain;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ApplyProfiles;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.Helpers;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PrepareCodegenCmd {
    protected ExecuteTrafoChain chain;
    protected Stack<AbstractCommand> appliedCmds = new Stack();
    protected Package pkg;
    protected TransactionalEditingDomain domain;

    public PrepareCodegenCmd(Package pkg) {
        this.pkg = pkg;
        this.domain = TransactionUtil.getEditingDomain((EObject)pkg);
    }

    public boolean prepare() {
        this.chain = (ExecuteTrafoChain)UMLUtil.getStereotypeApplication((Element)this.pkg, ExecuteTrafoChain.class);
        if (this.chain == null) {
            RecordingCommand applyStereoCmd = new RecordingCommand(this.domain, "Apply ExecuteTrafoChain stereotype"){

                protected void doExecute() {
                    PrepareCodegenCmd.this.chain = (ExecuteTrafoChain)StereotypeUtil.applyApp((Element)PrepareCodegenCmd.this.pkg, ExecuteTrafoChain.class);
                    if (PrepareCodegenCmd.this.chain == null) {
                        ApplyProfiles.applyTrafoProfile((Element)PrepareCodegenCmd.this.pkg);
                        PrepareCodegenCmd.this.chain = (ExecuteTrafoChain)StereotypeUtil.applyApp((Element)PrepareCodegenCmd.this.pkg, ExecuteTrafoChain.class);
                    }
                }
            };
            this.domain.getCommandStack().execute((Command)applyStereoCmd);
            this.appliedCmds.push((AbstractCommand)applyStereoCmd);
        }
        if (this.chain == null) {
            Activator.log.debug("Can't apply TransformationChain stereotype");
            this.undo();
            return false;
        }
        if (this.chain.getChain() == null) {
            RecordingCommand setChainCmd = new RecordingCommand(this.domain, "Set robotics chain"){

                protected void doExecute() {
                    Package rosLibrary = PackageUtil.loadPackage((URI)Helpers.ROS_LIBRARY_URI, (ResourceSet)PrepareCodegenCmd.this.domain.getResourceSet());
                    NamedElement rosChainCl = ElementUtils.getQualifiedElementFromRS((Element)rosLibrary, (String)"ros2Library::m2mtransformations::ROSChain");
                    if (rosChainCl != null) {
                        M2MTrafoChain rosChain = (M2MTrafoChain)UMLUtil.getStereotypeApplication((Element)rosChainCl, M2MTrafoChain.class);
                        PrepareCodegenCmd.this.chain.setChain(rosChain);
                    }
                }
            };
            this.domain.getCommandStack().execute((Command)setChainCmd);
            this.appliedCmds.push((AbstractCommand)setChainCmd);
        }
        return true;
    }

    public void undo() {
        while (!this.appliedCmds.isEmpty()) {
            this.appliedCmds.pop();
            if (!this.domain.getCommandStack().canUndo()) continue;
            this.domain.getCommandStack().undo();
        }
    }
}

