/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.utils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.base.UriConstants;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class Helpers {
    public static final URI ROS_LIBRARY_URI = URI.createURI((String)"pathmap://ROS2_LIBRARY/ros2Library.uml");
    public static final URI ROS_PRIMITIVE_URI = URI.createURI((String)"pathmap://ROS2_LIBRARY/ros2.primitive.uml");

    public static Type getRosType(Element element, String qualifiedName) {
        return Helpers.getTypeFromRS(element, ROS_LIBRARY_URI, qualifiedName, false);
    }

    public static Type getRosPrimitiveType(Element element, String qualifiedName) {
        return Helpers.getTypeFromRS(element, ROS_PRIMITIVE_URI, qualifiedName, true);
    }

    public static Type getUMLPrimitiveType(Element element, String qualifiedName) {
        return Helpers.getTypeFromRS(element, UriConstants.UML_PRIMITIVE_TYPES, qualifiedName, true);
    }

    public static Type getTypeFromRS(Element element, URI resourceURI, String qualifiedName, boolean needCopy) {
        NamedElement ne = ElementUtils.getQualifiedElementFromRS((Element)element, (String)qualifiedName);
        if (ne == null) {
            PackageUtil.loadPackage((URI)resourceURI, (ResourceSet)element.eResource().getResourceSet());
            ne = ElementUtils.getQualifiedElementFromRS((Element)element, (String)qualifiedName);
        }
        if (needCopy) {
            ne = (NamedElement)TransformationContext.current.copier.getCopy((Element)ne);
        }
        if (ne instanceof Type) {
            return (Type)ne;
        }
        return null;
    }

    public static String externalName(Type type) {
        if (type != null) {
            External external = (External)UMLUtil.getStereotypeApplication((Element)type, External.class);
            if (external != null) {
                return external.getName();
            }
            return type.getQualifiedName();
        }
        return null;
    }

    public static void useSharedPtr(TypedElement typedElement) {
        Ptr ptr = (Ptr)StereotypeUtil.applyApp((Element)typedElement, Ptr.class);
        ptr.setDeclaration("::SharedPtr");
    }

    public static String escapeCamlCase(String str) {
        String out = "";
        boolean previousLC = false;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c) && previousLC) {
                out = String.valueOf(out) + "_";
            }
            previousLC = Character.isLowerCase(c) || Character.isDigit(c);
            out = String.valueOf(out) + Character.toLowerCase(c);
            ++n2;
        }
        return out;
    }
}

