/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.utils;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillOperationalState;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillParameter;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.MessageUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.SkillUtils;
import org.eclipse.uml2.uml.NamedElement;

public class SkillRealizBuildUtils {
    public static String USER = "USER";

    public static List<String> calcDependencies(Map<SkillDefinition, SkillSemantic> skdefToSemanticsMap) {
        boolean _not;
        boolean _contains;
        String pkgName;
        ArrayList<String> dependencies = new ArrayList<String>();
        Set<SkillDefinition> _keySet = skdefToSemanticsMap.keySet();
        for (SkillDefinition definition : _keySet) {
            EList _ins = definition.getIns();
            EList _outs = definition.getOuts();
            Iterable _plus = Iterables.concat((Iterable)_ins, (Iterable)_outs);
            for (SkillParameter param : _plus) {
                pkgName = MessageUtils.getMessagePackage((NamedElement)SkillUtils.getType(param)).getName().toLowerCase();
                _contains = dependencies.contains(pkgName);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                dependencies.add(pkgName);
            }
        }
        Collection<SkillSemantic> _values = skdefToSemanticsMap.values();
        for (SkillSemantic semantics : _values) {
            EList _operational = semantics.getOperational();
            for (SkillOperationalState ops : _operational) {
                boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents(ops);
                if (!_doesConfigAndCoordOfComponents) continue;
                pkgName = MessageUtils.getMessagePackage((NamedElement)SkillUtils.getCompInterface(ops)).getName().toLowerCase();
                _contains = dependencies.contains(pkgName);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                dependencies.add(pkgName);
            }
        }
        return dependencies;
    }
}

