/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.cdteditor.sync;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.robotics.core.commands.PortCommands;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.papyrus.robotics.ros2.reverse.ParamInfo;
import org.eclipse.papyrus.robotics.ros2.reverse.PortInfo;
import org.eclipse.papyrus.robotics.ros2.reverse.fromfile.ReverseParametersFromSource;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.CreatePortUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ServiceDefUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class SyncParametersToModel {
    public static void sync(Class clazz, IASTTranslationUnit ast) {
        ReverseParametersFromSource paramFromSource = new ReverseParametersFromSource(clazz, ast);
        Class paramSet = ParameterUtils.getParameterClass((Class)clazz);
        paramFromSource.scanFunctions((IASTNode)ast);
        int i = 0;
        for (ParamInfo pi : paramFromSource.getParamInfos()) {
            Property paramUML = paramSet.getOwnedAttribute(pi.name, null);
            if (paramUML == null) {
                paramUML = (Property)paramSet.getOwnedAttributes().get(i);
                if (paramUML.getType() == pi.type) {
                    paramUML.setName(pi.name);
                } else {
                    paramUML = paramSet.createOwnedAttribute(pi.name, pi.type);
                }
            }
            ParameterEntry entry = (ParameterEntry)StereotypeUtil.applyApp((Element)paramUML, ParameterEntry.class);
            if (pi.defaultValue != null) {
                paramUML.setDefault(pi.defaultValue);
            }
            ++i;
        }
    }

    public static void renameOrCreate(Class clazz, PortInfo pi, Interface sd) {
        for (Port port : clazz.getOwnedPorts()) {
            Interface existingSD = InteractionUtils.getServiceDefinition((Port)port);
            if (existingSD != sd) continue;
            port.setName(pi.topic);
            return;
        }
        CreatePortUtils.createPort((Class)clazz, (PortInfo)pi, (Interface)sd);
    }

    public static void updateSD(Class clazz, Port port, PortInfo pi, Interface sd) {
        Class cs = (Class)port.getType();
        try {
            PortCommands.removeProvReq((Port)port).execute(null, null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
        if (ServiceDefUtils.isProvided((PortInfo.PortKind)pi.pk)) {
            cs.createInterfaceRealization(null, sd);
        } else {
            cs.createUsage((NamedElement)sd);
        }
    }
}

