/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.dashboard.ui.pages;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.robotics.dashboard.ui.pages.P4RProjectModelHyperlink;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.Bundle;

public class SystemIntegrationPage {
    public static final String ID = "System Integration";

    public ScrolledForm getPageBody(Composite container) {
        FormToolkit toolkit = new FormToolkit(container.getDisplay());
        final ScrolledForm composite = toolkit.createScrolledForm(container);
        composite.setText("Papyrus4Robotics Compositional Development Process");
        String path = "icons/robotics_system.png";
        Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrus.robotics.dashboard.ui");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)url);
        Image systemImage = imageDesc.createImage();
        composite.setImage(systemImage);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        composite.getBody().setLayout((Layout)layout);
        toolkit.createLabel(composite.getBody(), ID);
        toolkit.createLabel(composite.getBody(), "");
        Section section1 = toolkit.createSection(composite.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        td.colspan = 2;
        section1.setLayoutData((Object)td);
        section1.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                composite.reflow(true);
            }
        });
        section1.setText("System Creation");
        section1.setDescription("The system builder puts together systems from building blocks (i.e. software components).");
        Composite sectionClient = toolkit.createComposite((Composite)section1);
        sectionClient.setLayout((Layout)new GridLayout());
        P4RProjectModelHyperlink.create(toolkit, sectionClient, "Create a new system definition project", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"), "SystemConfiguration", true);
        P4RProjectModelHyperlink.create(toolkit, sectionClient, "Create a new system definition model", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"), "SystemConfiguration", false);
        section1.setClient((Control)sectionClient);
        Section section2 = toolkit.createSection(composite.getBody(), 450);
        TableWrapData td2 = new TableWrapData(256);
        td2.colspan = 2;
        section2.setLayoutData((Object)td2);
        section2.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                composite.reflow(true);
            }
        });
        section2.setText("Specify System");
        section2.setDescription("The system builder selects components (provided by component suppliers) from the ecosystem that performs the needed services. Matchmaking must be made on the basis of offered services and on other properties, e.g. the required accuracy.");
        Composite sectionClient2 = toolkit.createComposite((Composite)section2);
        sectionClient2.setLayout((Layout)new GridLayout());
        P4RProjectModelHyperlink.open(toolkit, sectionClient2, "Show available components", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"), "compdef.di");
        P4RProjectModelHyperlink.open(toolkit, sectionClient2, "Edit an existing system model", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"), "system");
        section2.setClient((Control)sectionClient2);
        Section section3 = toolkit.createSection(composite.getBody(), 450);
        TableWrapData td3 = new TableWrapData(256);
        td3.colspan = 2;
        section3.setLayoutData((Object)td3);
        section3.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                composite.reflow(true);
            }
        });
        section3.setText("System Usage");
        section3.setDescription("The system builder selects to use the system.");
        Composite sectionClient3 = toolkit.createComposite((Composite)section3);
        sectionClient3.setLayout((Layout)new GridLayout());
        ImageHyperlink is3_1 = toolkit.createImageHyperlink(sectionClient3, 64);
        Image imageCode = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD");
        is3_1.setText("Code generation");
        P4RProjectModelHyperlink.openAndShowMessage(toolkit, sectionClient3, "The programmer from the system integrator selects to use the system.", imageCode, ".system", "Right click on the system you want to generade code from, select Robotics menu and then select Generate ROS2 code");
        section3.setClient((Control)sectionClient3);
        return composite;
    }
}

