/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractRowCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class RowGroupExpandCollapseCommand
extends AbstractRowCommand {
    private final ColumnPositionCoordinate columnPositionCoordinate;

    public RowGroupExpandCollapseCommand(ILayer layer, int rowPosition) {
        this(layer, rowPosition, 0);
    }

    public RowGroupExpandCollapseCommand(ILayer layer, int rowPosition, int columnPosition) {
        super(layer, rowPosition);
        this.columnPositionCoordinate = new ColumnPositionCoordinate(layer, columnPosition);
    }

    protected RowGroupExpandCollapseCommand(RowGroupExpandCollapseCommand command) {
        super(command);
        this.columnPositionCoordinate = command.columnPositionCoordinate;
    }

    @Override
    public RowGroupExpandCollapseCommand cloneCommand() {
        return new RowGroupExpandCollapseCommand(this);
    }

    public ILayer getColumnPositionLayer() {
        return this.columnPositionCoordinate.getLayer();
    }

    public int getColumnPosition() {
        return this.columnPositionCoordinate.getColumnPosition();
    }

    public int getLocalColumnPosition(ILayer targetLayer) {
        ColumnPositionCoordinate positionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(this.columnPositionCoordinate, targetLayer);
        if (positionCoordinate != null) {
            return positionCoordinate.getColumnPosition();
        }
        return this.columnPositionCoordinate.getColumnPosition();
    }
}

