/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.painter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public final class ResourceHelper {
    private static Path tempDir = null;

    private ResourceHelper() {
    }

    public static Color getColor(String rgbString) {
        if (!JFaceResources.getColorRegistry().hasValueFor(rgbString)) {
            if (rgbString.startsWith("#")) {
                Integer intval = Integer.decode(rgbString);
                int i = intval;
                RGB rgb = new RGB(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
                JFaceResources.getColorRegistry().put(rgbString, rgb);
            } else {
                String rgbValues = rgbString.substring(rgbString.indexOf(40) + 1, rgbString.lastIndexOf(41));
                String[] values = rgbValues.split(",");
                try {
                    int red = Integer.valueOf(values[0].trim());
                    int green = Integer.valueOf(values[1].trim());
                    int blue = Integer.valueOf(values[2].trim());
                    JFaceResources.getColorRegistry().put(rgbString, new RGB(red, green, blue));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return JFaceResources.getColorRegistry().get(rgbString);
    }

    public static Font getFont(FontData ... fontDatas) {
        StringBuilder keyBuilder = new StringBuilder();
        FontData[] fontDataArray = fontDatas;
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            keyBuilder.append(fontData.toString());
            ++n2;
        }
        String key = keyBuilder.toString();
        if (!JFaceResources.getFontRegistry().hasValueFor(key)) {
            JFaceResources.getFontRegistry().put(key, fontDatas);
        }
        return JFaceResources.getFont((String)key);
    }

    public static Font getFont(Font currentFont, String name, Integer size) {
        FontData[] fontData;
        FontData[] original = currentFont.getFontData();
        FontData[] fontDataArray = fontData = Arrays.copyOf(original, original.length);
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            if (name != null) {
                data.setName(name);
            }
            if (size != null) {
                data.setHeight(size.intValue());
            }
            ++n2;
        }
        return ResourceHelper.getFont(fontData);
    }

    public static Font getBoldFont(Font currentFont) {
        FontData[] fontData;
        FontData[] original = currentFont.getFontData();
        FontData[] fontDataArray = fontData = Arrays.copyOf(original, original.length);
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(data.getStyle() | 1);
            ++n2;
        }
        return ResourceHelper.getFont(fontData);
    }

    public static Font getItalicFont(Font currentFont) {
        FontData[] fontData;
        FontData[] original = currentFont.getFontData();
        FontData[] fontDataArray = fontData = Arrays.copyOf(original, original.length);
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(data.getStyle() | 2);
            ++n2;
        }
        return ResourceHelper.getFont(fontData);
    }

    public static String ltrim(String s) {
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return s.substring(i);
    }

    public static String rtrim(String s) {
        int i = s.length() - 1;
        while (i >= 0 && Character.isWhitespace(s.charAt(i))) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public static URL getRichTextResource(String resource) {
        if (tempDir == null) {
            ResourceHelper.extractResources();
        }
        Finder finder = new Finder(resource);
        if (tempDir != null) {
            try {
                Files.walkFileTree(tempDir, finder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return finder.result;
    }

    private static void extractResources() {
        if (tempDir == null) {
            URL jarURL = ResourceHelper.class.getProtectionDomain().getCodeSource().getLocation();
            File jarFileReference = null;
            if (jarURL.getProtocol().equals("file")) {
                try {
                    String decodedPath = URLDecoder.decode(jarURL.getPath(), "UTF-8");
                    jarFileReference = new File(decodedPath);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    final Path jar = Files.createTempFile("richtext", ".jar", new FileAttribute[0]);
                    Files.copy(jarURL.openStream(), jar, StandardCopyOption.REPLACE_EXISTING);
                    jarFileReference = jar.toFile();
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                Files.delete(jar);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (jarFileReference != null) {
                try {
                    Throwable e = null;
                    Object var3_7 = null;
                    try (JarFile jarFile = new JarFile(jarFileReference);){
                        String unpackDirectory = System.getProperty("org.eclipse.nebula.widgets.richtext.jar.unpackdir");
                        Path path = tempDir = unpackDirectory == null ? Files.createTempDirectory("richtext", new FileAttribute[0]) : Files.createDirectories(Paths.get(unpackDirectory, new String[0]), new FileAttribute[0]);
                        if (unpackDirectory == null) {
                            Runtime.getRuntime().addShutdownHook(new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                            @Override
                                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                                Files.delete(file);
                                                return FileVisitResult.CONTINUE;
                                            }

                                            @Override
                                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                                Files.delete(dir);
                                                return FileVisitResult.CONTINUE;
                                            }
                                        });
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            File file;
                            JarEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (!name.startsWith("org/eclipse/nebula/widgets/richtext/resources") || (file = new File(String.valueOf(tempDir.toAbsolutePath()) + File.separator + name)).exists()) continue;
                            if (entry.isDirectory()) {
                                file.mkdirs();
                                continue;
                            }
                            Throwable throwable = null;
                            Object var11_17 = null;
                            try {
                                InputStream is = jarFile.getInputStream(entry);
                                try {
                                    try (FileOutputStream os = new FileOutputStream(file);){
                                        while (is.available() > 0) {
                                            ((OutputStream)os).write(is.read());
                                        }
                                    }
                                    if (is == null) continue;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (is != null) {
                                        is.close();
                                    }
                                    throw throwable;
                                }
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class Finder
    extends SimpleFileVisitor<Path> {
        private URL result;
        private String resource;

        Finder(String resource) {
            this.resource = resource;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.endsWith(this.resource)) {
                this.result = file.toFile().toURI().toURL();
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (dir.endsWith(this.resource)) {
                this.result = dir.toFile().toURI().toURL();
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

