/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.core.internal.exported;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.IFilter;

public final class FolderUtils {
    private FolderUtils() {
    }

    public static final void clearFolder(File folder) {
        File[] files;
        assert (folder != null);
        assert (folder.exists());
        assert (folder.isDirectory());
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderUtils.clearFolder(file);
            }
            file.delete();
            ++n2;
        }
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.getParent().exists()) {
            FolderUtils.createFolder((IFolder)folder.getParent());
        }
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static final void copyFolder(File srcDir, File destDir) throws IOException {
        FolderUtils.copyFolder(srcDir, destDir, new IFilter<String>(){

            @Override
            public boolean filter(String object) {
                return true;
            }
        });
    }

    public static final void copyFolder(File srcDir, File destDir, IFilter<String> filter) throws IOException {
        File[] filesList;
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File[] fileArray = filesList = srcDir.listFiles();
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File src = fileArray[n2];
            File dest = new File(destDir.getPath() + File.separator + src.getName());
            if (filter.filter(dest.getAbsolutePath())) {
                if (src.isDirectory()) {
                    FolderUtils.copyFolder(src, dest, filter);
                } else {
                    FileUtils.copyFile(src, dest);
                }
            }
            ++n2;
        }
    }
}

