/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdviceFactory;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdvicePackage;
import org.eclipse.papyrus.infra.emf.types.constraints.EndKind;
import org.eclipse.papyrus.infra.emf.types.constraints.EndPermission;
import org.eclipse.papyrus.infra.filters.FiltersFactory;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.papyrus.infra.filters.provider.FilteredElementItemProvider;

public class EndPermissionItemProvider
extends FilteredElementItemProvider {
    public EndPermissionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addEndKindPropertyDescriptor(object);
            this.addPermittedPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addEndKindPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EndPermission_endKind_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_EndPermission_endKind_feature", "_UI_EndPermission_type"), (EStructuralFeature)ConstraintAdvicePackage.Literals.END_PERMISSION__END_KIND, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addPermittedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EndPermission_permitted_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_EndPermission_permitted_feature", "_UI_EndPermission_type"), (EStructuralFeature)ConstraintAdvicePackage.Literals.END_PERMISSION__PERMITTED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ConstraintAdvicePackage.Literals.END_PERMISSION__END_FILTER);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/EndPermission"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        EndPermission endPermission = (EndPermission)object;
        EndKind endKind = endPermission.getEndKind();
        String typeString = endKind == null ? this.getString("_UI_EndPermission_type") : this.getString("_UI_EndPermission_type_" + endKind.name().toLowerCase());
        return typeString + " " + this.getPermissionModifier(endPermission);
    }

    protected String getPermissionModifier(EndPermission endPermission) {
        return this.getString(endPermission.isPermitted() ? "_UI_ReferencePermission_granted" : "_UI_ReferencePermission_denied");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(EndPermission.class)) {
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(FiltersPackage.Literals.FILTERED_ELEMENT__FILTER, ConstraintAdviceFactory.eINSTANCE.createElementTypeFilter()));
        newChildDescriptors.add(this.createChildParameter(ConstraintAdvicePackage.Literals.END_PERMISSION__END_FILTER, ConstraintAdviceFactory.eINSTANCE.createElementTypeFilter()));
        newChildDescriptors.add(this.createChildParameter(ConstraintAdvicePackage.Literals.END_PERMISSION__END_FILTER, FiltersFactory.eINSTANCE.createCompoundFilter()));
        newChildDescriptors.add(this.createChildParameter(ConstraintAdvicePackage.Literals.END_PERMISSION__END_FILTER, FiltersFactory.eINSTANCE.createEquals()));
        newChildDescriptors.add(this.createChildParameter(ConstraintAdvicePackage.Literals.END_PERMISSION__END_FILTER, FiltersFactory.eINSTANCE.createFilterReference()));
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        boolean qualify;
        Object childFeature = feature;
        Object childObject = child;
        boolean bl = qualify = childFeature == FiltersPackage.Literals.FILTERED_ELEMENT__FILTER || childFeature == ConstraintAdvicePackage.Literals.END_PERMISSION__END_FILTER;
        if (qualify) {
            return this.getString("_UI_CreateChild_text2", new Object[]{this.getTypeText(childObject), this.getFeatureText(childFeature), this.getTypeText(owner)});
        }
        return super.getCreateChildText(owner, feature, child, selection);
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        EReference reference;
        Object result = value;
        EReference eReference = reference = feature instanceof EReference ? (EReference)feature : null;
        if (reference != null && reference.isContainment() && FiltersPackage.Literals.FILTER.isSuperTypeOf(reference.getEReferenceType())) {
            final String pattern = this.getString(String.format("_UI_EndPermission_%s_role", feature.getName()));
            result = new DelegatingWrapperItemProvider(value, object, feature, index, this.adapterFactory){

                public String getText(Object object) {
                    return NLS.bind((String)pattern, (Object)super.getText(object));
                }
            };
        } else {
            result = super.createWrapper(object, feature, value, index);
        }
        return result;
    }
}

