/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultiLineTextCellEditor
extends TextCellEditor {
    private boolean lineWrap = true;

    public MultiLineTextCellEditor() {
        this(true);
    }

    public MultiLineTextCellEditor(boolean lineWrap) {
        this.commitOnEnter = false;
        this.lineWrap = lineWrap;
    }

    @Override
    public Text createEditorControl(Composite parent) {
        boolean openInline = this.editMode == EditModeEnum.INLINE;
        int style = HorizontalAlignmentEnum.getSWTStyle(this.cellStyle) | 2 | 0x800;
        if (!openInline) {
            style |= 0x200;
        }
        if (this.lineWrap) {
            style |= 0x40;
        } else if (!openInline) {
            style |= 0x100;
        }
        final Text textControl = super.createEditorControl(parent, style);
        if (!openInline) {
            GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo((Control)textControl);
        }
        if (openInline) {
            this.commitOnEnter = true;
            textControl.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent event) {
                    if ((event.keyCode == 13 || event.keyCode == 0x1000050) && event.stateMask == SWT.MOD3) {
                        textControl.insert(textControl.getLineDelimiter());
                    }
                }
            });
        }
        return textControl;
    }

    @Override
    public Rectangle calculateControlBounds(Rectangle cellBounds) {
        int widthHintForCompute = this.lineWrap ? cellBounds.width : -1;
        Point size = this.getEditorControl().computeSize(widthHintForCompute, -1);
        int diff = 0;
        if (this.lineWrap) {
            diff = size.x - cellBounds.width;
            size = this.getEditorControl().computeSize(widthHintForCompute - diff, -1);
        }
        int widthHint = widthHintForCompute - diff;
        this.getEditorControl().addModifyListener(e -> {
            Point p = this.getEditorControl().computeSize(widthHint, -1, true);
            Point loc = this.getEditorControl().getLocation();
            this.getEditorControl().setBounds(loc.x, loc.y, this.lineWrap ? rectangle.width : Math.max(p.x, rectangle.width), Math.max(p.y, rectangle.height));
        });
        return new Rectangle(cellBounds.x, cellBounds.y, this.lineWrap ? cellBounds.width : Math.max(size.x, cellBounds.width), Math.max(size.y, cellBounds.height));
    }

    public void setLineWrap(boolean lineWrap) {
        this.lineWrap = lineWrap;
    }
}

