/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.dataprovider;

import org.eclipse.papyrus.infra.nattable.dataprovider.RowLabelHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class HierarchicalRowLabelHeaderDataProvider
extends RowLabelHeaderDataProvider {
    public HierarchicalRowLabelHeaderDataProvider(INattableModelManager tableModelManager) {
        super(tableModelManager);
    }

    @Override
    public int getColumnCount() {
        if (this.displayLabel) {
            DisplayStyle style = TableHelper.getTableDisplayStyle(this.manager);
            if (DisplayStyle.NORMAL.equals((Object)style) || DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)style)) {
                return 1;
            }
            if (DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)style)) {
                boolean hasConfForFirstLevel = FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.manager.getTable(), 0);
                int maxDepth = FillingConfigurationUtils.getMaxDepthForTree(this.manager.getTable());
                int depth = maxDepth * 2;
                depth = !hasConfForFirstLevel ? ++depth : (depth += 2);
                return depth;
            }
        }
        return 0;
    }

    protected final int getDepth(ITreeItemAxis axis) {
        if (this.manager instanceof ITreeNattableModelManager) {
            return ((ITreeNattableModelManager)this.manager).getTreeItemDepth(axis);
        }
        return 0;
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        if (rowIndex >= 0) {
            int depth;
            Object rowElement = this.manager.getRowElement(rowIndex);
            DisplayStyle style = TableHelper.getTableDisplayStyle(this.manager.getTable());
            if (DisplayStyle.NORMAL.equals((Object)style) || DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)style)) {
                return rowElement;
            }
            if (DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)style) && rowElement instanceof ITreeItemAxis && (depth = this.getDepth((ITreeItemAxis)rowElement)) == columnIndex) {
                return rowElement;
            }
        }
        return "";
    }
}

