/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.uml.properties.databinding.MultiplicityObservableValue;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.uml2.uml.Extension;

public class ExtensionRequiredObservableValue
extends AbstractObservableValue
implements IChangeListener,
IObserving {
    private Extension extension;
    private MultiplicityObservableValue observable;
    private boolean currentValue;

    public ExtensionRequiredObservableValue(Extension extension, EditingDomain domain) {
        this.extension = extension;
        if (!this.extension.getOwnedEnds().isEmpty()) {
            this.observable = new MultiplicityObservableValue((EObject)this.extension.getOwnedEnds().get(0), domain);
            this.observable.addChangeListener(this);
        }
        this.currentValue = extension.isRequired();
    }

    public Object getValueType() {
        return Boolean.class;
    }

    protected Boolean doGetValue() {
        return this.extension.isRequired();
    }

    protected void doSetValue(Object value) {
        if (!(value instanceof Boolean)) {
            return;
        }
        Boolean required = (Boolean)value;
        if (this.extension.getOwnedEnds().isEmpty()) {
            Activator.log.warn("Unable to change the extension \"isRequired\" property");
        }
        this.observable.setValue(required != false ? "1" : "0..1");
        this.currentValue = required;
    }

    public Object getObserved() {
        return this.extension;
    }

    public void dispose() {
        this.observable.removeChangeListener(this);
        this.observable.dispose();
        this.observable = null;
        super.dispose();
    }

    public void handleChange(ChangeEvent event) {
        boolean newValue;
        final boolean oldValue = this.currentValue;
        this.currentValue = newValue = this.doGetValue().booleanValue();
        this.fireValueChange(new ValueDiff(){

            public Object getOldValue() {
                return oldValue;
            }

            public Object getNewValue() {
                return newValue;
            }
        });
    }
}

