/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.internal.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gmf.runtime.common.ui.util.IPartSelector;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.InsertAction;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.PromptingDeleteAction;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.PromptingDeleteFromModelAction;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.ToggleRouterAction;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.internationalization.common.editor.IInternationalizationEditor;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.sirius.editor.Activator;
import org.eclipse.papyrus.sirius.editor.internal.editor.PapyrusTabbar;
import org.eclipse.papyrus.sirius.editor.internal.editor.SiriusDiagramEditorInput;
import org.eclipse.papyrus.sirius.editor.sirius.ISiriusSessionService;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.model.business.internal.spec.DSemanticDiagramSpec;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode3EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainer2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramCommandStack;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.Tabbar;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class NestedSiriusDiagramViewEditor
extends DDiagramEditorImpl
implements IEditingDomainProvider,
IInternationalizationEditor,
IRevealSemanticElement {
    protected ServicesRegistry servicesRegistry;
    private Session session;
    private URI airdURI;
    private TransactionalEditingDomain editingDomain;
    private DSemanticDiagram diagram;
    private KeyHandler keyHandler;
    private CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            if (NestedSiriusDiagramViewEditor.this.getSite() != null && NestedSiriusDiagramViewEditor.this.getSite().getShell() != null && NestedSiriusDiagramViewEditor.this.getSite().getShell().getDisplay() != null) {
                NestedSiriusDiagramViewEditor.this.getSite().getShell().getDisplay().asyncExec(() -> NestedSiriusDiagramViewEditor.this.firePropertyChange(257));
            }
        }
    };

    public NestedSiriusDiagramViewEditor(ServicesRegistry servicesRegistry, DSemanticDiagram diagram) {
        this.servicesRegistry = servicesRegistry;
        ISaveAndDirtyService saveAndDirtyService = null;
        try {
            saveAndDirtyService = (ISaveAndDirtyService)servicesRegistry.getService(ISaveAndDirtyService.class);
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
        saveAndDirtyService.registerIsaveablePart((ISaveablePart)this);
        this.diagram = diagram;
        try {
            this.editingDomain = (TransactionalEditingDomain)servicesRegistry.getService(TransactionalEditingDomain.class);
            this.session = this.getCurrentSession();
            this.airdURI = diagram.eResource().getURI().appendFragment(diagram.eResource().getURIFragment((EObject)diagram));
            Assert.isNotNull((Object)this.diagram, (String)"The edited diagram is null. The Diagram Editor creation failed");
            Assert.isNotNull((Object)this.servicesRegistry, (String)"The papyrus ServicesRegistry is null. The Diagram Editor creation failed.");
            this.initializeEditingDomain();
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
    }

    private ISiriusSessionService getSiriusSessionService() {
        try {
            return (ISiriusSessionService)this.servicesRegistry.getService((Object)"org.eclipse.papyrus.sirius.editor.sirius.ISiriusSessionService");
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
            return null;
        }
    }

    private Session getCurrentSession() {
        ISiriusSessionService service = this.getSiriusSessionService();
        if (service != null) {
            return service.getSiriusSession();
        }
        return null;
    }

    public void initializeEditingDomain() {
        if (this.servicesRegistry == null) {
            return;
        }
        this.initDomainAndStack();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getSite().getPage().getActiveEditor() instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor editor = (IMultiDiagramEditor)this.getSite().getPage().getActiveEditor();
            IEditorPart activeEditor = editor.getActiveEditor();
            if (((Object)((Object)this)).equals(activeEditor)) {
                super.selectionChanged((IWorkbenchPart)activeEditor, selection);
                this.updateActions(this.getSelectionActions());
                this.rebuildStatusLine();
            } else {
                super.selectionChanged(part, selection);
            }
        } else {
            super.selectionChanged(part, selection);
        }
    }

    protected Tabbar createTabbar(Composite parentComposite, IDiagramWorkbenchPart part) {
        return new PapyrusTabbar(parentComposite, (IDiagramWorkbenchPart)this);
    }

    protected void initDomainAndStack() {
        this.editingDomain.getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    protected void configureDiagramEditDomain() {
        DiagramEditDomain editDomain = new DiagramEditDomain((IEditorPart)this);
        editDomain.setActionManager(this.createActionManager());
        this.setEditDomain((DefaultEditDomain)editDomain);
        if (editDomain != null) {
            CommandStack stack = editDomain.getCommandStack();
            if (stack != null) {
                stack.dispose();
            }
            DDiagramCommandStack diagramStack = new DDiagramCommandStack(this.getDiagramEditDomain());
            diagramStack.setOperationHistory(this.getOperationHistory());
            diagramStack.setUndoContext(this.getUndoContext());
            editDomain.setCommandStack((CommandStack)diagramStack);
        }
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        if (this.getCommandStack().canUndo()) {
            this.getCommandStack().getUndoCommand().getLabel().equals(Messages.InitializeHiddenElementsCommand_label);
        }
        if (this.getCommandStack().canUndo()) {
            this.getCommandStack().getUndoCommand().getLabel().equals(Messages.CreateAndStoreGMFDiagramCommand_label);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        ISiriusSessionService sessionService = this.getSiriusSessionService();
        sessionService.openSessions();
        sessionService.attachSession(this.diagram.getTarget());
        SiriusDiagramEditorInput diagramViewEditorInput = new SiriusDiagramEditorInput(this.diagram, this.airdURI, this.session);
        try {
            NestedSiriusDiagramViewEditor.super.init(site, (IEditorInput)diagramViewEditorInput);
        }
        catch (PartInitException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
    }

    public void doSetInput(IEditorInput input, boolean releaseEditorContents) throws CoreException {
        super.doSetInput(input, releaseEditorContents);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void revealSemanticElement(List<?> elementList) {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        if (graphicalViewer != null) {
            Iterator iter = graphicalViewer.getEditPartRegistry().values().iterator();
            IGraphicalEditPart researchedEditPart = null;
            ArrayList clonedList = new ArrayList(elementList);
            ArrayList<IGraphicalEditPart> partSelection = new ArrayList<IGraphicalEditPart>();
            while (iter.hasNext() && !clonedList.isEmpty()) {
                EditPart parentEP;
                EObject parentElement;
                Object currentEditPart = iter.next();
                if (currentEditPart instanceof ShapeCompartmentEditPart || !(currentEditPart instanceof DNodeContainerEditPart) && !(currentEditPart instanceof DNodeListElementEditPart) && !(currentEditPart instanceof DNodeContainer2EditPart) && !(currentEditPart instanceof DNode3EditPart) && !(currentEditPart instanceof DEdgeEditPart)) continue;
                EObject currentElement = EMFHelper.getEObject(currentEditPart);
                if (currentEditPart instanceof DNodeContainer2EditPart && currentElement == (parentElement = EMFHelper.getEObject((Object)(parentEP = ((DNodeContainer2EditPart)currentEditPart).getParent()))) || !clonedList.contains(currentElement)) continue;
                clonedList.remove(currentElement);
                researchedEditPart = (IGraphicalEditPart)currentEditPart;
                partSelection.add(researchedEditPart);
            }
            if (clonedList.isEmpty() || clonedList.size() == 1 && clonedList.get(0) == this.getDiagram().getElement()) {
                StructuredSelection sSelection = new StructuredSelection(partSelection);
                graphicalViewer.setSelection((ISelection)sSelection);
                if (!partSelection.isEmpty()) {
                    graphicalViewer.reveal((EditPart)partSelection.get(0));
                }
            }
        }
    }

    public void modifyPartName(String name) {
        this.setPartName(name);
    }

    public void refreshEditorPart() {
        if (this.getDiagramEditPart() == null) {
            return;
        }
        DRepresentation representation = this.getRepresentation();
        if (representation != null) {
            Session session = SessionManager.INSTANCE.getSession(representation.eContainer());
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RefreshRepresentationsCommand(session.getTransactionalEditingDomain(), (IProgressMonitor)new NullProgressMonitor(), new DRepresentation[]{representation}));
        }
    }

    protected KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            ActionRegistry registry = this.getActionRegistry();
            PromptingDeleteAction action = new PromptingDeleteAction((IWorkbenchPart)this);
            action.setText(DiagramUIMessages.DiagramEditor_Delete_from_Diagram);
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new InsertAction((IWorkbenchPart)this);
            action.setText("");
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            PromptingDeleteFromModelAction deleteModelAction = new PromptingDeleteFromModelAction((IWorkbenchPart)this);
            deleteModelAction.init();
            registry.registerAction((IAction)deleteModelAction);
            action = new DirectEditAction((IWorkbenchPart)this);
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ZoomInAction(this.getZoomManager());
            action.setText("");
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ZoomOutAction(this.getZoomManager());
            action.setText("");
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ToggleRouterAction(this.getSite().getPage());
            ((ToggleRouterAction)action).setPartSelector(new IPartSelector(){

                public boolean selects(IWorkbenchPart part) {
                    return part == this;
                }
            });
            action.setText("");
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            this.keyHandler.put(KeyStroke.getPressed((int)0x1000009, (int)0), this.getActionRegistry().getAction((Object)"insertSemantic"));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)100, (int)262144), this.getActionRegistry().getAction((Object)"deleteFromDiagramAction"));
            this.keyHandler.put(KeyStroke.getPressed((char)'\b', (int)8, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)"deleteFromModelAction"));
            this.keyHandler.put(KeyStroke.getPressed((char)'=', (int)61, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
            this.keyHandler.put(KeyStroke.getPressed((char)'-', (int)45, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
            this.keyHandler.put(KeyStroke.getPressed((char)'\f', (int)108, (int)262144), this.getActionRegistry().getAction((Object)"toggleRouter"));
            this.keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.keyHandler;
    }

    public ServicesRegistry getServicesRegistry() {
        return this.servicesRegistry;
    }

    public void dispose() {
        if (this.editingDomain != null && this.editingDomain.getCommandStack() != null) {
            this.editingDomain.getCommandStack().removeCommandStackListener(this.commandStackListener);
        }
        super.dispose();
    }

    protected void stopDiagramEventBrokerListener(TransactionalEditingDomain ted) {
        int nbGMFDiagramEditorsOfSameTED = 0;
        if (this.getSite() != null && this.getSite().getPage() != null) {
            IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editorPart = editorRef.getEditor(false);
                if (editorPart instanceof IMultiDiagramEditor) {
                    IMultiDiagramEditor papyrusEditor = (IMultiDiagramEditor)editorPart;
                    ServicesRegistry servReg = papyrusEditor.getServicesRegistry();
                    IPageManager pageM = null;
                    try {
                        pageM = (IPageManager)servReg.getService(IPageManager.class);
                    }
                    catch (ServiceException e) {
                        Activator.log.error("Unexpected Error", (Throwable)e);
                    }
                    for (Object tmp : pageM.allPages()) {
                        DSemanticDiagramSpec semD;
                        if (!(tmp instanceof DSemanticDiagramSpec) || !pageM.isOpen((Object)(semD = (DSemanticDiagramSpec)tmp))) continue;
                        ++nbGMFDiagramEditorsOfSameTED;
                    }
                }
                ++n2;
            }
        }
        if (nbGMFDiagramEditorsOfSameTED == 0 && ted != null) {
            DiagramEventBroker.stopListening((TransactionalEditingDomain)ted);
        }
    }
}

