/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.widgets;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.MultipleStringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.widgets.Composite;

public class MultiString
extends AbstractPropertyEditor {
    protected MultipleStringEditor editor;

    public MultiString(Composite parent, int style) {
        this.editor = this.createMultipleStringEditor(parent, style);
        super.setEditor((AbstractListEditor)this.editor);
    }

    protected MultipleStringEditor createMultipleStringEditor(Composite parent, int style) {
        return new MultipleStringEditor(parent, style);
    }

    public void setDirectCreationWithTreeViewer(boolean directCreationWithTreeViewer) {
        if (this.editor != null) {
            this.editor.setDirectCreationWithTreeViewer(directCreationWithTreeViewer);
        }
    }

    public boolean getDirectCreationWithTreeViewer() {
        return this.editor != null ? this.editor.isDirectCreationWithTreeViewer() : false;
    }

    @Override
    protected void doBinding() {
        ILabelProvider labelProvider;
        IStaticContentProvider provider;
        this.editor.setOrdered(this.input.isOrdered(this.propertyPath));
        this.editor.setUnique(this.input.isUnique(this.propertyPath));
        this.editor.setDirectCreation(this.input.getDirectCreation(this.propertyPath));
        ReferenceValueFactory factory = this.input.getValueFactory(this.propertyPath);
        if (factory != null) {
            this.editor.setFactory(this.input.getValueFactory(this.propertyPath));
        }
        if ((provider = this.input.getContentProvider(this.propertyPath)) != null) {
            this.editor.setContentProvider(provider);
        }
        if ((labelProvider = this.input.getLabelProvider(this.propertyPath)) != null) {
            this.editor.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
        if (this.getInputObservableList() instanceof ICommitListener) {
            this.editor.addCommitListener((ICommitListener)this.getInputObservableList());
        }
        super.doBinding();
    }

    public TreeViewer getViewer() {
        return this.editor.getViewer();
    }
}

