/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.profilemigration.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.Messages;
import org.eclipse.papyrus.toolsmiths.profilemigration.factory.IMigratorFactory;
import org.eclipse.papyrus.toolsmiths.profilemigration.factory.MigratorFactory;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.extensionPoint.AtomicMigratorRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.AtomicMigratorComparator;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.DifferenceTreeBuilder;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.ICompositeMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.IAtomicMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.preferences.ProfileMigrationPreferencePage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class MigratorProfileApplication {
    public static Package profiledModel;
    public static Profile appliedProfile;
    public static Comparison comparison;
    public static Set<Profile> newAppliedProfile;
    public static List<EObject> newStereotypeApplication;
    protected List<IAtomicMigrator> atomicList = new ArrayList<IAtomicMigrator>();
    protected List<ICompositeMigrator> compositeList = new ArrayList<ICompositeMigrator>();
    private static Map<String, String> cacheProfileToFile;

    static {
        newAppliedProfile = new HashSet<Profile>();
        newStereotypeApplication = new ArrayList<EObject>();
        cacheProfileToFile = new HashMap<String, String>();
    }

    public List<EObject> reapplyProfile(Package package_, Profile profile) {
        Resource profileAfterResource = profile.eResource();
        String path = this.getFileName(profile, profileAfterResource);
        if (path != null) {
            URI uri = URI.createFileURI((String)path);
            ResourceSetImpl profileBeforeResourceSet = new ResourceSetImpl();
            Resource profileBeforeResource = profileBeforeResourceSet.getResource(uri, true);
            this.migrateNewAppliedProfile(package_, profile, profileBeforeResource, profileAfterResource);
        } else {
            MessageDialog message = new MessageDialog(Display.getDefault().getActiveShell(), "Incorect file", null, "The selected path is incorect so the profile will just be reapply.", 2, new String[]{"OK"}, 0);
            message.open();
            package_.applyProfile(profile);
        }
        return newStereotypeApplication;
    }

    public Package migrateNewAppliedProfile(Package package_, Profile profile, Resource profileBeforeResource, Resource profileAfterResource) {
        profiledModel = package_;
        appliedProfile = profile;
        newAppliedProfile.clear();
        try {
            TreeNode rootTreeNode = this.getTreeNode((Notifier)profileBeforeResource, (Notifier)profileAfterResource);
            if (rootTreeNode != null) {
                new StereotypeApplicationRegistry(rootTreeNode, profiledModel);
                this.migrateNewAppliedProfile(profiledModel, rootTreeNode, profile, true);
            } else {
                profiledModel.applyProfile(profile);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return profiledModel;
    }

    protected TreeNode getTreeNode(Notifier before, Notifier after) {
        DefaultComparisonScope scope = new DefaultComparisonScope(after, before, null);
        EMFCompare comparator = EMFCompare.builder().build();
        comparison = comparator.compare((IComparisonScope)scope);
        DifferenceTreeBuilder builder = new DifferenceTreeBuilder(comparison);
        TreeNode differenceTree = builder.buildMatchTree();
        return differenceTree;
    }

    protected void migrateNewAppliedProfile(Package model, TreeNode treeNode, Profile profile, boolean shouldReapply) {
        this.atomicList.clear();
        this.compositeList.clear();
        this.initAtomicList(treeNode, MigratorFactory.INSTANCE);
        this.initCompositeList();
        this.postProcessing();
        if (shouldReapply) {
            model.applyProfile(appliedProfile);
        }
        for (IAtomicMigrator atomic : this.atomicList) {
            atomic.migrationAction();
        }
        for (Profile newProfile : newAppliedProfile) {
            newAppliedProfile.remove(newProfile);
            this.migrateNewAppliedProfile(model, treeNode, newProfile, false);
        }
    }

    protected void initAtomicList(TreeNode treeNode, IMigratorFactory migratorFactory) {
        this.atomicList.addAll(migratorFactory.instantiateMigrator(treeNode));
        for (TreeNode childNode : treeNode.getChildren()) {
            this.initAtomicList(childNode, migratorFactory);
        }
        this.atomicList.sort(new AtomicMigratorComparator());
    }

    private void postProcessing() {
        ArrayList<IAtomicMigrator> toRemove = new ArrayList<IAtomicMigrator>();
        for (AtomicMigratorRegistry.Descriptor descriptor : AtomicMigratorRegistry.INSTANCE.getRegistry()) {
            for (String replacement : descriptor.getErasedMigrators()) {
                for (IAtomicMigrator migrator : this.atomicList) {
                    if (toRemove.contains(migrator) || !migrator.getClass().getName().equals(replacement)) continue;
                    toRemove.add(migrator);
                }
            }
        }
        this.atomicList.removeAll(toRemove);
    }

    protected void initCompositeList() {
    }

    private static Shell getActiveShell() {
        Display display = Display.getDefault();
        Shell result = display.getActiveShell();
        if (result == null) {
            Shell[] shells;
            Shell[] shellArray = shells = display.getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (shell.getShells().length == 0) {
                    result = shell;
                }
                ++n2;
            }
        }
        return result;
    }

    private String getFileName(Profile profile, Resource profileAfterResource) {
        if (cacheProfileToFile.containsKey(((XMIResource)profileAfterResource).getID((EObject)profile))) {
            String path = cacheProfileToFile.get(((XMIResource)profileAfterResource).getID((EObject)profile));
            if (ProfileMigrationPreferencePage.getCachedFiles().contains(path)) {
                return path;
            }
            cacheProfileToFile.remove(((XMIResource)profileAfterResource).getID((EObject)profile));
        }
        FileDialog dialog = new FileDialog(MigratorProfileApplication.getActiveShell(), 4096);
        dialog.setText(NLS.bind((String)Messages.MigratorProfileApplicationDelegate_SelectFileDialogTitle, (Object)profile.getName()));
        dialog.setFilterExtensions(new String[]{"*.profile.uml", "*"});
        dialog.setFilterNames(new String[]{"Profiles", "All"});
        String path = dialog.open();
        if (path != null) {
            URI uri = URI.createFileURI((String)path);
            ResourceSetImpl profileBeforeResourceSet = new ResourceSetImpl();
            Resource profileBeforeResource = profileBeforeResourceSet.getResource(uri, true);
            TreeIterator iter = profileBeforeResource.getAllContents();
            while (iter.hasNext()) {
                EObject object = (EObject)iter.next();
                if (object instanceof Package) {
                    if (!(object instanceof Profile)) continue;
                    cacheProfileToFile.put(((XMIResource)profileBeforeResource).getID(object), path);
                    if (ProfileMigrationPreferencePage.getCachedFiles().contains(path)) continue;
                    ProfileMigrationPreferencePage.addFile((String)path);
                    continue;
                }
                iter.prune();
            }
        }
        return path;
    }
}

