/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.RetryingDeferredAction;
import org.eclipse.swt.widgets.Display;

public class AsynchronousCommand
extends AbstractCommand {
    private final TransactionalEditingDomain editingDomain;
    private final Executor executor;
    private Supplier<ICommand> futureCommand;
    private ICommand actualCommand;

    public AsynchronousCommand(String label, TransactionalEditingDomain editingDomain, Supplier<ICommand> futureCommand) {
        this(label, editingDomain, futureCommand, arg_0 -> ((Display)Display.getDefault()).asyncExec(arg_0));
    }

    public AsynchronousCommand(String label, List affectedFiles, TransactionalEditingDomain editingDomain, Supplier<ICommand> futureCommand) {
        this(label, affectedFiles, editingDomain, futureCommand, arg_0 -> ((Display)Display.getDefault()).asyncExec(arg_0));
    }

    public AsynchronousCommand(String label, TransactionalEditingDomain editingDomain, Supplier<ICommand> futureCommand, Executor executor) {
        super(label);
        this.editingDomain = editingDomain;
        this.futureCommand = futureCommand;
        this.executor = executor;
    }

    public AsynchronousCommand(String label, List affectedFiles, TransactionalEditingDomain editingDomain, Supplier<ICommand> futureCommand, Executor executor) {
        super(label, affectedFiles);
        this.editingDomain = editingDomain;
        this.futureCommand = futureCommand;
        this.executor = executor;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        RetryingDeferredAction.defer(this.executor, this::captureCommand);
        return CommandResult.newOKCommandResult();
    }

    private boolean captureCommand() {
        this.actualCommand = this.futureCommand.get();
        if (this.actualCommand != null) {
            if (!this.actualCommand.canExecute()) {
                this.actualCommand = UnexecutableCommand.INSTANCE;
            } else {
                try {
                    GMFUnsafe.write((TransactionalEditingDomain)this.editingDomain, (ICommand)this.actualCommand);
                }
                catch (InterruptedException | ExecutionException | RollbackException e) {
                    UMLDiagramEditorPlugin.log.error("Asynchronous command failed.", e);
                    this.actualCommand = UnexecutableCommand.INSTANCE;
                }
            }
        }
        return this.actualCommand != null;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.actualCommand == null) {
            return CommandResult.newErrorCommandResult((String)"Command execution was not captured");
        }
        if (!this.actualCommand.canRedo()) {
            return CommandResult.newCancelledCommandResult();
        }
        this.actualCommand.redo(progressMonitor, info);
        return this.actualCommand.getCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.actualCommand == null) {
            return CommandResult.newErrorCommandResult((String)"Command execution was not captured");
        }
        if (!this.actualCommand.canUndo()) {
            return CommandResult.newCancelledCommandResult();
        }
        this.actualCommand.undo(progressMonitor, info);
        return this.actualCommand.getCommandResult();
    }
}

