/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.library.RegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.metamodel.IRegisteredMetamodel;
import org.eclipse.papyrus.uml.extensionpoints.metamodel.RegisteredMetamodel;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private static List<IRegisteredLibrary> registeredLibraries;
    private static List<IRegisteredMetamodel> registeredMetamodels;
    private static List<IRegisteredProfile> registeredProfiles;

    public static List<IRegisteredLibrary> getRegisteredLibraries() {
        if (registeredLibraries == null) {
            registeredLibraries = RegisteredLibrary.getRegisteredLibraries();
        }
        return registeredLibraries;
    }

    public static void addRegisteredLibrary(IRegisteredLibrary lib) {
        if (registeredLibraries == null) {
            registeredLibraries = RegisteredLibrary.getRegisteredLibraries();
        }
        registeredLibraries.add(lib);
    }

    public static List<IRegisteredMetamodel> getRegisteredMetamodels() {
        if (registeredMetamodels == null) {
            registeredMetamodels = RegisteredMetamodel.getRegisteredMetamodels();
        }
        return registeredMetamodels;
    }

    public static void addRegisteredMetamodel(IRegisteredMetamodel lib) {
        if (registeredMetamodels == null) {
            registeredMetamodels = RegisteredMetamodel.getRegisteredMetamodels();
        }
        registeredMetamodels.add(lib);
    }

    public static List<IRegisteredProfile> getRegisteredProfiles() {
        if (registeredProfiles == null) {
            registeredProfiles = RegisteredProfile.getRegisteredProfiles();
        }
        return registeredProfiles;
    }

    public static IRegisteredProfile getRegisteredProfile(String name, String path) {
        Assert.isNotNull((Object)name);
        List<IRegisteredProfile> profiles = Registry.getRegisteredProfiles();
        int i = 0;
        while (i < profiles.size()) {
            IRegisteredProfile profile = profiles.get(i);
            if (name.equals(profile.getName())) {
                if (path == null) {
                    return profile;
                }
                if (path.equals(profile.getPath())) {
                    return profile;
                }
            }
            ++i;
        }
        return null;
    }

    public static void addRegisteredProfile(IRegisteredProfile lib) {
        if (registeredProfiles == null) {
            registeredProfiles = RegisteredProfile.getRegisteredProfiles();
        }
        registeredProfiles.add(lib);
    }
}

