/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.edit.CellEditorCreatedEvent;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditTypeEnum;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.InlineEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.EditCellCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.CellEditDialogFactory;
import org.eclipse.nebula.widgets.nattable.edit.gui.ICellEditDialog;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.event.ScrollEvent;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.handler.TransactionalCommandHandler;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TransactionalEditCellCommandHandler
extends TransactionalCommandHandler<EditCellCommand> {
    protected MouseWheelListener mouseWheelListener = null;
    protected ILayerListener scrollLayerListener = null;

    public TransactionalEditCellCommandHandler(TransactionalEditingDomain domain) {
        this(domain, "Edit Table Cell");
    }

    public TransactionalEditCellCommandHandler(TransactionalEditingDomain domain, String label) {
        super(domain, label);
    }

    public Class<EditCellCommand> getCommandClass() {
        return EditCellCommand.class;
    }

    @Override
    protected TransactionalCommandHandler.ExecutionStatusKind doCommand(EditCellCommand command) {
        ILayerCell cell = command.getCell();
        Composite parent = command.getParent();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        IEditableRule rule = (IEditableRule)configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", cell.getConfigLabels().getLabels());
        if (rule.isEditable(cell, configRegistry)) {
            return this.editCell(cell, parent, cell.getDataValue(), configRegistry);
        }
        return TransactionalCommandHandler.ExecutionStatusKind.FAIL_ROLLBACK;
    }

    protected TransactionalCommandHandler.ExecutionStatusKind editCell(ILayerCell cell, Composite parent, Object initialCanonicalValue, IConfigRegistry configRegistry) {
        TransactionalCommandHandler.ExecutionStatusKind result = TransactionalCommandHandler.ExecutionStatusKind.FAIL_ROLLBACK;
        try {
            Rectangle cellBounds = cell.getBounds();
            ILayer layer = cell.getLayer();
            int columnPosition = cell.getColumnPosition();
            int rowPosition = cell.getRowPosition();
            List configLabels = cell.getConfigLabels().getLabels();
            ICellEditor cellEditor = (ICellEditor)configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", configLabels);
            if (cellEditor.openInline(configRegistry, configLabels)) {
                MyInlineEditHandler editHandler = new MyInlineEditHandler(layer, columnPosition, rowPosition);
                Rectangle editorBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height));
                cellEditor.activateCell(parent, initialCanonicalValue, EditModeEnum.INLINE, (ICellEditHandler)editHandler, cell, configRegistry);
                Control editorControl = cellEditor.getEditorControl();
                if (editorControl != null && !editorControl.isDisposed()) {
                    editorControl.setBounds(editorBounds);
                    cellEditor.addEditorControlListeners();
                    this.addScrollListener(cellEditor);
                    layer.fireLayerEvent((ILayerEvent)new CellEditorCreatedEvent(cellEditor));
                }
                result = editHandler.isCommitted() ? TransactionalCommandHandler.ExecutionStatusKind.OK_COMPLETE : TransactionalCommandHandler.ExecutionStatusKind.OK_ROLLBACK;
            } else {
                ArrayList<ILayerCell> cells = new ArrayList<ILayerCell>(1);
                cells.add(cell);
                result = this.editCells(cells, parent, initialCanonicalValue, configRegistry);
            }
        }
        catch (OperationCanceledException e) {
            result = TransactionalCommandHandler.ExecutionStatusKind.FAIL_ROLLBACK;
        }
        catch (Exception e) {
            Activator.log.error("Uncaught exception in table cell editor activation.", (Throwable)e);
        }
        return result;
    }

    protected void addScrollListener(ICellEditor cellEditor) {
        final Control control = cellEditor.getEditorControl();
        if (control != null && !control.isDisposed()) {
            this.mouseWheelListener = new MouseWheelListener(){

                public void mouseScrolled(MouseEvent e) {
                    if (control != null && !control.isDisposed() && control.getParent() != null) {
                        control.getParent().forceFocus();
                    }
                }
            };
            this.scrollLayerListener = new ILayerListener(){

                public void handleLayerEvent(ILayerEvent event) {
                    if (event instanceof ScrollEvent && control != null && !control.isDisposed() && control.getParent() != null) {
                        control.getParent().forceFocus();
                    }
                }
            };
            control.addMouseWheelListener(this.mouseWheelListener);
            ((NatTable)control.getParent()).addLayerListener(this.scrollLayerListener);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    control.removeMouseWheelListener(TransactionalEditCellCommandHandler.this.mouseWheelListener);
                    ((NatTable)control.getParent()).removeLayerListener(TransactionalEditCellCommandHandler.this.scrollLayerListener);
                    control.removeDisposeListener((DisposeListener)this);
                }
            });
        }
    }

    protected TransactionalCommandHandler.ExecutionStatusKind editCells(List<ILayerCell> cells, Composite parent, Object initialCanonicalValue, IConfigRegistry configRegistry) {
        if (cells == null || cells.isEmpty()) {
            return TransactionalCommandHandler.ExecutionStatusKind.FAIL_ROLLBACK;
        }
        ICellEditor cellEditor = (ICellEditor)configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", cells.get(0).getConfigLabels().getLabels());
        if (!(cells.size() == 1 || cells.size() > 1 && TransactionalEditCellCommandHandler.supportMultiEdit(cells, cellEditor, configRegistry))) {
            return TransactionalCommandHandler.ExecutionStatusKind.FAIL_ROLLBACK;
        }
        TransactionalCommandHandler.ExecutionStatusKind result = TransactionalCommandHandler.ExecutionStatusKind.FAIL_ROLLBACK;
        ICellEditDialog dialog = CellEditDialogFactory.createCellEditDialog((Shell)(parent != null ? parent.getShell() : null), (Object)initialCanonicalValue, (ILayerCell)cells.get(0), (ICellEditor)cellEditor, (IConfigRegistry)configRegistry);
        int returnValue = dialog.open();
        if (returnValue == 0) {
            result = TransactionalCommandHandler.ExecutionStatusKind.OK_COMPLETE;
            for (ILayerCell selectedCell : cells) {
                Object editorValue = dialog.getCommittedValue();
                if (dialog.getEditType() != EditTypeEnum.SET) {
                    editorValue = dialog.calculateValue(selectedCell.getDataValue(), editorValue);
                }
                ILayer layer = selectedCell.getLayer();
                layer.doCommand((ILayerCommand)new UpdateDataCommand(layer, selectedCell.getColumnPosition(), selectedCell.getRowPosition(), editorValue));
            }
        }
        return result;
    }

    private static boolean supportMultiEdit(List<ILayerCell> cells, ICellEditor cellEditor, IConfigRegistry configRegistry) {
        for (ILayerCell cell : cells) {
            if (cellEditor.supportMultiEdit(configRegistry, cell.getConfigLabels().getLabels())) continue;
            return false;
        }
        return true;
    }

    private static class MyInlineEditHandler
    extends InlineEditHandler {
        private boolean committed;

        MyInlineEditHandler(ILayer layer, int columnPosition, int rowPosition) {
            super(layer, columnPosition, rowPosition);
        }

        public boolean commit(Object canonicalValue, SelectionLayer.MoveDirectionEnum direction) {
            boolean result = super.commit(canonicalValue, direction);
            this.committed = result || this.committed;
            return result;
        }

        boolean isCommitted() {
            return this.committed;
        }
    }
}

