/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.figures;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.activity.figures.CallBehaviorActionFigure;
import org.eclipse.papyrus.uml.diagram.common.draw2d.CenterLayout;
import org.eclipse.papyrus.uml.diagram.common.draw2d.InteractionFigure;
import org.eclipse.papyrus.uml.diagram.common.draw2d.LeftToolbarLayout;

public class InteractionUseFigure
extends CallBehaviorActionFigure {
    protected static String HEADER_NAME = "Ref";
    protected PapyrusWrappingLabel interactionHeader;
    protected RectangleFigure interactionLabelContainer;
    protected RectangleFigure interactionContentPane;
    protected WrappingLabel interactionNameLabel;

    public InteractionUseFigure() {
        this.createContents();
        this.setCornerDimensions(new Dimension());
    }

    protected void createContents() {
        this.add((IFigure)this.createInteractionFigureHeader());
        this.add((IFigure)this.createContentPane());
        this.setLayoutManager((LayoutManager)new InteractionUseLayoutManager());
    }

    protected RectangleFigure createContentPane() {
        this.interactionNameLabel = new PapyrusWrappingLabel();
        this.interactionContentPane = new RectangleFigure();
        this.interactionContentPane.setBorder((Border)new MarginBorder(5, 5, 5, 5));
        this.interactionContentPane.setFill(false);
        this.interactionContentPane.setOutline(false);
        this.interactionContentPane.setLayoutManager((LayoutManager)new CenterLayout());
        this.interactionContentPane.add((IFigure)this.interactionNameLabel);
        return this.interactionContentPane;
    }

    protected RectangleFigure createInteractionFigureHeader() {
        this.interactionHeader = new PapyrusWrappingLabel(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                Dimension preferredSize = super.getPreferredSize(wHint, hHint);
                if (preferredSize.width == 0) {
                    return preferredSize;
                }
                return new Dimension(preferredSize.width + 2, preferredSize.height + 2);
            }
        };
        this.interactionHeader.setText(HEADER_NAME);
        InteractionFigure interactionFigure = new InteractionFigure();
        interactionFigure.setBorder((Border)new MarginBorder(3, 3, 3, 3));
        interactionFigure.setLayoutManager((LayoutManager)new LeftToolbarLayout());
        interactionFigure.add((IFigure)this.interactionHeader);
        this.interactionLabelContainer = new RectangleFigure();
        this.interactionLabelContainer.setOutline(false);
        this.interactionLabelContainer.setFill(false);
        this.interactionLabelContainer.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.interactionLabelContainer.add((IFigure)interactionFigure, 0);
        return this.interactionLabelContainer;
    }

    public WrappingLabel getNameLabel() {
        return this.interactionNameLabel;
    }

    public ShapeCompartmentFigure getGMFContentContainer() {
        if (this.interactionContentPane.getChildren().size() > 0) {
            return (ShapeCompartmentFigure)this.interactionContentPane.getChildren().get(0);
        }
        return null;
    }

    protected class InteractionUseLayoutManager
    extends AbstractLayout {
        protected InteractionUseLayoutManager() {
        }

        public void layout(IFigure container) {
            List childrenList = container.getChildren();
            int i = 0;
            while (i < container.getChildren().size()) {
                IFigure currentFigure = (IFigure)childrenList.get(i);
                if (currentFigure.equals(InteractionUseFigure.this.interactionLabelContainer) || currentFigure.equals(InteractionUseFigure.this.interactionContentPane)) {
                    Rectangle bound = new Rectangle(((IFigure)childrenList.get(i)).getBounds());
                    bound.setSize(((IFigure)childrenList.get(i)).getPreferredSize());
                    bound.y = i > 0 ? ((IFigure)childrenList.get((int)(i - 1))).getBounds().getBottomLeft().y + 1 : InteractionUseFigure.this.getBounds().y;
                    ((IFigure)childrenList.get(i)).setBounds(bound);
                }
                ++i;
            }
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return new Dimension(-1, -1);
        }
    }
}

