/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.junit.utils.Duck;
import org.eclipse.papyrus.junit.utils.EditorUtils;
import org.eclipse.papyrus.junit.utils.PapyrusProjectUtils;
import org.eclipse.papyrus.junit.utils.ProjectUtils;
import org.eclipse.papyrus.junit.utils.rules.HouseKeeper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractHouseKeeperRule {
    private static final LoadingCache<Class<?>, Field[]> leakProneInstanceFields = CacheBuilder.newBuilder().maximumSize(128L).build(AbstractHouseKeeperRule.fieldCacheLoader(false));
    private static final LoadingCache<Class<?>, Field[]> leakProneStaticFields = CacheBuilder.newBuilder().maximumSize(128L).build(AbstractHouseKeeperRule.fieldCacheLoader(true));
    private static final Function<Object, HouseKeeper.Disposer<Object>> DISPOSER_FUNCTION;
    Object test;
    String testName;
    private List<Runnable> cleanUpActions;

    static {
        final LinkedHashMap disposers = Maps.newLinkedHashMap();
        ResourceSetDisposer.register(disposers);
        TransactionalEditingDomainDisposer.register(disposers);
        WorkspaceResourceDisposer.register(disposers);
        EditorDisposer.register(disposers);
        CollectionDisposer.register(disposers);
        MapDisposer.register(disposers);
        ReflectiveDisposer.register(disposers);
        DISPOSER_FUNCTION = new Function<Object, HouseKeeper.Disposer<Object>>(){
            private final Function<Object, HouseKeeper.Disposer<?>> nullFunction = Functions.constant(null);

            public HouseKeeper.Disposer<Object> apply(Object input) {
                Function resultFunction = this.nullFunction;
                for (Map.Entry next : disposers.entrySet()) {
                    if (!((Class)next.getKey()).isInstance(input)) continue;
                    resultFunction = (Function)next.getValue();
                    break;
                }
                HouseKeeper.Disposer result = (HouseKeeper.Disposer)resultFunction.apply(input);
                return result;
            }
        };
    }

    AbstractHouseKeeperRule() {
    }

    public final String getTestName() {
        return this.testName;
    }

    public <T> T cleanUpLater(T object, String disposer, Object ... arg) {
        MatcherAssert.assertThat((String)"No such disposal method", (Object)new Duck(object).understands(disposer, arg), (Matcher)CoreMatchers.is((Object)true));
        return (T)this.cleanUpLater(object, new ReflectiveDisposer(disposer, arg));
    }

    public <T> T cleanUpLater(T object, HouseKeeper.Disposer<? super T> disposer) {
        if (this.cleanUpActions == null) {
            this.cleanUpActions = Lists.newLinkedList();
        }
        this.cleanUpActions.add(0, new CleanUpAction(object, disposer));
        return object;
    }

    public <T> T cleanUpLater(T object) {
        HouseKeeper.Disposer disposer = (HouseKeeper.Disposer)DISPOSER_FUNCTION.apply(object);
        MatcherAssert.assertThat((String)"No built-in disposer available", (Object)disposer, (Matcher)CoreMatchers.notNullValue());
        return this.cleanUpLater(object, disposer);
    }

    public ResourceSet createResourceSet() {
        return this.cleanUpLater(new ResourceSetImpl(), ResourceSetDisposer.INSTANCE);
    }

    public TransactionalEditingDomain createSimpleEditingDomain() {
        return this.createSimpleEditingDomain(null);
    }

    public TransactionalEditingDomain createSimpleEditingDomain(ResourceSet resourceSet) {
        if (resourceSet == null) {
            resourceSet = this.createResourceSet();
        }
        return this.cleanUpLater(TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(resourceSet), TransactionalEditingDomainDisposer.INSTANCE);
    }

    public IProject createProject(String name) {
        try {
            return (IProject)this.cleanUpLater(ProjectUtils.createProject(name), WorkspaceResourceDisposer.INSTANCE);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    public IFile createFile(IProject project, String fileName, String templatePath) {
        Class<?> testClass = this.test instanceof Class ? (Class<?>)this.test : this.test.getClass();
        try {
            return (IFile)this.cleanUpLater(PapyrusProjectUtils.copyIFile(templatePath, FrameworkUtil.getBundle(testClass), project, fileName), WorkspaceResourceDisposer.INSTANCE);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    public IEditorPart openEditor(final IFile file) {
        final IEditorPart[] result = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = AbstractHouseKeeperRule.this.cleanUpLater(EditorUtils.openEditor(file), EditorDisposer.INSTANCE);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        });
        return result[0];
    }

    public IMultiDiagramEditor openPapyrusEditor(final IFile file) throws Exception {
        final IMultiDiagramEditor[] result = new IMultiDiagramEditor[1];
        final AtomicReference syncExecException = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = (IMultiDiagramEditor)AbstractHouseKeeperRule.this.cleanUpLater(EditorUtils.openPapyrusEditor(file), EditorDisposer.INSTANCE);
                }
                catch (Exception ex) {
                    syncExecException.set(ex);
                }
            }
        });
        if (syncExecException.get() != null) {
            throw (Exception)syncExecException.get();
        }
        return result[0];
    }

    @Deprecated
    public <T> T getField(String fieldName) {
        try {
            Field field = this.field(fieldName);
            Object result = field.get(this.test);
            this.cleanUpLater(field, new FieldDisposer());
            return (T)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)String.format("Could not access field %s of test instance.", fieldName));
            return null;
        }
    }

    Field field(String fieldName) {
        Field result = null;
        Class<?> next = this.getTestClass();
        while (result == null && next != null && next != Object.class) {
            try {
                result = next.getDeclaredField(fieldName);
                if (result != null) {
                    result.setAccessible(true);
                }
            }
            catch (Exception e) {
                result = null;
            }
            next = next.getSuperclass();
        }
        MatcherAssert.assertThat((String)String.format("Could not access field %s of test instance.", fieldName), (Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)String.format("Field is not %sstatic", this.isStatic() ? "" : "non-"), (Object)Modifier.isStatic(result.getModifiers()), (Matcher)CoreMatchers.is((Object)this.isStatic()));
        return result;
    }

    @Deprecated
    public <T> T setField(String fieldName, T value) {
        try {
            Field field = this.field(fieldName);
            field.set(this.test, value);
            this.cleanUpLater(field, new FieldDisposer());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)String.format("Could not access field %s of test instance.", fieldName));
        }
        return value;
    }

    abstract boolean isStatic();

    abstract Class<?> getTestClass();

    void registerAutoCleanups() {
        try {
            boolean staticFields = this.isStatic();
            Class<?> next = this.getTestClass();
            while (next != null && next != Object.class) {
                Field[] fieldArray = next.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    CleanUp cleanUp = field.getAnnotation(CleanUp.class);
                    if (cleanUp != null && Modifier.isStatic(field.getModifiers()) == staticFields && !Modifier.isFinal(field.getModifiers())) {
                        try {
                            field.setAccessible(true);
                            Class<HouseKeeper.Disposer<?>> disposerClass = cleanUp.value();
                            if (disposerClass == FieldDisposer.class) {
                                this.cleanUpLater(field, new FieldDisposer());
                            } else {
                                Object[] args;
                                Constructor<HouseKeeper.Disposer<?>> ctor;
                                if (disposerClass.getDeclaringClass() != null && (disposerClass.getModifiers() & 8) == 0) {
                                    ctor = disposerClass.getDeclaredConstructor(disposerClass.getDeclaringClass());
                                    args = new Object[]{this};
                                } else {
                                    ctor = disposerClass.getConstructor(new Class[0]);
                                    args = new Object[]{};
                                }
                                ctor.setAccessible(true);
                                HouseKeeper.Disposer<?> disposer = ctor.newInstance(args);
                                this.cleanUpLater(field.get(this.test), disposer);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                next = next.getSuperclass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void cleanUp() throws Exception {
        this.cleanUpLeakProneFields();
        if (this.cleanUpActions != null) {
            Exception toThrow = null;
            for (Runnable next : this.cleanUpActions) {
                try {
                    next.run();
                }
                catch (Exception e) {
                    if (e instanceof WrappedException) {
                        e = ((WrappedException)e).exception();
                    }
                    e.printStackTrace();
                    if (toThrow != null) continue;
                    toThrow = e;
                }
            }
            this.cleanUpActions = null;
            if (toThrow != null) {
                throw toThrow;
            }
        }
    }

    private void cleanUpLeakProneFields() {
        try {
            Field[] fields = this.isStatic() ? (Field[])leakProneStaticFields.get(this.getTestClass()) : (Field[])leakProneInstanceFields.get(this.getTestClass());
            int i = 0;
            while (i < fields.length) {
                fields[i].set(this.test, null);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static CacheLoader<Class<?>, Field[]> fieldCacheLoader(final boolean staticFields) {
        return new CacheLoader<Class<?>, Field[]>(){

            public Field[] load(Class<?> key) {
                ArrayList result = Lists.newArrayList();
                Class<?> next = key;
                while (next != null && next != Object.class) {
                    Field[] fieldArray = next.getDeclaredFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        if (Modifier.isStatic(field.getModifiers()) == staticFields && !Modifier.isFinal(field.getModifiers()) && AbstractHouseKeeperRule.isLeakProne(field)) {
                            try {
                                field.setAccessible(true);
                                result.add(field);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                    next = next.getSuperclass();
                }
                return (Field[])Iterables.toArray((Iterable)result, Field.class);
            }
        };
    }

    private static boolean isLeakProne(Field field) {
        Class<?> type = field.getType();
        return EObject.class.isAssignableFrom(type) || Resource.class.isAssignableFrom(type) || ResourceSet.class.isAssignableFrom(type) || EditingDomain.class.isAssignableFrom(type) || EditPart.class.isAssignableFrom(type) || Command.class.isAssignableFrom(type) || org.eclipse.gef.commands.Command.class.isAssignableFrom(type) || IUndoableOperation.class.isAssignableFrom(type) || ICommand.class.isAssignableFrom(type);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface CleanUp {
        public Class<? extends HouseKeeper.Disposer<?>> value() default FieldDisposer.class;
    }

    private static final class CleanUpAction
    implements Runnable {
        private final Object target;
        private final HouseKeeper.Disposer<Object> disposer;

        <T> CleanUpAction(T object, HouseKeeper.Disposer<? super T> disposer) {
            this.target = object;
            this.disposer = disposer;
        }

        @Override
        public void run() {
            try {
                this.disposer.dispose(this.target);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
    }

    private static final class CollectionDisposer
    implements HouseKeeper.Disposer<Collection<?>> {
        static final CollectionDisposer INSTANCE = new CollectionDisposer();

        private CollectionDisposer() {
        }

        static void register(Map<Class<?>, Function<Object, HouseKeeper.Disposer<?>>> disposers) {
            disposers.put(Collection.class, Functions.constant((Object)INSTANCE));
        }

        @Override
        public void dispose(Collection<?> object) throws Exception {
            object.clear();
        }
    }

    private static final class EditorDisposer
    implements HouseKeeper.Disposer<IEditorPart> {
        static final EditorDisposer INSTANCE = new EditorDisposer();

        private EditorDisposer() {
        }

        static void register(Map<Class<?>, Function<Object, HouseKeeper.Disposer<?>>> disposers) {
            disposers.put(IEditorPart.class, Functions.constant((Object)INSTANCE));
        }

        @Override
        public void dispose(final IEditorPart object) throws Exception {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchPage iWorkbenchPage = page = object.getSite() == null ? null : object.getSite().getPage();
                    if (page != null) {
                        try {
                            page.closeEditor(object, false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    private final class FieldDisposer
    implements HouseKeeper.Disposer<Field> {
        private FieldDisposer() {
        }

        @Override
        public void dispose(Field object) throws Exception {
            object.set(AbstractHouseKeeperRule.this.test, null);
        }
    }

    private static final class MapDisposer
    implements HouseKeeper.Disposer<Map<?, ?>> {
        static final MapDisposer INSTANCE = new MapDisposer();

        private MapDisposer() {
        }

        static void register(Map<Class<?>, Function<Object, HouseKeeper.Disposer<?>>> disposers) {
            disposers.put(Map.class, Functions.constant((Object)INSTANCE));
        }

        @Override
        public void dispose(Map<?, ?> object) throws Exception {
            object.clear();
        }
    }

    private static final class ReflectiveDisposer
    implements HouseKeeper.Disposer<Object> {
        static final ReflectiveDisposer INSTANCE = new ReflectiveDisposer("dispose", new Object[0]);
        private final String disposeMethod;
        private final Object[] arguments;

        ReflectiveDisposer(String methodName, Object ... arguments) {
            this.disposeMethod = methodName;
            this.arguments = arguments;
        }

        static void register(Map<Class<?>, Function<Object, HouseKeeper.Disposer<?>>> disposers) {
            disposers.put(Object.class, new Function<Object, HouseKeeper.Disposer<?>>(){

                public HouseKeeper.Disposer<?> apply(Object input) {
                    Duck duck = new Duck(input);
                    return duck.understands(INSTANCE.disposeMethod, INSTANCE.arguments) ? INSTANCE : null;
                }
            });
        }

        @Override
        public void dispose(Object object) throws Exception {
            new Duck(object).quack(this.disposeMethod, this.arguments);
        }
    }

    private static final class ResourceSetDisposer
    implements HouseKeeper.Disposer<ResourceSet> {
        static final ResourceSetDisposer INSTANCE = new ResourceSetDisposer();

        private ResourceSetDisposer() {
        }

        static void register(Map<Class<?>, Function<Object, HouseKeeper.Disposer<?>>> disposers) {
            disposers.put(ResourceSet.class, Functions.constant((Object)INSTANCE));
        }

        @Override
        public void dispose(ResourceSet object) {
            if (object instanceof ModelSet) {
                ((ModelSet)object).unload();
            }
            EMFHelper.unload((ResourceSet)object);
        }
    }

    private static final class TransactionalEditingDomainDisposer
    implements HouseKeeper.Disposer<TransactionalEditingDomain> {
        static final TransactionalEditingDomainDisposer INSTANCE = new TransactionalEditingDomainDisposer();

        private TransactionalEditingDomainDisposer() {
        }

        static void register(Map<Class<?>, Function<Object, HouseKeeper.Disposer<?>>> disposers) {
            disposers.put(TransactionalEditingDomain.class, Functions.constant((Object)INSTANCE));
        }

        @Override
        public void dispose(TransactionalEditingDomain object) {
            object.dispose();
        }
    }

    private static final class WorkspaceResourceDisposer
    implements HouseKeeper.Disposer<IResource> {
        static final WorkspaceResourceDisposer INSTANCE = new WorkspaceResourceDisposer();

        private WorkspaceResourceDisposer() {
        }

        static void register(Map<Class<?>, Function<Object, HouseKeeper.Disposer<?>>> disposers) {
            disposers.put(IResource.class, Functions.constant((Object)INSTANCE));
        }

        @Override
        public void dispose(IResource object) throws Exception {
            switch (object.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    object.delete(true, null);
                    break;
                }
                default: {
                    Assert.fail((String)("Cannot delete resource " + object));
                }
            }
        }
    }
}

