/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeAndLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.validation.AsyncValidateCommand;
import org.eclipse.uml2.uml.InteractionOperand;

public class ResizeOperandEditPolicy
extends GraphicalEditPolicy {
    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.activate();
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            EObject object;
            CompositeCommand compositeCommand = new CompositeCommand("Resize Operands");
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            List editParts = changeBoundsRequest.getEditParts();
            if (editParts.size() > 1) {
                return null;
            }
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            Object currentEditPart = editParts.get(0);
            this.updateCurrentChildSize(compositeCommand, changeBoundsRequest, editingDomain, currentEditPart);
            if (!compositeCommand.isEmpty() && currentEditPart instanceof IGraphicalEditPart && compositeCommand.canExecute() && (object = ((IGraphicalEditPart)currentEditPart).resolveSemanticElement()) instanceof InteractionOperand) {
                InteractionOperand operand = (InteractionOperand)object;
                AsyncValidateCommand.get((EObject)operand).ifPresent(arg_0 -> ((CompositeCommand)compositeCommand).add(arg_0));
            }
            return new ICommandProxy((ICommand)compositeCommand);
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return editingDomain;
    }

    private void updateCurrentChildSize(CompositeCommand compositeCommand, ChangeBoundsRequest changeBoundsRequest, TransactionalEditingDomain editingDomain, Object currentEditPart) {
        IGraphicalEditPart operandPart = (IGraphicalEditPart)currentEditPart;
        View shapeView = NotationHelper.findView((Object)operandPart);
        Dimension sizeDelta = changeBoundsRequest.getSizeDelta().getCopy();
        Point moveDelta = changeBoundsRequest.getMoveDelta().getCopy();
        IFigure operandFigure = operandPart.getFigure();
        PrecisionRectangle bounds = new PrecisionRectangle(operandFigure.getBounds());
        operandFigure.translateToAbsolute((Translatable)bounds);
        bounds.resize(sizeDelta);
        bounds.translate(moveDelta);
        operandFigure.translateToRelative((Translatable)bounds);
        IFigure cfFigure = ((IGraphicalEditPart)operandPart.getParent()).getFigure();
        bounds.translate(cfFigure.getBounds().getTopLeft().getNegated());
        SetResizeAndLocationCommand setBoundsCommand = new SetResizeAndLocationCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)shapeView), (Rectangle)bounds);
        compositeCommand.add((IUndoableOperation)setBoundsCommand);
    }
}

