/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.internal.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CreateFile {
    public static IFile createFile(String filePath, IContainer container, String content) throws Exception {
        IFile file = null;
        if (container instanceof IProject) {
            file = ((IProject)container).getFile(filePath);
        } else if (container instanceof IFolder) {
            file = ((IFolder)container).getFile(filePath);
        } else {
            throw new Exception("Cannot find the file " + filePath + " under " + container.getName());
        }
        IContainer parent = file.getParent();
        if (parent instanceof IFolder) {
            CreateFile.mkdirs((IFolder)parent);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
        if (file.exists()) {
            file.setContents((InputStream)stream, true, true, null);
        } else {
            file.create((InputStream)stream, true, null);
        }
        ((InputStream)stream).close();
        return file;
    }

    public static void mkdirs(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                CreateFile.mkdirs((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }

    public static String getContents(String relativePath, String resource, Class clazz) throws IOException {
        int read;
        InputStream resourceStream;
        String resourcePath = String.valueOf(relativePath) + '/' + resource;
        File sourcePrj = CreateFile.getSourceProject(clazz);
        JarFile jar = null;
        if (sourcePrj.isFile()) {
            jar = new JarFile(sourcePrj);
            JarEntry resEntry = jar.getJarEntry(resourcePath);
            resourceStream = jar.getInputStream(resEntry);
        } else {
            resourceStream = new FileInputStream(String.valueOf(sourcePrj.getAbsolutePath()) + "/" + resourcePath);
        }
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((read = resourceStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        outputStream.close();
        resourceStream.close();
        if (jar != null) {
            jar.close();
        }
        return outputStream.toString("iso-8859-1");
    }

    private static File getSourceProject(Class clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL location = codeSource.getLocation();
        File sourcePrj = new File(location.getFile());
        return sourcePrj;
    }

    public static void appendContents(IFile pagesFile, String data) throws IOException {
        File file = pagesFile.getLocation().toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fileWriter = new FileWriter(file, true);
        BufferedWriter buffWriter = new BufferedWriter(fileWriter);
        PrintWriter writer = new PrintWriter(buffWriter);
        writer.println(data);
        writer.close();
        buffWriter.close();
        fileWriter.close();
    }

    public static void replaceContents(IFile file, String template, String newContent) throws CoreException, IOException {
        String content = CreateFile.getContents(file).replace(template, newContent);
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
        if (file.exists()) {
            file.setContents((InputStream)stream, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        ((InputStream)stream).close();
    }

    public static String getContents(IFile iFile) throws IOException {
        String line;
        File file = iFile.getLocation().toFile();
        FileInputStream stream = new FileInputStream(file);
        StringBuffer contents = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        while ((line = br.readLine()) != null) {
            contents.append(line).append("\n");
        }
        br.close();
        stream.close();
        return contents.toString();
    }
}

