/**
 * Copyright (c) 2007, 2010, 2014 Borland Software Corporation, CEA, and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Borland) - [243151] explicit source/target for links
 * Michael Golubev (Montages) - API extracted to gmf.tooling.runtime, template migrated to Xtend2
 * Christian W. Damus (CEA) - bug 426732: override the cross-reference searches for views to use the CrossReferenceAdapter
 */
package aspects.xpt.diagram.updater;

import aspects.xpt.Common;
import aspects.xpt.editor.VisualIDRegistry;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Set;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramUpdater;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.papyrusgmfgenextension.CustomDiagramUpdaterSingleton;
import org.eclipse.papyrus.papyrusgmfgenextension.SpecificDiagramUpdater;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import xpt.Common_qvto;
import xpt.GenModelUtils_qvto;
import xpt.diagram.updater.LinkDescriptor;
import xpt.diagram.updater.NodeDescriptor;
import xpt.diagram.updater.UpdaterLinkType;
import xpt.diagram.updater.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class DiagramUpdater extends xpt.diagram.updater.DiagramUpdater {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private GenModelUtils_qvto _genModelUtils_qvto;
  
  @Inject
  private LinkDescriptor linkDescriptor;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private NodeDescriptor nodeDescriptor;
  
  @Inject
  private MetaModel xptMetaModel;
  
  public CharSequence diagramUpdaterInstanceToUse(final GenDiagramUpdater it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<CustomDiagramUpdaterSingleton, Boolean> _function = new Function1<CustomDiagramUpdaterSingleton, Boolean>() {
        @Override
        public Boolean apply(final CustomDiagramUpdaterSingleton v) {
          String _singletonPath = v.getSingletonPath();
          return Boolean.valueOf((!Objects.equal(_singletonPath, null)));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<CustomDiagramUpdaterSingleton>filter(Iterators.<CustomDiagramUpdaterSingleton>filter(it.eResource().getAllContents(), CustomDiagramUpdaterSingleton.class), _function));
      boolean _equals = (_size == 
        1);
      if (_equals) {
        final Function1<CustomDiagramUpdaterSingleton, Boolean> _function_1 = new Function1<CustomDiagramUpdaterSingleton, Boolean>() {
          @Override
          public Boolean apply(final CustomDiagramUpdaterSingleton v) {
            String _singletonPath = v.getSingletonPath();
            return Boolean.valueOf((!Objects.equal(_singletonPath, null)));
          }
        };
        String _singletonPath = IteratorExtensions.<CustomDiagramUpdaterSingleton>head(IteratorExtensions.<CustomDiagramUpdaterSingleton>filter(Iterators.<CustomDiagramUpdaterSingleton>filter(it.eResource().getAllContents(), CustomDiagramUpdaterSingleton.class), _function_1)).getSingletonPath();
        _builder.append(_singletonPath);
        _builder.newLineIfNotEmpty();
      } else {
        String _diagramUpdaterQualifiedClassName = it.getDiagramUpdaterQualifiedClassName();
        _builder.append(_diagramUpdaterQualifiedClassName);
        _builder.append(".INSTANCE");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence typeOfCrossReferenceAdapter() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter");
    return _builder;
  }
  
  @Override
  public CharSequence getSemanticChildrenMethodCall(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _diagramUpdaterInstanceToUse = this.diagramUpdaterInstanceToUse(this.diagramUpdater(it));
    _builder.append(_diagramUpdaterInstanceToUse);
    _builder.append(".");
    CharSequence _semanticChildrenMethodName = this.getSemanticChildrenMethodName(it);
    _builder.append(_semanticChildrenMethodName);
    return _builder;
  }
  
  @Override
  public CharSequence doGetSomeLinksMethodCall(final GenCommonBase it, final UpdaterLinkType linkType) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _diagramUpdaterInstanceToUse = this.diagramUpdaterInstanceToUse(
      this.diagramUpdater(it.getDiagram()));
    _builder.append(_diagramUpdaterInstanceToUse);
    _builder.append(".");
    CharSequence _linkGetterName = this.linkGetterName(it, linkType);
    _builder.append(_linkGetterName);
    return _builder;
  }
  
  public CharSequence _constructor(final GenDiagramUpdater it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected ");
    String _diagramUpdaterClassName = it.getDiagramUpdaterClassName();
    _builder.append(_diagramUpdaterClassName);
    _builder.append("(){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("//to prevent instantiation allowing the override");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence classSingleton(final GenDiagramUpdater it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<CustomDiagramUpdaterSingleton, Boolean> _function = new Function1<CustomDiagramUpdaterSingleton, Boolean>() {
        @Override
        public Boolean apply(final CustomDiagramUpdaterSingleton v) {
          String _singletonPath = v.getSingletonPath();
          return Boolean.valueOf((!Objects.equal(_singletonPath, null)));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<CustomDiagramUpdaterSingleton>filter(Iterators.<CustomDiagramUpdaterSingleton>filter(it.eResource().getAllContents(), CustomDiagramUpdaterSingleton.class), _function));
      boolean _notEquals = (_size != 1);
      if (_notEquals) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static final  ");
        String _diagramUpdaterQualifiedClassName = it.getDiagramUpdaterQualifiedClassName();
        _builder.append(_diagramUpdaterQualifiedClassName);
        _builder.append(" INSTANCE = new ");
        String _diagramUpdaterClassName = it.getDiagramUpdaterClassName();
        _builder.append(_diagramUpdaterClassName);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence DiagramUpdater(final GenDiagramUpdater it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className, "\t");
    _builder.append(" implements  org.eclipse.papyrus.infra.gmfdiag.common.updater.DiagramUpdater {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _classSingleton = this.classSingleton(it);
    _builder.append(_classSingleton, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence __constructor = this._constructor(it);
    _builder.append(__constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _isShortcutOrphaned = this.isShortcutOrphaned(it);
    _builder.append(_isShortcutOrphaned, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    final Function1<GenContainerBase, Boolean> _function = new Function1<GenContainerBase, Boolean>() {
      @Override
      public Boolean apply(final GenContainerBase container) {
        return Boolean.valueOf(DiagramUpdater.this._utils_qvto.hasSemanticChildren(container));
      }
    };
    Iterable<GenContainerBase> semanticContainers = IterableExtensions.<GenContainerBase>filter(it.getEditorGen().getDiagram().getAllContainers(), _function);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _genericSemanticChildrenOfView = this.getGenericSemanticChildrenOfView(it, semanticContainers);
    _builder.append(_genericSemanticChildrenOfView, "\t");
    _builder.newLineIfNotEmpty();
    {
      for(final GenContainerBase next : semanticContainers) {
        _builder.append("\t");
        CharSequence _semanticChildrenOfView = this.getSemanticChildrenOfView(next);
        _builder.append(_semanticChildrenOfView, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _phantomNodesIterator = this.getPhantomNodesIterator(it);
    _builder.append(_phantomNodesIterator, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _genericConnectedLinks = this.getGenericConnectedLinks(it, this._utils_qvto.getAllSemanticElements(it.getEditorGen().getDiagram()), UpdaterLinkType.CONTAINED);
    _builder.append(_genericConnectedLinks, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _genericConnectedLinks_1 = this.getGenericConnectedLinks(it, this._utils_qvto.getAllSemanticDiagramElements(it.getEditorGen().getDiagram()), UpdaterLinkType.INCOMING);
    _builder.append(_genericConnectedLinks_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _genericConnectedLinks_2 = this.getGenericConnectedLinks(it, this._utils_qvto.getAllSemanticDiagramElements(it.getEditorGen().getDiagram()), UpdaterLinkType.OUTGOING);
    _builder.append(_genericConnectedLinks_2, "\t");
    _builder.newLineIfNotEmpty();
    {
      Iterable<GenCommonBase> _allSemanticElements = this._utils_qvto.getAllSemanticElements(it.getEditorGen().getDiagram());
      for(final GenCommonBase e : _allSemanticElements) {
        _builder.append("\t");
        CharSequence _containedLinks = this.getContainedLinks(e);
        _builder.append(_containedLinks, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenLinkEnd> _allSemanticDiagramElements = this._utils_qvto.getAllSemanticDiagramElements(it.getEditorGen().getDiagram());
      for(final GenLinkEnd e_1 : _allSemanticDiagramElements) {
        _builder.append("\t");
        CharSequence _incomingLinks = this.getIncomingLinks(e_1);
        _builder.append(_incomingLinks, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenLinkEnd> _allSemanticDiagramElements_1 = this._utils_qvto.getAllSemanticDiagramElements(it.getEditorGen().getDiagram());
      for(final GenLinkEnd e_2 : _allSemanticDiagramElements_1) {
        _builder.append("\t");
        CharSequence _outgoingLinks = this.getOutgoingLinks(e_2);
        _builder.append(_outgoingLinks, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenLink> _allContainedLinks = this._utils_qvto.getAllContainedLinks(it.getEditorGen().getDiagram());
      for(final GenLink link : _allContainedLinks) {
        _builder.append("\t");
        CharSequence _containedLinksByTypeMethod = this.getContainedLinksByTypeMethod(link);
        _builder.append(_containedLinksByTypeMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenLink> _allIncomingLinks = this._utils_qvto.getAllIncomingLinks(it.getEditorGen().getDiagram());
      for(final GenLink link_1 : _allIncomingLinks) {
        _builder.append("\t");
        CharSequence _incomingLinksByTypeMethod = this.getIncomingLinksByTypeMethod(link_1);
        _builder.append(_incomingLinksByTypeMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<GenLink> _allOutgoingLinks = this._utils_qvto.getAllOutgoingLinks(it.getEditorGen().getDiagram());
      for(final GenLink link_2 : _allOutgoingLinks) {
        _builder.append("\t");
        CharSequence _outgoingLinksByTypeMethod = this.getOutgoingLinksByTypeMethod(link_2);
        _builder.append(_outgoingLinksByTypeMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _runtimeTypedInstance = this.runtimeTypedInstance(it);
    _builder.append(_runtimeTypedInstance, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getConnectedLinks(final GenCommonBase it, final Iterable<GenLink> genLinks, final UpdaterLinkType linkType, final boolean needCrossReferencer) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public ");
    CharSequence _listOfLinkDescriptors = this.listOfLinkDescriptors(it);
    _builder.append(_listOfLinkDescriptors, "\t\t");
    _builder.append(" ");
    CharSequence _linkGetterName = this.linkGetterName(it, linkType);
    _builder.append(_linkGetterName, "\t\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty = this._common_qvto.<GenLink>notEmpty(genLinks);
      if (_notEmpty) {
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(this._utils_qvto.getMetaClass(it), "modelElement", "view.getElement()");
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        {
          if (needCrossReferencer) {
            CharSequence _typeOfCrossReferenceAdapter = this.typeOfCrossReferenceAdapter();
            _builder.append(_typeOfCrossReferenceAdapter);
            _builder.append(" crossReferencer = ");
            CharSequence _typeOfCrossReferenceAdapter_1 = this.typeOfCrossReferenceAdapter();
            _builder.append(_typeOfCrossReferenceAdapter_1);
            _builder.append(".getCrossReferenceAdapter(view.eResource().getResourceSet());");
            _builder.newLineIfNotEmpty();
          }
        }
        CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(this.diagramUpdater(it), "result");
        _builder.append(_newLinkedListOfLinkDescriptors);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        {
          for(final GenLink link : genLinks) {
            CharSequence _colectConnectedLinks = this.colectConnectedLinks(link, linkType, needCrossReferencer, this._genModelUtils_qvto.isExternalInterface(this._utils_qvto.getMetaClass(it)));
            _builder.append(_colectConnectedLinks);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("return result;");
        _builder.newLine();
      } else {
        _builder.append("return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append(_newEmptyList);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence colectConnectedLinks(final GenLink it, final UpdaterLinkType linkType, final boolean needCrossReferencer, final boolean isExternalInterface) {
    StringConcatenation _builder = new StringConcatenation();
    {
      LinkModelFacet _modelFacet = it.getModelFacet();
      boolean _notEquals = (!Objects.equal(_modelFacet, null));
      if (_notEquals) {
        {
          if ((isExternalInterface && (!this._common_qvto.oclIsKindOf(it.getModelFacet(), FeatureLinkModelFacet.class)))) {
            _builder.append("if (");
            CharSequence _IsInstance = this.xptMetaModel.IsInstance(this._utils_qvto.getLinkEndType(it.getModelFacet(), linkType), "modelElement");
            _builder.append(_IsInstance);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("result.addAll(");
        CharSequence _chooseConnectedLinksByTypeMethodName = this.chooseConnectedLinksByTypeMethodName(it.getModelFacet(), linkType, it);
        _builder.append(_chooseConnectedLinksByTypeMethodName);
        _builder.append("(");
        {
          if ((isExternalInterface && (!this._common_qvto.oclIsKindOf(it.getModelFacet(), FeatureLinkModelFacet.class)))) {
            CharSequence _CastEObject = this.xptMetaModel.CastEObject(this._utils_qvto.getLinkEndType(it.getModelFacet(), linkType), "modelElement");
            _builder.append(_CastEObject);
          } else {
            _builder.append("modelElement");
          }
        }
        {
          if (needCrossReferencer) {
            _builder.append(", crossReferencer");
          }
        }
        _builder.append("));  ");
        _builder.newLineIfNotEmpty();
        {
          if ((isExternalInterface && (!this._common_qvto.oclIsKindOf(it.getModelFacet(), FeatureLinkModelFacet.class)))) {
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence getIncomingLinksByTypeMethod(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("   ");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "   ");
    _builder.newLineIfNotEmpty();
    _builder.append("   \t\t");
    _builder.append("protected java.util.Collection<");
    CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater(it));
    _builder.append(_qualifiedClassName, "   \t\t");
    _builder.append("> ");
    CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(it, 
      UpdaterLinkType.INCOMING);
    _builder.append(_connectedLinksByTypeMethodName, "   \t\t");
    _builder.append("(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getModelFacet().getTargetType());
    _builder.append(_QualifiedClassName, "   \t\t");
    _builder.append(" target, ");
    CharSequence _typeOfCrossReferenceAdapter = this.typeOfCrossReferenceAdapter();
    _builder.append(_typeOfCrossReferenceAdapter, "   \t\t");
    _builder.append(" crossReferencer) {");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(this.diagramUpdater(it), "result");
    _builder.append(_newLinkedListOfLinkDescriptors, " ");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("java.util.Collection<org.eclipse.emf.ecore.EStructuralFeature.Setting> settings = crossReferencer.getInverseReferences(target);");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("for (org.eclipse.emf.ecore.EStructuralFeature.Setting setting : settings) {");
    _builder.newLine();
    _builder.append("    ");
    CharSequence _incomingLinksByTypeMethodBody = this.getIncomingLinksByTypeMethodBody(it.getModelFacet(), it);
    _builder.append(_incomingLinksByTypeMethodBody, "    ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("}");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("return result;  ");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getICustomDiagramUpdater(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.papyrus.uml.diagram.common.part.ICustomDiagramUpdater<");
    CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(this.diagramUpdater(it));
    _builder.append(_qualifiedClassName);
    _builder.append(">");
    return _builder;
  }
  
  @Override
  public CharSequence getSemanticChildrenOfView(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<SpecificDiagramUpdater, Boolean> _function = new Function1<SpecificDiagramUpdater, Boolean>() {
        @Override
        public Boolean apply(final SpecificDiagramUpdater v) {
          return Boolean.valueOf((Objects.equal(v.getGenNode(), it) && (!Objects.equal(v.getClasspath(), null))));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<SpecificDiagramUpdater>filter(Iterators.<SpecificDiagramUpdater>filter(it.eResource().getAllContents(), SpecificDiagramUpdater.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        {
          final Function1<SpecificDiagramUpdater, Boolean> _function_1 = new Function1<SpecificDiagramUpdater, Boolean>() {
            @Override
            public Boolean apply(final SpecificDiagramUpdater v) {
              return Boolean.valueOf((Objects.equal(v.getGenNode(), it) && (!Objects.equal(v.getClasspath(), null))));
            }
          };
          Iterable<SpecificDiagramUpdater> _iterable = IteratorExtensions.<SpecificDiagramUpdater>toIterable(IteratorExtensions.<SpecificDiagramUpdater>filter(Iterators.<SpecificDiagramUpdater>filter(it.eResource().getAllContents(), SpecificDiagramUpdater.class), _function_1));
          for(final SpecificDiagramUpdater updater : _iterable) {
            _builder.append("public  ");
            CharSequence _listOfNodeDescriptors = this.listOfNodeDescriptors(it);
            _builder.append(_listOfNodeDescriptors);
            _builder.append(" ");
            CharSequence _semanticChildrenMethodName = this.getSemanticChildrenMethodName(it);
            _builder.append(_semanticChildrenMethodName);
            _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _iCustomDiagramUpdater = this.getICustomDiagramUpdater(it);
            _builder.append(_iCustomDiagramUpdater, "\t");
            _builder.append(" customUpdater = new ");
            String _classpath = updater.getClasspath();
            _builder.append(_classpath, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return customUpdater.getSemanticChildren(view);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
      } else {
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("public  ");
        CharSequence _listOfNodeDescriptors_1 = this.listOfNodeDescriptors(it);
        _builder.append(_listOfNodeDescriptors_1);
        _builder.append(" ");
        CharSequence _semanticChildrenMethodName_1 = this.getSemanticChildrenMethodName(it);
        _builder.append(_semanticChildrenMethodName_1);
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        {
          if ((this._common_qvto.<GenFeature>notEmpty(this._utils_qvto.getSemanticChildrenChildFeatures(it)) || this._common_qvto.<GenNode>notEmpty(this._utils_qvto.getPhantomNodes(it)))) {
            _builder.append("\t");
            CharSequence _defineModelElement = this.defineModelElement(it);
            _builder.append(_defineModelElement, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _newLinkedListOfNodeDescriptors = this.newLinkedListOfNodeDescriptors(this.diagramUpdater(it), "result");
            _builder.append(_newLinkedListOfNodeDescriptors, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            {
              Set<GenFeature> _semanticChildrenChildFeatures = this._utils_qvto.getSemanticChildrenChildFeatures(it);
              for(final GenFeature childMetaFeature : _semanticChildrenChildFeatures) {
                {
                  boolean _equals = Objects.equal(null, childMetaFeature);
                  if (_equals) {
                    _builder.append("\t");
                    _builder.append("{ \t/*FIXME no containment/child feature found in the genmodel, toolsmith need to specify Class here manually*/ childElement = ");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("/*FIXME no containment/child feature found in the genmodel, toolsmith need to specify correct one here manually*/;");
                    _builder.newLine();
                  } else {
                    boolean _isListType = childMetaFeature.isListType();
                    if (_isListType) {
                      _builder.append("\t");
                      _builder.append("for (java.util.Iterator<?> it = ");
                      CharSequence _featureValue = this.xptMetaModel.getFeatureValue(childMetaFeature, "modelElement", this._utils_qvto.getModelElementType(it));
                      _builder.append(_featureValue, "\t");
                      _builder.append(".iterator(); it.hasNext();) {");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t");
                      CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(childMetaFeature.getTypeGenClass(), "childElement", "it.next()", true);
                      _builder.append(_DeclareAndAssign, "\t");
                      _builder.newLineIfNotEmpty();
                    } else {
                      _builder.append("\t");
                      _builder.append("{ ");
                      CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(childMetaFeature.getTypeGenClass(), "childElement", "modelElement", 
                        this._utils_qvto.getModelElementType(it), childMetaFeature);
                      _builder.append(_DeclareAndAssign_1, "\t");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                }
                _builder.append("\t");
                _builder.append("String visualID = ");
                CharSequence _nodeVisualIDMethodCall = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(it.getDiagram());
                _builder.append(_nodeVisualIDMethodCall, "\t");
                _builder.append("(view, ");
                CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(childMetaFeature.getTypeGenClass(), "childElement");
                _builder.append(_DowncastToEObject, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                {
                  Iterable<GenNode> _semanticChildren = this._utils_qvto.getSemanticChildren(it, childMetaFeature);
                  for(final GenNode next : _semanticChildren) {
                    _builder.append("\t");
                    CharSequence _checkChildElementVisualID = this.checkChildElementVisualID(next, Boolean.valueOf(((!Objects.equal(null, childMetaFeature)) && childMetaFeature.isListType())));
                    _builder.append(_checkChildElementVisualID, "\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
            {
              boolean _notEmpty = this._common_qvto.<GenNode>notEmpty(this._utils_qvto.getPhantomNodes(it));
              if (_notEmpty) {
                _builder.append("\t");
                _builder.append("org.eclipse.emf.ecore.resource.Resource resource = modelElement.eResource();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.EObject> it = getPhantomNodesIterator(resource); it.hasNext();) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("org.eclipse.emf.ecore.EObject childElement = it.next();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if (childElement == modelElement) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("continue;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                {
                  Iterable<GenNode> _phantomNodes = this._utils_qvto.getPhantomNodes(it);
                  for(final GenNode phantom : _phantomNodes) {
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _addNextIfPhantom = this.addNextIfPhantom(phantom);
                    _builder.append(_addNextIfPhantom, "\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
            _builder.append("\t");
            _builder.append("return result;");
            _builder.newLine();
          } else {
            _builder.append("\t");
            _builder.append("return ");
            CharSequence _newEmptyList = this.newEmptyList();
            _builder.append(_newEmptyList, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence defineLinkSource(final TypeLinkModelFacet it, final boolean inLoop) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isListType = it.getSourceMetaFeature().isListType();
      if (_isListType) {
        _builder.append("java.util.List<?> sources = ");
        CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getSourceMetaFeature(), "link", it.getMetaClass());
        _builder.append(_featureValue);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("Object theSource = sources.size() == 1 ? sources.get(0) : null;");
        _builder.newLine();
        _builder.append("if (");
        CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getSourceType(), "theSource");
        _builder.append(_NotInstance);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
        _builder.append(_stopLinkProcessing, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(it.getSourceType(), "src", "theSource", true);
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(it.getSourceType(), "src", "link", it.getMetaClass(), it.getSourceMetaFeature());
        _builder.append(_DeclareAndAssign_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence isDiagram(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @Override
  public CharSequence defineLinkDestination(final TypeLinkModelFacet it, final Boolean inLoop) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isListType = it.getTargetMetaFeature().isListType();
      if (_isListType) {
        _builder.append("java.util.List<?> targets = ");
        CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getTargetMetaFeature(), "link", it.getMetaClass());
        _builder.append(_featureValue);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("Object theTarget = targets.size() == 1 ? targets.get(0) : null;");
        _builder.newLine();
        _builder.append("if (");
        CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getTargetType(), "theTarget");
        _builder.append(_NotInstance);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _stopLinkProcessing = this.stopLinkProcessing((inLoop).booleanValue());
        _builder.append(_stopLinkProcessing, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(it.getTargetType(), "dst", "theTarget", true);
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(it.getTargetType(), "dst", "link", it.getMetaClass(), it.getTargetMetaFeature());
        _builder.append(_DeclareAndAssign_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence getOutgoingLinksByTypeMethodSignature(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected java.util.Collection<");
    CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater(it));
    _builder.append(_qualifiedClassName);
    _builder.append("> ");
    CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(it, UpdaterLinkType.OUTGOING);
    _builder.append(_connectedLinksByTypeMethodName);
    _builder.append("(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getModelFacet().getSourceType());
    _builder.append(_QualifiedClassName);
    _builder.append(" source)");
    return _builder;
  }
  
  @Override
  public CharSequence getGenericSemanticChildrenOfView(final GenDiagramUpdater it, final Iterable<GenContainerBase> semanticContainers) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public ");
    CharSequence _listOfNodeDescriptors = this.listOfNodeDescriptors(it);
    _builder.append(_listOfNodeDescriptors, "\t\t");
    _builder.append(" getSemanticChildren(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty = this._common_qvto.<GenContainerBase>notEmpty(semanticContainers);
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("String vid = ");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
        _builder.append(_visualIDMethodCall, "\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (vid != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("switch (vid) {");
        _builder.newLine();
        {
          for(final GenContainerBase next : semanticContainers) {
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _semanticChildrenCase = this.getSemanticChildrenCase(next);
            _builder.append(_semanticChildrenCase, "\t\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _newEmptyList = this.newEmptyList();
    _builder.append(_newEmptyList, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  protected CharSequence _getContainedLinksByTypeMethod(final TypeLinkModelFacet it, final GenLink genLink) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected java.util.Collection<");
    CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater(genLink));
    _builder.append(_qualifiedClassName, "\t");
    _builder.append("> ");
    CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(genLink, UpdaterLinkType.CONTAINED);
    _builder.append(_connectedLinksByTypeMethodName, "\t");
    _builder.append("(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getChildMetaFeature().getGenClass());
    _builder.append(_QualifiedClassName, "\t");
    _builder.append(" container) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _containedLinksByTypeMethodBody = this.getContainedLinksByTypeMethodBody(it, genLink, false);
    _builder.append(_containedLinksByTypeMethodBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getGenericConnectedLinks(final GenDiagramUpdater it, final Iterable<? extends GenCommonBase> linkContainers, final UpdaterLinkType linkType) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _listOfLinkDescriptors = this.listOfLinkDescriptors(it);
    _builder.append(_listOfLinkDescriptors, "\t");
    _builder.append(" get");
    String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
    _builder.append(_linkMethodSuffix, "\t");
    _builder.append("Links(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty = this._common_qvto.notEmpty(linkContainers);
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("String vid = ");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
        _builder.append(_visualIDMethodCall, "\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (vid != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("switch (vid) {");
        _builder.newLine();
        {
          for(final GenCommonBase next : linkContainers) {
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _containedLinksCase = this.getContainedLinksCase(next, linkType);
            _builder.append(_containedLinksCase, "\t\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _newEmptyList = this.newEmptyList();
    _builder.append(_newEmptyList, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence runtimeTypedInstance(final GenDiagramUpdater it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  /**
   * XXX: [MG] suspicious code inside, EVEN after I moved ", " into the IF, there still may be problem if inner IF condition is not met.
   * Need to check with case when it.modelFacet.childMetaFeature == null
   */
  @Override
  public CharSequence checkChildElementVisualID(final GenNode it, final Boolean inLoop) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _visualID = VisualIDRegistry.visualID(it);
    _builder.append(_visualID);
    _builder.append(".equals(visualID)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("result.add(new ");
    CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(this.diagramUpdater(it.getDiagram()));
    _builder.append(_qualifiedClassName, "\t");
    _builder.append("(");
    {
      GenFeature _childMetaFeature = it.getModelFacet().getChildMetaFeature();
      boolean _notEquals = (!Objects.equal(null, _childMetaFeature));
      if (_notEquals) {
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getModelFacet().getChildMetaFeature().getTypeGenClass(), "childElement");
        _builder.append(_DowncastToEObject, "\t");
        _builder.append(", ");
      }
    }
    _builder.append("visualID));");
    _builder.newLineIfNotEmpty();
    {
      if ((inLoop).booleanValue()) {
        _builder.append("continue;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence checkLinkVisualID(final TypeLinkModelFacet it, final GenLink genLink, final boolean inLoop) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (!");
    CharSequence _visualID = VisualIDRegistry.visualID(genLink);
    _builder.append(_visualID);
    _builder.append(".equals(");
    CharSequence _linkWithClassVisualIDMethodCall = this.xptVisualIDRegistry.getLinkWithClassVisualIDMethodCall(genLink.getDiagram());
    _builder.append(_linkWithClassVisualIDMethodCall);
    _builder.append("(");
    CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getMetaClass(), "link");
    _builder.append(_DowncastToEObject);
    _builder.append("))) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
    _builder.append(_stopLinkProcessing, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getSemanticChildrenMethodName(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("get");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("_SemanticChildren");
    return _builder;
  }
  
  @Override
  protected CharSequence linkGetterName(final GenCommonBase it, final UpdaterLinkType linkType) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("get");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("_");
    String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
    _builder.append(_linkMethodSuffix);
    _builder.append("Links");
    return _builder;
  }
  
  @Override
  public CharSequence getConnectedLinksByTypeMethodName(final GenLink it, final UpdaterLinkType linkType) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("get");
    String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
    _builder.append(_linkMethodSuffix);
    CharSequence _connectedLinksByTypeMethodFragment = this.getConnectedLinksByTypeMethodFragment(it.getModelFacet());
    _builder.append(_connectedLinksByTypeMethodFragment);
    _builder.append("_");
    String _stringVisualID = this._common.stringVisualID(it);
    _builder.append(_stringVisualID);
    return _builder;
  }
  
  @Override
  protected CharSequence _getConnectedLinksByTypeMethodFragment(final TypeLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("TypeModelFacetLinks");
    return _builder;
  }
  
  @Override
  protected CharSequence _getConnectedLinksByTypeMethodFragment(final FeatureLinkModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("FeatureModelFacetLinks");
    return _builder;
  }
  
  @Override
  public CharSequence getContainedLinksByTypeMethod(final LinkModelFacet it, final GenLink genLink) {
    if (it instanceof FeatureLinkModelFacet) {
      return _getContainedLinksByTypeMethod((FeatureLinkModelFacet)it, genLink);
    } else if (it instanceof TypeLinkModelFacet) {
      return _getContainedLinksByTypeMethod((TypeLinkModelFacet)it, genLink);
    } else if (it != null) {
      return _getContainedLinksByTypeMethod(it, genLink);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, genLink).toString());
    }
  }
  
  @Override
  public CharSequence getConnectedLinksByTypeMethodFragment(final LinkModelFacet it) {
    if (it instanceof FeatureLinkModelFacet) {
      return _getConnectedLinksByTypeMethodFragment((FeatureLinkModelFacet)it);
    } else if (it instanceof TypeLinkModelFacet) {
      return _getConnectedLinksByTypeMethodFragment((TypeLinkModelFacet)it);
    } else if (it != null) {
      return _getConnectedLinksByTypeMethodFragment(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
