/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.wizard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.AbstractPasteImportInsertInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.ImportAxisAsInsertInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.ImportAxisAsPasteInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.InsertInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.PasteAxisInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.paste.PasteSeparator;
import org.eclipse.papyrus.infra.nattable.paste.TextDelimiter;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.PasteHelperUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.nattable.wizard.AbstractTableWizard;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ImportCSVConfigurationPage;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ImportFilePage;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ImportInvertedTableErrorPage;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ImportTableErrorPage;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.ui.IImportWizard;

public class ImportTableWizard
extends AbstractTableWizard
implements IImportWizard {
    private ImportFilePage importPage;
    private ImportCSVConfigurationPage csvConfigurationPage;
    private String importedText = "";
    private boolean useProgressMonitor = true;
    private boolean openDialog = true;
    private int preferredUserAction = -1;

    public ImportTableWizard() {
        this.setWindowTitle(Messages.ImportTableWizard_ImportTableFromFileInPapyrusModel);
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String path = "icons/importTablePapyrusWizban.png";
        ImageDescriptor desc = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImageDescriptor(pluginId, path);
        this.setDefaultPageImageDescriptor(desc);
    }

    public ImportTableWizard(String importedText, boolean useProgressMonitor, boolean openDialog, int preferredUserAction) {
        this();
        this.importedText = importedText;
        this.useProgressMonitor = useProgressMonitor;
        this.openDialog = openDialog;
        this.preferredUserAction = preferredUserAction;
    }

    public void addPages() {
        super.addPages();
        String pageTitle = Messages.ImportTableWizard_ImportTable;
        ImageDescriptor desc = null;
        if (this.manager != null) {
            if (this.manager.getTable().isInvertAxis()) {
                this.addPage((IWizardPage)new ImportInvertedTableErrorPage(Messages.ImportTableWizard_ImportTableError, pageTitle, desc));
            } else {
                this.importPage = new ImportFilePage(pageTitle, pageTitle, desc, this.manager);
                this.addPage((IWizardPage)this.importPage);
                this.csvConfigurationPage = new ImportCSVConfigurationPage(pageTitle, Messages.ImportTableWizard_ConfigureImport, desc, PasteSeparator.SEMICOLON, TextDelimiter.DOUBLE_QUOTE);
                this.addPage((IWizardPage)this.csvConfigurationPage);
            }
        } else {
            this.addPage((IWizardPage)new ImportTableErrorPage(Messages.ImportTableWizard_ImportTableError, pageTitle, desc));
        }
    }

    public boolean performFinish() {
        boolean isPasteWithOverwrite;
        File file = null;
        if (this.openDialog) {
            file = FileUtil.getFile((String)this.importPage.getFilePath());
        }
        CSVPasteHelper pasteHelper = new CSVPasteHelper(this.csvConfigurationPage.getSeparator(), this.csvConfigurationPage.getTextDelimiter(), ",");
        TableStructuredSelection currentSelection = ((NattableModelManager)this.manager).getSelectionInTable();
        TableSelectionWrapper tableSelectionWrapper = null;
        if (currentSelection != null && (tableSelectionWrapper = (TableSelectionWrapper)currentSelection.getAdapter(TableSelectionWrapper.class)).getSelectedCells().isEmpty()) {
            tableSelectionWrapper = null;
        }
        AbstractPasteImportInsertInNattableManager pasteManager = null;
        pasteManager = tableSelectionWrapper != null && (!tableSelectionWrapper.getFullySelectedColumns().isEmpty() || tableSelectionWrapper.getFullySelectedColumns().isEmpty() && tableSelectionWrapper.getFullySelectedRows().isEmpty() && !tableSelectionWrapper.getSelectedCells().isEmpty()) ? (file != null && this.openDialog ? new ImportAxisAsPasteInNattableManager(this.manager, pasteHelper, file, this.useProgressMonitor, this.openDialog, this.preferredUserAction, null, false) : new PasteAxisInNattableManager(this.manager, pasteHelper, this.useProgressMonitor, this.openDialog, this.preferredUserAction, null, this.importedText, false)) : (file != null && this.openDialog ? (!(isPasteWithOverwrite = PasteHelperUtils.isPasteWithOverwrite(this.manager, pasteHelper, this.createReader(file))) ? new ImportAxisAsPasteInNattableManager(this.manager, pasteHelper, file, this.useProgressMonitor, this.openDialog, this.preferredUserAction, tableSelectionWrapper, isPasteWithOverwrite) : new ImportAxisAsInsertInNattableManager(this.manager, pasteHelper, file, this.useProgressMonitor, this.openDialog, this.preferredUserAction, tableSelectionWrapper)) : (!(isPasteWithOverwrite = PasteHelperUtils.isPasteWithOverwrite(this.manager, pasteHelper, new StringReader(this.importedText))) ? new PasteAxisInNattableManager(this.manager, pasteHelper, this.useProgressMonitor, this.openDialog, this.preferredUserAction, tableSelectionWrapper, this.importedText, isPasteWithOverwrite) : new InsertInNattableManager(this.manager, pasteHelper, this.useProgressMonitor, this.openDialog, this.preferredUserAction, tableSelectionWrapper, this.importedText)));
        IStatus status = ((AbstractPasteImportInsertInNattableManager)pasteManager).doAction();
        return true;
    }

    protected Reader createReader(File file) {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        return reader;
    }
}

