/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Stereotype;

public class ModelMerge {
    private static final String TEXTUAL_REPRESENTATION_STEREOTYPE_NAME = "ActionLanguage::TextualRepresentation";
    protected List<EObject> originalElements = new BasicEList();
    protected List<EObject> replacementElements = new BasicEList();

    public void update(EObject target, EObject source) {
        if (source instanceof Package && target instanceof Package) {
            this.addReplacement(source, target);
            Package sourcePackage = (Package)source;
            Package targetPackage = (Package)target;
            ModelMerge.updateStereotypes((Element)targetPackage, (Element)sourcePackage);
            ModelMerge.setList(targetPackage.getOwnedComments(), sourcePackage.getOwnedComments());
            if (sourcePackage.isSetVisibility()) {
                targetPackage.setVisibility(sourcePackage.getVisibility());
            }
            targetPackage.setName(ModelMerge.nameOf((NamedElement)sourcePackage));
            if (ModelMerge.notStub((NamedElement)sourcePackage)) {
                this.updateCollection((List)targetPackage.getPackagedElements(), (List)sourcePackage.getPackagedElements());
            }
        } else if (source instanceof Activity && target instanceof Activity) {
            Activity sourceActivity = (Activity)source;
            Activity targetActivity = (Activity)target;
            this.updateClassifier((Classifier)targetActivity, (Classifier)sourceActivity);
            this.updateCollection((List)targetActivity.getOwnedParameters(), (List)sourceActivity.getOwnedParameters());
            targetActivity.setIsActive(sourceActivity.isActive());
            BehavioralFeature specification = sourceActivity.getSpecification();
            sourceActivity.setSpecification(null);
            targetActivity.setSpecification(specification);
            if (ModelMerge.notStub((NamedElement)sourceActivity)) {
                targetActivity.getNodes().clear();
                targetActivity.getEdges().clear();
                targetActivity.getOwnedNodes().addAll((Collection)sourceActivity.getOwnedNodes());
                targetActivity.getStructuredNodes().addAll((Collection)sourceActivity.getStructuredNodes());
                targetActivity.getEdges().addAll((Collection)sourceActivity.getEdges());
            }
        } else if (source instanceof Class && target instanceof Class) {
            Class sourceClass = (Class)source;
            Class targetClass = (Class)target;
            this.updateClassifier((Classifier)targetClass, (Classifier)sourceClass);
            targetClass.setIsActive(sourceClass.isActive());
            if (ModelMerge.notStub((NamedElement)sourceClass)) {
                Behavior sourceClassifierBehavior = sourceClass.getClassifierBehavior();
                this.updateCollection((List)targetClass.getOwnedAttributes(), (List)sourceClass.getOwnedAttributes());
                this.updateCollection((List)targetClass.getOwnedOperations(), (List)sourceClass.getOwnedOperations());
                this.updateCollection((List)targetClass.getOwnedReceptions(), (List)sourceClass.getOwnedReceptions());
                this.updateCollection((List)targetClass.getOwnedBehaviors(), (List)sourceClass.getOwnedBehaviors());
                this.updateCollection((List)targetClass.getNestedClassifiers(), (List)sourceClass.getNestedClassifiers());
                if (sourceClass.isActive()) {
                    Behavior targetClassifierBehavior = (Behavior)this.getReplacement((EObject)sourceClassifierBehavior);
                    if (targetClassifierBehavior == null) {
                        targetClassifierBehavior = sourceClassifierBehavior;
                    }
                    targetClass.setClassifierBehavior(targetClassifierBehavior);
                } else {
                    targetClass.setClassifierBehavior(null);
                }
            }
        } else if (source instanceof Enumeration && target instanceof Enumeration) {
            Enumeration sourceEnumeration = (Enumeration)source;
            Enumeration targetEnumeration = (Enumeration)target;
            this.updateClassifier((Classifier)targetEnumeration, (Classifier)sourceEnumeration);
            if (ModelMerge.notStub((NamedElement)sourceEnumeration)) {
                this.updateCollection((List)targetEnumeration.getOwnedLiterals(), (List)sourceEnumeration.getOwnedLiterals());
            }
        } else if (source instanceof DataType && target instanceof DataType) {
            DataType sourceType = (DataType)source;
            DataType targetType = (DataType)target;
            this.updateClassifier((Classifier)targetType, (Classifier)sourceType);
            if (ModelMerge.notStub((NamedElement)sourceType)) {
                this.updateCollection((List)targetType.getOwnedAttributes(), (List)sourceType.getOwnedAttributes());
            }
        } else if (source instanceof Signal && target instanceof Signal) {
            Signal sourceSignal = (Signal)source;
            Signal targetSignal = (Signal)target;
            this.updateClassifier((Classifier)targetSignal, (Classifier)sourceSignal);
            if (ModelMerge.notStub((NamedElement)sourceSignal)) {
                this.updateCollection((List)targetSignal.getOwnedAttributes(), (List)sourceSignal.getOwnedAttributes());
            }
        } else if (source instanceof Association && target instanceof Association) {
            Association sourceAssociation = (Association)source;
            Association targetAssociation = (Association)target;
            this.updateClassifier((Classifier)targetAssociation, (Classifier)sourceAssociation);
            if (ModelMerge.notStub((NamedElement)sourceAssociation)) {
                this.updateCollection((List)targetAssociation.getOwnedEnds(), (List)sourceAssociation.getOwnedEnds());
            }
        } else if (source instanceof Property && target instanceof Property) {
            this.addReplacement(source, target);
            Property sourceProperty = (Property)source;
            Property targetProperty = (Property)target;
            targetProperty.setVisibility(sourceProperty.getVisibility());
            targetProperty.setName(sourceProperty.getName());
            targetProperty.setType(sourceProperty.getType());
            targetProperty.setDefaultValue(sourceProperty.getDefaultValue());
            this.updateMultiplicityElement((MultiplicityElement)targetProperty, (MultiplicityElement)sourceProperty);
        } else if (source instanceof Operation && target instanceof Operation) {
            this.addReplacement(source, target);
            Operation sourceOperation = (Operation)source;
            Operation targetOperation = (Operation)target;
            ModelMerge.updateStereotypes((Element)targetOperation, (Element)sourceOperation);
            targetOperation.setVisibility(sourceOperation.getVisibility());
            targetOperation.setIsAbstract(sourceOperation.isAbstract());
            targetOperation.setName(sourceOperation.getName());
            this.updateCollection((List)targetOperation.getOwnedParameters(), (List)sourceOperation.getOwnedParameters());
        } else if (source instanceof Parameter && target instanceof Parameter) {
            this.addReplacement(source, target);
            Parameter sourceParameter = (Parameter)source;
            Parameter targetParameter = (Parameter)target;
            targetParameter.setVisibility(sourceParameter.getVisibility());
            targetParameter.setDirection(sourceParameter.getDirection());
            targetParameter.setName(sourceParameter.getName());
            targetParameter.setType(sourceParameter.getType());
            this.updateMultiplicityElement((MultiplicityElement)targetParameter, (MultiplicityElement)sourceParameter);
        } else if (source instanceof Reception && target instanceof Reception) {
            this.addReplacement(source, target);
            Reception sourceReception = (Reception)source;
            Reception targetReception = (Reception)target;
            ModelMerge.updateStereotypes((Element)targetReception, (Element)sourceReception);
            targetReception.setVisibility(sourceReception.getVisibility());
            targetReception.setIsAbstract(sourceReception.isAbstract());
            targetReception.setName(ModelMerge.nameOf((NamedElement)sourceReception));
            targetReception.setSignal(sourceReception.getSignal());
        }
    }

    public static <T extends Element> void setList(List<T> targetList, List<T> sourceList) {
        for (Element element : targetList) {
            ModelMerge.unapplyStereotypes(element);
        }
        targetList.clear();
        targetList.addAll(sourceList);
        for (Element element : targetList) {
            ModelMerge.updateAllStereotypes(element);
        }
    }

    protected static void unapplyStereotypes(Element element) {
        for (Stereotype stereotype : element.getAppliedStereotypes()) {
            element.unapplyStereotype(stereotype);
        }
    }

    protected static void updateStereotypes(Element target, Element source) {
        Map<String, Object> valueMap;
        HashMap stereotypeMap = new HashMap();
        for (Stereotype stereotype : source.getAppliedStereotypes()) {
            valueMap = new HashMap();
            stereotypeMap.put(stereotype, valueMap);
            for (Property attribute : stereotype.getAllAttributes()) {
                String name = attribute.getName();
                if (name.startsWith("base_")) continue;
                valueMap.put(name, source.getValue(stereotype, name));
            }
        }
        ModelMerge.unapplyStereotypes(target);
        for (Stereotype stereotype : stereotypeMap.keySet()) {
            target.applyStereotype(stereotype);
            valueMap = (Map)stereotypeMap.get(stereotype);
            for (String name : valueMap.keySet()) {
                target.setValue(stereotype, name, valueMap.get(name));
            }
        }
    }

    protected static void updateAllStereotypes(Element element) {
        ModelMerge.updateStereotypes(element, element);
        for (Element ownedElement : element.getOwnedElements()) {
            ModelMerge.updateAllStereotypes(ownedElement);
        }
    }

    private void updateComments(List<Comment> targetComments, List<Comment> sourceComments) {
        Comment targetSpecification = ModelMerge.getTextualRepresentation(targetComments);
        Comment sourceSpecification = ModelMerge.getTextualRepresentation(sourceComments);
        if (targetSpecification != null) {
            if (sourceSpecification == null) {
                targetComments.remove(targetSpecification);
                ModelMerge.setList(targetComments, sourceComments);
                targetComments.add(targetSpecification);
            } else {
                ModelMerge.setList(targetComments, sourceComments);
            }
        } else {
            ModelMerge.setList(targetComments, sourceComments);
        }
    }

    protected void updateClassifier(Classifier target, Classifier source) {
        this.addReplacement((EObject)source, (EObject)target);
        ModelMerge.updateStereotypes((Element)target, (Element)source);
        ModelMerge.setList(target.getGeneralizations(), source.getGeneralizations());
        ModelMerge.setList(target.getTemplateBindings(), source.getTemplateBindings());
        target.setName(ModelMerge.nameOf((NamedElement)source));
        if (source.isSetVisibility()) {
            target.setVisibility(source.getVisibility());
        }
        target.setIsAbstract(source.isAbstract());
        target.setOwnedTemplateSignature(source.getOwnedTemplateSignature());
        if (ModelMerge.notStub((NamedElement)source)) {
            this.updateComments((List<Comment>)target.getOwnedComments(), (List<Comment>)source.getOwnedComments());
        } else {
            Comment sourceTextualRepresentation;
            EList targetComments = target.getOwnedComments();
            EList sourceComments = source.getOwnedComments();
            Comment targetTextualRepresentation = ModelMerge.getTextualRepresentation((List<Comment>)targetComments);
            if (targetTextualRepresentation != null) {
                targetComments.remove(targetTextualRepresentation);
            }
            if ((sourceTextualRepresentation = ModelMerge.getTextualRepresentation((List<Comment>)sourceComments)) != null) {
                sourceComments.remove(sourceTextualRepresentation);
            }
            ModelMerge.setList(targetComments, sourceComments);
            if (targetTextualRepresentation != null) {
                targetComments.add(targetTextualRepresentation);
            }
        }
    }

    protected static Comment getTextualRepresentation(List<Comment> comments) {
        for (Comment comment : comments) {
            if (comment.getAppliedStereotype(TEXTUAL_REPRESENTATION_STEREOTYPE_NAME) == null) continue;
            return comment;
        }
        return null;
    }

    protected void updateMultiplicityElement(MultiplicityElement target, MultiplicityElement source) {
        ModelMerge.updateStereotypes((Element)target, (Element)source);
        target.setLower(source.getLower());
        target.setUpper(source.getUpper());
        target.setIsOrdered(source.isOrdered());
        target.setIsUnique(source.isUnique());
    }

    public <T extends NamedElement> void updateCollection(List<T> targetCollection, List<T> sourceCollection) {
        List<T> unmatchedElements = this.updateAll(targetCollection, sourceCollection);
        for (NamedElement element : unmatchedElements) {
            element.destroy();
        }
    }

    public <T extends NamedElement> List<T> updateAll(List<T> targetCollection, List<T> sourceCollection) {
        BasicEList sourceCollectionCopy = new BasicEList(sourceCollection);
        BasicEList targetCollectionCopy = new BasicEList(targetCollection);
        for (NamedElement sourceElement : sourceCollectionCopy) {
            NamedElement targetElement = ModelMerge.findTargetElement(targetCollectionCopy, sourceElement);
            if (targetElement != null) {
                this.update((EObject)targetElement, (EObject)sourceElement);
                continue;
            }
            sourceElement.setName(ModelMerge.nameOf(sourceElement));
            targetCollection.add(sourceElement);
            ModelMerge.updateAllStereotypes((Element)sourceElement);
        }
        return targetCollectionCopy;
    }

    protected static <T extends NamedElement> T findTargetElement(List<T> collection, T sourceElement) {
        java.lang.Class<?> kind = sourceElement.getClass();
        String name = ModelMerge.nameOf(sourceElement);
        for (NamedElement targetElement : collection) {
            String targetName = targetElement.getName();
            if (kind != targetElement.getClass() || (name != null || targetName != null) && (name == null || !name.equals(targetName))) continue;
            collection.remove(targetElement);
            return (T)targetElement;
        }
        return null;
    }

    protected static String nameOf(NamedElement element) {
        String name = element.getName();
        return ModelMerge.isStubName(name) ? name.substring(0, name.length() - 5) : name;
    }

    protected static boolean notStub(NamedElement element) {
        return !ModelMerge.isStubName(element.getName());
    }

    protected static boolean isStubName(String name) {
        return name != null && name.endsWith("$stub");
    }

    protected static boolean isMethodName(String name) {
        return name != null && name.matches(".+\\\\$method\\\\$[0-9]+");
    }

    protected void clearReplacements() {
        this.originalElements.clear();
        this.replacementElements.clear();
    }

    protected void addReplacement(EObject originalElement, EObject replacementElement) {
        this.originalElements.add(originalElement);
        this.replacementElements.add(replacementElement);
    }

    protected EObject getReplacement(EObject originalElement) {
        int i = this.originalElements.indexOf(originalElement);
        if (i < 0) {
            return null;
        }
        return this.replacementElements.get(i);
    }

    public void applyReplacements(EObject context) {
        ModelMerge.replaceAll(context, this.originalElements, this.replacementElements);
    }

    public static void replaceAll(EObject context, List<EObject> elements, List<EObject> newElements) {
        Map map = EcoreUtil.UsageCrossReferencer.findAll(elements, (EObject)context);
        int i = 0;
        while (i < elements.size()) {
            EObject element = elements.get(i);
            EObject newElement = newElements.get(i);
            Collection settings = (Collection)map.get(element);
            if (settings != null) {
                ModelMerge.replace(settings, element, newElement);
            }
            ++i;
        }
    }

    private static void replace(Collection<EStructuralFeature.Setting> settings, EObject element, EObject newElement) {
        for (EStructuralFeature.Setting setting : settings) {
            EStructuralFeature feature = setting.getEStructuralFeature();
            if (!feature.isChangeable()) continue;
            EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)element, (Object)newElement);
        }
    }
}

