/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.wizards.pages;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.pages.Messages;
import org.eclipse.papyrus.gmf.internal.bridge.wizards.pages.WizardInput;
import org.eclipse.papyrus.gmf.mappings.FeatureInitializer;
import org.eclipse.papyrus.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.papyrus.gmf.mappings.GMFMapFactory;
import org.eclipse.papyrus.gmf.mappings.LinkMapping;
import org.eclipse.papyrus.gmf.mappings.Mapping;
import org.eclipse.papyrus.gmf.mappings.MappingEntry;
import org.eclipse.papyrus.gmf.mappings.NodeMapping;
import org.eclipse.papyrus.gmf.mappings.NodeReference;
import org.eclipse.papyrus.gmf.mappings.TopNodeReference;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class EntriesPage
extends WizardPage {
    private final WizardInput myHolder;

    public EntriesPage(WizardInput input) {
        super("entriesPage");
        this.myHolder = input;
        this.setTitle(Messages.mapPageTitle);
        this.setDescription(Messages.mapPageDesc);
    }

    protected Mapping getMapInstance() {
        return this.myHolder.getMapping();
    }

    protected WizardInput getHolder() {
        return this.myHolder;
    }

    public void createControl(Composite parent) {
        this.setControl((Control)new PageControl(parent));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ((PageControl)this.getControl()).populate();
        }
    }

    private class ChangePropertiesDialog
    extends Dialog {
        private Object[] mySelection;

        protected ChangePropertiesDialog(Shell parentShell, Object[] selection) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.mySelection = selection;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite frame = new Composite(composite, 2048);
            GridData layoutData = new GridData(1808);
            layoutData.heightHint = 300;
            layoutData.widthHint = 400;
            frame.setLayoutData((Object)layoutData);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            frame.setLayout((Layout)layout);
            PropertySheetPage propertyPage = new PropertySheetPage();
            propertyPage.createControl(frame);
            propertyPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(EntriesPage.this.myHolder.getAdapterFactory()));
            propertyPage.selectionChanged(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart(), (ISelection)new StructuredSelection(this.mySelection));
            propertyPage.getControl().setLayoutData((Object)new GridData(1808));
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }

    private class PageControl
    extends Composite {
        private Group nodesGroup;
        private List nodesList;
        private Group linksGroup;
        private List linksList;
        private Composite detailsPart;
        private Group groupStructure;
        private Group groupEdit;
        private Group groupVisual;
        private Composite composite2;
        private Composite composite;
        private Button asNodeButton;
        private Button asLinkButton;
        private Button removeButton;
        private Button changeDetailsButton;
        private Button restoreButton;
        private Group groupConstaints;
        private Label specLabel;
        private Label initLabel;
        private Label diagramElementLabel;
        private Label metaElementLabel;
        private Label containmentLabel;
        private Label linkMetaFeatureLabel;
        private boolean isNodeInSelection;
        private NodeReference selectedNode;
        private LinkMapping selectedLink;
        private final ILabelProvider myLabelProvider;
        private SelectionListener myListSelectionListener;
        private FocusListener myListFocusListener;

        public PageControl(Composite parent) {
            super(parent, 0);
            this.nodesGroup = null;
            this.nodesList = null;
            this.linksGroup = null;
            this.linksList = null;
            this.detailsPart = null;
            this.groupStructure = null;
            this.groupEdit = null;
            this.groupVisual = null;
            this.composite2 = null;
            this.composite = null;
            this.asNodeButton = null;
            this.asLinkButton = null;
            this.removeButton = null;
            this.changeDetailsButton = null;
            this.restoreButton = null;
            this.groupConstaints = null;
            this.specLabel = null;
            this.initLabel = null;
            this.diagramElementLabel = null;
            this.myLabelProvider = new LabelProvider(){
                final EcoreItemProviderAdapterFactory helperFactory = new EcoreItemProviderAdapterFactory();

                public String getText(Object element) {
                    String dnName;
                    if (element instanceof LinkMapping) {
                        LinkMapping next = (LinkMapping)element;
                        String linkName = next.getDomainMetaElement() == null ? (next.getLinkMetaFeature() == null ? Messages.unspecifiedValue : this.getLabel((EObject)next.getLinkMetaFeature())) : this.getLabel((EObject)next.getDomainMetaElement());
                        String dlName = next.getDiagramLink() != null ? next.getDiagramLink().getName() : Messages.unspecifiedValue;
                        String featureName = next.getContainmentFeature() != null ? next.getContainmentFeature().getName() : Messages.unspecifiedValue;
                        return Messages.bind((String)Messages.linkLabel, (Object[])new Object[]{linkName, dlName, featureName});
                    }
                    NodeReference next = (NodeReference)element;
                    String nodeName = next.getChild().getDomainMetaElement() == null ? Messages.unspecifiedValue : this.getLabel((EObject)next.getChild().getDomainMetaElement());
                    String string = dnName = next.getChild().getDiagramNode() != null ? next.getChild().getDiagramNode().getName() : Messages.unspecifiedValue;
                    String featureName = next.getContainmentFeature() != null ? next.getContainmentFeature().getName() : (next.getChildrenFeature() != null ? next.getChildrenFeature().getName() : Messages.unspecifiedValue);
                    return Messages.bind((String)Messages.nodeLabel, (Object[])new Object[]{nodeName, dnName, featureName});
                }

                private String getLabel(EObject ecoreElement) {
                    IItemLabelProvider lp = (IItemLabelProvider)this.helperFactory.adapt((Object)ecoreElement, IItemLabelProvider.class);
                    if (!$assertionsDisabled && lp == null) {
                        throw new AssertionError();
                    }
                    return lp.getText((Object)ecoreElement);
                }
            };
            this.myListSelectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PageControl.this.removeButton.setEnabled(true);
                    PageControl.this.changeDetailsButton.setEnabled(true);
                    PageControl.this.restoreButton.setEnabled(true);
                    if (e.widget == PageControl.this.nodesList) {
                        PageControl.this.handleNodesListSelectionChange();
                        PageControl.this.linksList.deselectAll();
                    } else if (e.widget == PageControl.this.linksList) {
                        PageControl.this.handleLinksListSelectionChange();
                        PageControl.this.nodesList.deselectAll();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            };
            this.myListFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (e.widget == PageControl.this.nodesList) {
                        PageControl.this.handleNodesListSelectionChange();
                    } else if (e.widget == PageControl.this.linksList) {
                        PageControl.this.handleLinksListSelectionChange();
                    }
                }

                public void focusLost(FocusEvent e) {
                }
            };
            this.initialize();
        }

        public void populate() {
            this.populateNodesList();
            this.populateLinksList();
        }

        private void populateNodesList() {
            String[] items = new String[EntriesPage.this.getMapInstance().getNodes().size()];
            int i = 0;
            Iterator it = EntriesPage.this.getMapInstance().getNodes().iterator();
            while (it.hasNext()) {
                items[i] = this.myLabelProvider.getText(it.next());
                ++i;
            }
            this.nodesList.setItems(items);
        }

        private void populateLinksList() {
            String[] items = new String[EntriesPage.this.getMapInstance().getLinks().size()];
            int i = 0;
            Iterator it = EntriesPage.this.getMapInstance().getLinks().iterator();
            while (it.hasNext()) {
                items[i] = this.myLabelProvider.getText(it.next());
                ++i;
            }
            this.linksList.setItems(items);
        }

        private void initialize() {
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            this.setLayout((Layout)gridLayout);
            this.createNodesList();
            this.createButtonsPane();
            this.createLinksList();
            this.createDetailsPart();
        }

        private void createNodesList() {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.verticalAlignment = 4;
            this.nodesGroup = new Group((Composite)this, 0);
            this.nodesGroup.setLayout((Layout)new FillLayout());
            this.nodesGroup.setLayoutData((Object)gridData);
            this.nodesGroup.setText(Messages.mapNodesList);
            this.nodesList = new List((Composite)this.nodesGroup, 2564);
            this.nodesList.addSelectionListener(this.myListSelectionListener);
            this.nodesList.addFocusListener(this.myListFocusListener);
        }

        private void createLinksList() {
            GridData gridData1 = new GridData();
            gridData1.grabExcessHorizontalSpace = true;
            gridData1.horizontalAlignment = 4;
            gridData1.verticalAlignment = 4;
            gridData1.grabExcessVerticalSpace = true;
            this.linksGroup = new Group((Composite)this, 0);
            this.linksGroup.setLayout((Layout)new FillLayout());
            this.linksGroup.setLayoutData((Object)gridData1);
            this.linksGroup.setText(Messages.mapLinksList);
            this.linksList = new List((Composite)this.linksGroup, 2564);
            this.linksList.addSelectionListener(this.myListSelectionListener);
            this.linksList.addFocusListener(this.myListFocusListener);
        }

        private void createDetailsPart() {
            GridData gridData3 = new GridData();
            gridData3.horizontalSpan = 5;
            gridData3.verticalAlignment = 4;
            gridData3.grabExcessHorizontalSpace = true;
            gridData3.grabExcessVerticalSpace = false;
            gridData3.horizontalAlignment = 4;
            this.detailsPart = new Composite((Composite)this, 0);
            this.detailsPart.setLayoutData((Object)gridData3);
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.numColumns = 7;
            gridLayout1.makeColumnsEqualWidth = true;
            this.detailsPart.setLayout((Layout)gridLayout1);
            this.createStructureGroup();
            this.createEditGroup();
            this.changeDetailsButton = new Button(this.detailsPart, 0);
            this.changeDetailsButton.setText(Messages.mapChange);
            this.changeDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NodeReference input = PageControl.this.isNodeInSelection ? PageControl.this.selectedNode : PageControl.this.selectedLink;
                    ChangePropertiesDialog changePropertiesDialog = new ChangePropertiesDialog(PageControl.this.getShell(), new Object[]{input});
                    int result = changePropertiesDialog.open();
                }
            });
            GridData gridData8 = new GridData();
            gridData8.grabExcessHorizontalSpace = true;
            gridData8.verticalAlignment = 2;
            gridData8.verticalSpan = 2;
            gridData8.horizontalAlignment = 2;
            this.changeDetailsButton.setLayoutData((Object)gridData8);
            this.createVisualGroup();
            this.createConstraintsGroup();
        }

        private void createStructureGroup() {
            this.groupStructure = new Group(this.detailsPart, 8);
            this.groupStructure.setText(Messages.groupStructure);
            this.groupStructure.setLayoutData((Object)this.newDetailGroupConstraint());
            this.groupStructure.setLayout((Layout)this.newDetailGroupLayout());
            Label l = new Label((Composite)this.groupStructure, 0);
            l.setText(Messages.labelElement);
            this.metaElementLabel = new Label((Composite)this.groupStructure, 0);
            this.metaElementLabel.setLayoutData((Object)this.newDetailLabelConstraint());
            l = new Label((Composite)this.groupStructure, 0);
            l.setText(Messages.labelContainment);
            this.containmentLabel = new Label((Composite)this.groupStructure, 0);
            this.containmentLabel.setLayoutData((Object)this.newDetailLabelConstraint());
            l = new Label((Composite)this.groupStructure, 0);
            l.setText(Messages.labelTargetFeature);
            this.linkMetaFeatureLabel = new Label((Composite)this.groupStructure, 0);
            this.linkMetaFeatureLabel.setLayoutData((Object)this.newDetailLabelConstraint());
        }

        private void createEditGroup() {
            this.groupEdit = new Group(this.detailsPart, 0);
            this.groupEdit.setText(Messages.groupEdit);
            this.groupEdit.setLayout((Layout)this.newDetailGroupLayout());
            this.groupEdit.setLayoutData((Object)this.newDetailGroupConstraint());
        }

        private void createVisualGroup() {
            this.groupVisual = new Group(this.detailsPart, 0);
            this.groupVisual.setText(Messages.groupVisual);
            this.groupVisual.setLayoutData((Object)this.newDetailGroupConstraint());
            this.groupVisual.setLayout((Layout)this.newDetailGroupLayout());
            Label l = new Label((Composite)this.groupVisual, 0);
            l.setText(Messages.labelDiagramElement);
            this.diagramElementLabel = new Label((Composite)this.groupVisual, 0);
            this.diagramElementLabel.setLayoutData((Object)this.newDetailLabelConstraint());
        }

        private void createButtonsPane() {
            GridData gridData2 = new GridData();
            gridData2.horizontalAlignment = 4;
            gridData2.verticalAlignment = 2;
            this.composite2 = new Composite((Composite)this, 0);
            this.composite2.setLayout((Layout)new FillLayout());
            this.composite2.setLayoutData((Object)gridData2);
            this.createComposite();
        }

        private void createComposite() {
            RowLayout rowLayout = new RowLayout();
            rowLayout.type = 512;
            rowLayout.justify = true;
            rowLayout.marginHeight = 0;
            rowLayout.marginWidth = 0;
            rowLayout.pack = false;
            rowLayout.spacing = 6;
            rowLayout.marginLeft = 10;
            rowLayout.marginRight = 10;
            rowLayout.fill = false;
            this.composite = new Composite(this.composite2, 0);
            this.composite.setLayout((Layout)rowLayout);
            this.asNodeButton = new Button(this.composite, 0);
            this.asNodeButton.setText(Messages.mapAsNode);
            this.asNodeButton.setEnabled(false);
            this.asNodeButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TopNodeReference tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
                    NodeMapping nm = GMFMapFactory.eINSTANCE.createNodeMapping();
                    nm.setDomainMetaElement(PageControl.this.selectedLink.getDomainMetaElement());
                    nm.setDomainInitializer(PageControl.this.selectedLink.getDomainInitializer());
                    nm.setDomainSpecialization(PageControl.this.selectedLink.getDomainSpecialization());
                    nm.setTool(PageControl.this.selectedLink.getTool());
                    nm.setContextMenu(PageControl.this.selectedLink.getContextMenu());
                    nm.setAppearanceStyle(PageControl.this.selectedLink.getAppearanceStyle());
                    tnr.setContainmentFeature(PageControl.this.selectedLink.getContainmentFeature());
                    tnr.setOwnedChild(nm);
                    EntriesPage.this.getMapInstance().getNodes().add((Object)tnr);
                    EntriesPage.this.getMapInstance().getLinks().remove((Object)PageControl.this.selectedLink);
                    PageControl.this.linksList.remove(PageControl.this.linksList.getSelectionIndex());
                    PageControl.this.nodesList.add(PageControl.this.myLabelProvider.getText((Object)tnr));
                    PageControl.this.nodesList.setSelection(PageControl.this.nodesList.getItemCount() - 1);
                    PageControl.this.handleNodesListSelectionChange();
                }
            });
            this.asLinkButton = new Button(this.composite, 0);
            this.asLinkButton.setText(Messages.mapAsLink);
            this.asLinkButton.setEnabled(false);
            this.asLinkButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LinkMapping lm = GMFMapFactory.eINSTANCE.createLinkMapping();
                    NodeMapping nodeMapping = PageControl.this.selectedNode.getChild();
                    lm.setDomainMetaElement(nodeMapping.getDomainMetaElement());
                    lm.setContainmentFeature(PageControl.this.selectedNode.getContainmentFeature());
                    lm.setDomainInitializer(nodeMapping.getDomainInitializer());
                    lm.setDomainSpecialization(nodeMapping.getDomainSpecialization());
                    lm.setTool(nodeMapping.getTool());
                    lm.setContextMenu(nodeMapping.getContextMenu());
                    lm.setAppearanceStyle(nodeMapping.getAppearanceStyle());
                    EntriesPage.this.getMapInstance().getLinks().add((Object)lm);
                    EntriesPage.this.getMapInstance().getNodes().remove((Object)PageControl.this.selectedNode);
                    PageControl.this.nodesList.remove(PageControl.this.nodesList.getSelectionIndex());
                    PageControl.this.linksList.add(PageControl.this.myLabelProvider.getText((Object)lm));
                    PageControl.this.linksList.setSelection(PageControl.this.linksList.getItemCount() - 1);
                    PageControl.this.handleLinksListSelectionChange();
                }
            });
            this.removeButton = new Button(this.composite, 0);
            this.removeButton.setText(Messages.mapRemove);
            this.removeButton.setEnabled(false);
            this.removeButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int i;
                    if (PageControl.this.nodesList.getSelectionIndex() != -1) {
                        i = PageControl.this.nodesList.getSelectionIndex();
                        PageControl.this.nodesList.remove(i);
                        EntriesPage.this.getMapInstance().getNodes().remove(i);
                        if (i == PageControl.this.nodesList.getItemCount() && i > 0) {
                            --i;
                        }
                        PageControl.this.nodesList.setSelection(i);
                        if (PageControl.this.nodesList.getItemCount() == 0) {
                            PageControl.this.asLinkButton.setEnabled(false);
                            PageControl.this.removeButton.setEnabled(false);
                            PageControl.this.changeDetailsButton.setEnabled(false);
                        } else {
                            PageControl.this.handleNodesListSelectionChange();
                        }
                    }
                    if (PageControl.this.linksList.getSelectionIndex() != -1) {
                        i = PageControl.this.linksList.getSelectionIndex();
                        PageControl.this.linksList.remove(i);
                        EntriesPage.this.getMapInstance().getLinks().remove(i);
                        if (i == PageControl.this.linksList.getItemCount() && i > 0) {
                            --i;
                        }
                        PageControl.this.linksList.setSelection(i);
                        if (PageControl.this.linksList.getItemCount() == 0) {
                            PageControl.this.asNodeButton.setEnabled(false);
                            PageControl.this.removeButton.setEnabled(false);
                            PageControl.this.changeDetailsButton.setEnabled(false);
                        } else {
                            PageControl.this.handleLinksListSelectionChange();
                        }
                    }
                }
            });
            this.restoreButton = new Button(this.composite, 0);
            this.restoreButton.setText(Messages.mapRestore);
            this.restoreButton.setEnabled(false);
            this.restoreButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ListDialog dialog = new ListDialog(PageControl.this.getShell());
                    dialog.setTitle(PageControl.this.isNodeInSelection ? Messages.mapRestoreNode : Messages.mapRestoreLink);
                    dialog.setMessage(Messages.mapRestoreText);
                    dialog.setContentProvider(new IStructuredContentProvider(){

                        public Object[] getElements(Object inputElement) {
                            return (Object[])inputElement;
                        }

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }

                        public void dispose() {
                        }
                    });
                    dialog.setLabelProvider(PageControl.this.myLabelProvider);
                    if (PageControl.this.isNodeInSelection) {
                        dialog.setInput((Object)EntriesPage.this.getHolder().nodeCandidates());
                    } else {
                        dialog.setInput((Object)EntriesPage.this.getHolder().linkCandidates());
                    }
                    if (dialog.open() == 0) {
                        if (PageControl.this.isNodeInSelection) {
                            EList nodes = EntriesPage.this.getMapInstance().getNodes();
                            HashSet<EClass> usedClassSet = new HashSet<EClass>();
                            for (TopNodeReference nextTopNodeReference : nodes) {
                                usedClassSet.add(nextTopNodeReference.getChild().getDomainMetaElement());
                            }
                            Object[] objectArray = dialog.getResult();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object nextObject = objectArray[n2];
                                TopNodeReference nextNodeReference = (TopNodeReference)nextObject;
                                if (!usedClassSet.contains(nextNodeReference.getChild().getDomainMetaElement())) {
                                    nodes.add((Object)nextNodeReference);
                                }
                                ++n2;
                            }
                            PageControl.this.nodesList.removeAll();
                            PageControl.this.populateNodesList();
                        } else {
                            EList links = EntriesPage.this.getMapInstance().getLinks();
                            HashSet<EClass> usedClassSet = new HashSet<EClass>();
                            for (LinkMapping nextLinkMapping : links) {
                                usedClassSet.add(nextLinkMapping.getDomainMetaElement());
                            }
                            Object[] objectArray = dialog.getResult();
                            int n = objectArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                Object nextObject = objectArray[n3];
                                LinkMapping nextLinkMapping = (LinkMapping)nextObject;
                                if (!usedClassSet.contains(nextLinkMapping.getDomainMetaElement())) {
                                    links.add((Object)nextLinkMapping);
                                }
                                ++n3;
                            }
                            PageControl.this.linksList.removeAll();
                            PageControl.this.populateLinksList();
                        }
                    }
                }
            });
        }

        private void createConstraintsGroup() {
            this.groupConstaints = new Group(this.detailsPart, 0);
            this.groupConstaints.setText(Messages.groupConstraints);
            this.groupConstaints.setLayout((Layout)this.newDetailGroupLayout());
            this.groupConstaints.setLayoutData((Object)this.newDetailGroupConstraint());
            Label label = new Label((Composite)this.groupConstaints, 0);
            label.setText(Messages.labelSpecialization);
            this.specLabel = new Label((Composite)this.groupConstaints, 0);
            this.specLabel.setLayoutData((Object)this.newDetailLabelConstraint());
            label = new Label((Composite)this.groupConstaints, 0);
            label.setText(Messages.labelInitializer);
            this.initLabel = new Label((Composite)this.groupConstaints, 0);
            this.initLabel.setLayoutData((Object)this.newDetailLabelConstraint());
        }

        private GridLayout newDetailGroupLayout() {
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.makeColumnsEqualWidth = true;
            return gridLayout;
        }

        private GridData newDetailGroupConstraint() {
            GridData groupGridData = new GridData();
            groupGridData.horizontalAlignment = 4;
            groupGridData.grabExcessHorizontalSpace = true;
            groupGridData.grabExcessVerticalSpace = true;
            groupGridData.horizontalSpan = 3;
            groupGridData.verticalAlignment = 4;
            return groupGridData;
        }

        private GridData newDetailLabelConstraint() {
            GridData labelGridData = new GridData();
            labelGridData.horizontalSpan = 2;
            labelGridData.grabExcessHorizontalSpace = true;
            labelGridData.horizontalAlignment = 4;
            return labelGridData;
        }

        private void refreshCommonDetails(MappingEntry selectedEntry) {
            this.affix(this.metaElementLabel, (ENamedElement)selectedEntry.getDomainMetaElement());
            this.refreshDomainSpecialization(selectedEntry);
            this.refreshDomainInitializer(selectedEntry);
        }

        private void refreshDomainSpecialization(MappingEntry selectedEntry) {
            if (selectedEntry.getDomainSpecialization() == null) {
                this.specLabel.setText("");
                return;
            }
            this.specLabel.setText(selectedEntry.getDomainSpecialization().getBody());
        }

        private void refreshDomainInitializer(MappingEntry selectedEntry) {
            if (selectedEntry.getDomainInitializer() == null || !(selectedEntry.getDomainInitializer() instanceof FeatureSeqInitializer)) {
                this.initLabel.setText("");
                return;
            }
            FeatureSeqInitializer fsi = (FeatureSeqInitializer)selectedEntry.getDomainInitializer();
            StringBuilder sb = new StringBuilder();
            for (FeatureInitializer next : fsi.getInitializers()) {
                sb.append(next.getFeature().getName());
                sb.append("; ");
            }
            this.initLabel.setText(sb.toString());
        }

        private void affix(Label l, ENamedElement el) {
            if (el != null) {
                l.setText(el.getName());
            } else {
                l.setText("");
            }
        }

        private void refreshNodeDetails() {
            this.refreshCommonDetails((MappingEntry)this.selectedNode.getChild());
            NodeMapping m = this.selectedNode.getChild();
            this.affix(this.containmentLabel, (ENamedElement)this.selectedNode.getContainmentFeature());
            if (m.getDiagramNode() != null) {
                this.diagramElementLabel.setText(m.getDiagramNode().getName());
            } else {
                this.diagramElementLabel.setText("");
            }
            this.linkMetaFeatureLabel.setText("");
        }

        private void refreshLinkDetails() {
            this.refreshCommonDetails((MappingEntry)this.selectedLink);
            this.affix(this.containmentLabel, (ENamedElement)this.selectedLink.getContainmentFeature());
            LinkMapping l = this.selectedLink;
            if (l.getDiagramLink() != null) {
                this.diagramElementLabel.setText(l.getDiagramLink().getName());
            } else {
                this.diagramElementLabel.setText("");
            }
            this.affix(this.linkMetaFeatureLabel, (ENamedElement)l.getLinkMetaFeature());
        }

        void handleNodesListSelectionChange() {
            this.asNodeButton.setEnabled(false);
            int selectionIndex = this.nodesList.getSelectionIndex();
            if (selectionIndex != -1) {
                this.selectedNode = (NodeReference)EntriesPage.this.getMapInstance().getNodes().get(selectionIndex);
                this.asLinkButton.setEnabled(this.selectedNode.getChild().getDomainMetaElement() != null);
                this.refreshNodeDetails();
            }
            this.isNodeInSelection = true;
        }

        void handleLinksListSelectionChange() {
            this.asLinkButton.setEnabled(false);
            int selectionIndex = this.linksList.getSelectionIndex();
            if (selectionIndex != -1) {
                this.selectedLink = (LinkMapping)EntriesPage.this.getMapInstance().getLinks().get(selectionIndex);
                this.asNodeButton.setEnabled(this.selectedLink.getDomainMetaElement() != null);
                this.refreshLinkDetails();
            }
            this.isNodeInSelection = false;
        }
    }
}

