/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph.attr;

import com.google.inject.Singleton;
import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.gmfgraph.CustomAttribute;
import org.eclipse.papyrus.gmf.gmfgraph.CustomClass;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * During Xpand->Xtend2 conversion this class had been merged with CustomClass.xpt
 */
@Singleton
@SuppressWarnings("all")
public class CustomAttributeOwner {
  public CharSequence customAttributes(final org.eclipse.papyrus.gmf.gmfgraph.CustomAttributeOwner it, final String instanceVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<CustomAttribute> _attributes = it.getAttributes();
      for(final CustomAttribute attr : _attributes) {
        CharSequence _customAttribute = this.customAttribute(attr, instanceVarName);
        _builder.append(_customAttribute);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence Init(final CustomClass it, final String instanceVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _customAttributes = this.customAttributes(it, instanceVarName);
    _builder.append(_customAttributes);
    return _builder;
  }
  
  public CharSequence customAttribute(final CustomAttribute it, final String instanceVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _customAttrValueImpl = this.customAttrValueImpl(it);
    _builder.append(_customAttrValueImpl);
    _builder.newLineIfNotEmpty();
    {
      boolean _isDirectAccess = it.isDirectAccess();
      if (_isDirectAccess) {
        _builder.append(instanceVarName);
        _builder.append(".");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(" = ");
        CharSequence _customAttrValue = this.customAttrValue(it);
        _builder.append(_customAttrValue);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append(instanceVarName);
        _builder.append(".set");
        String _firstUpper = StringExtensions.toFirstUpper(it.getName());
        _builder.append(_firstUpper);
        _builder.append("(");
        CharSequence _customAttrValue_1 = this.customAttrValue(it);
        _builder.append(_customAttrValue_1);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence customAttrValueImpl(final CustomAttribute it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isMultiStatementValue = it.isMultiStatementValue();
      if (_isMultiStatementValue) {
        String _value = it.getValue();
        String _firstUpper = StringExtensions.toFirstUpper(it.getName());
        String _plus = ("attr" + _firstUpper);
        String _format = MessageFormat.format(_value, _plus);
        _builder.append(_format);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence customAttrValue(final CustomAttribute it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isMultiStatementValue = it.isMultiStatementValue();
      if (_isMultiStatementValue) {
        _builder.append("attr");
        String _firstUpper = StringExtensions.toFirstUpper(it.getName());
        _builder.append(_firstUpper);
      } else {
        String _value = it.getValue();
        _builder.append(_value);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
