/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor.palette;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Palette;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private Common_qvto _common_qvto;

    protected String _activatorFQN(Palette palette) {
        return palette.getDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName();
    }

    protected String _activatorFQN(AbstractToolEntry entry) {
        return this.activatorFQN((EObject)entry.getGroup().getPalette());
    }

    protected String _activatorFQN(ToolGroup group) {
        return this.activatorFQN((EObject)group.getPalette());
    }

    @Localization
    public String i18nKey(EntryBase group) {
        boolean _startsWith_1;
        String rv = group.getCreateMethodName();
        String _switchResult = null;
        boolean _matched = false;
        boolean _startsWith = rv.startsWith("get");
        if (_startsWith) {
            _matched = true;
            _switchResult = this._common_qvto.substringAfter(rv, "get");
        }
        if (!_matched && (_startsWith_1 = rv.startsWith("create"))) {
            _matched = true;
            _switchResult = this._common_qvto.substringAfter(rv, "create");
        }
        if (!_matched) {
            _switchResult = rv;
        }
        return _switchResult;
    }

    @Localization
    public String i18nTitleKey(EntryBase group) {
        String _i18nKey = this.i18nKey(group);
        return String.valueOf(_i18nKey) + "_title";
    }

    @Localization
    public String i18nDescKey(EntryBase group) {
        String _i18nKey = this.i18nKey(group);
        return String.valueOf(_i18nKey) + "_desc";
    }

    public Iterable<ToolGroup> collectGroups(Palette palette) {
        boolean _notEquals;
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet();
        boolean bl = _notEquals = !Objects.equal((Object)palette, null);
        if (_notEquals) {
            result.addAll(palette.getGroups());
            EList _groups = palette.getGroups();
            for (ToolGroup group : _groups) {
                Iterables.addAll((Collection)result, this.collectSubGroups(group));
            }
        }
        return result;
    }

    public Iterable<ToolGroup> collectSubGroups(ToolGroup group) {
        return this.collectSubGroups(group, CollectionLiterals.newLinkedList());
    }

    public Iterable<ToolGroup> collectSubGroups(ToolGroup group, Collection<ToolGroup> acc) {
        boolean _not;
        Iterable directSubGroups = Iterables.filter((Iterable)group.getEntries(), ToolGroup.class);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)directSubGroups);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Iterables.addAll(acc, (Iterable)directSubGroups);
            for (ToolGroup next : directSubGroups) {
                this.collectSubGroups(next, acc);
            }
        }
        return acc;
    }

    public Iterable<AbstractToolEntry> collectTools(Palette palette) {
        Functions.Function1<ToolGroup, Iterable<AbstractToolEntry>> _function = new Functions.Function1<ToolGroup, Iterable<AbstractToolEntry>>(){

            public Iterable<AbstractToolEntry> apply(ToolGroup g) {
                return Iterables.filter((Iterable)g.getEntries(), AbstractToolEntry.class);
            }
        };
        return Iterables.concat((Iterable)IterableExtensions.map(this.collectGroups(palette), (Functions.Function1)_function));
    }

    public boolean needsNodeToolEntryClass(Palette palette) {
        Functions.Function1<ToolEntry, Boolean> _function = new Functions.Function1<ToolEntry, Boolean>(){

            public Boolean apply(ToolEntry e) {
                return Utils_qvto.this._common_qvto.notEmpty(e.getGenNodes());
            }
        };
        return IterableExtensions.exists((Iterable)Iterables.filter(this.collectTools(palette), ToolEntry.class), (Functions.Function1)_function);
    }

    public boolean needsLinkToolEntryClass(Palette palette) {
        Functions.Function1<ToolEntry, Boolean> _function = new Functions.Function1<ToolEntry, Boolean>(){

            public Boolean apply(ToolEntry e) {
                return Utils_qvto.this._common_qvto.notEmpty(e.getGenLinks());
            }
        };
        return IterableExtensions.exists((Iterable)Iterables.filter(this.collectTools(palette), ToolEntry.class), (Functions.Function1)_function);
    }

    public String activatorFQN(EObject entry) {
        if (entry instanceof AbstractToolEntry) {
            return this._activatorFQN((AbstractToolEntry)entry);
        }
        if (entry instanceof ToolGroup) {
            return this._activatorFQN((ToolGroup)entry);
        }
        if (entry instanceof Palette) {
            return this._activatorFQN((Palette)entry);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(entry).toString());
    }
}

