/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Language implements Enumerator
{
    OCL_LITERAL(0, "ocl", "ocl"),
    JAVA_LITERAL(1, "java", "java"),
    REGEXP_LITERAL(2, "regexp", "regexp"),
    NREGEXP_LITERAL(3, "nregexp", "nregexp"),
    LITERAL_LITERAL(4, "literal", "literal");

    public static final int OCL = 0;
    public static final int JAVA = 1;
    public static final int REGEXP = 2;
    public static final int NREGEXP = 3;
    public static final int LITERAL = 4;
    private static final Language[] VALUES_ARRAY;
    public static final List<Language> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Language[]{OCL_LITERAL, JAVA_LITERAL, REGEXP_LITERAL, NREGEXP_LITERAL, LITERAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Language get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Language result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Language getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Language result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Language get(int value) {
        switch (value) {
            case 0: {
                return OCL_LITERAL;
            }
            case 1: {
                return JAVA_LITERAL;
            }
            case 2: {
                return REGEXP_LITERAL;
            }
            case 3: {
                return NREGEXP_LITERAL;
            }
            case 4: {
                return LITERAL_LITERAL;
            }
        }
        return null;
    }

    private Language(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

