/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.papyrus.gmf.internal.xpand.ast.Statement;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.ExpressionHelper;

public class IfStatement
extends Statement {
    private final ExpressionHelper condition;
    private final Statement[] thenPart;
    private IfStatement elseIf;

    public IfStatement(int start, int end, int line, OCLExpressionCS condition, Statement[] thenPart, IfStatement elseIf) {
        super(start, end, line);
        this.condition = condition == null ? null : new ExpressionHelper(condition, this);
        this.thenPart = thenPart;
        this.elseIf = elseIf;
    }

    public ExpressionHelper getCondition() {
        return this.condition;
    }

    public IfStatement getElseIf() {
        return this.elseIf;
    }

    public void setElseIf(IfStatement elseIf) {
        this.elseIf = elseIf;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier conType;
        if (this.condition != null && (conType = this.condition.analyze(ctx, issues)) != ctx.getOCLEnvironment().getOCLStandardLibrary().getBoolean()) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Boolean expected!", this.condition));
        }
        int i = 0;
        while (i < this.thenPart.length) {
            this.thenPart[i].analyze(ctx, issues);
            ++i;
        }
        if (this.elseIf != null) {
            this.elseIf.analyze(ctx, issues);
        }
    }

    @Override
    public void evaluateInternal(ExecutionContext ctx) {
        block6: {
            block4: {
                block5: {
                    if (this.condition == null) break block4;
                    Object result = this.condition.evaluate(ctx);
                    if (result == null) {
                        throw new EvaluationException("Nullevaluation!", this.condition);
                    }
                    if (!(result instanceof Boolean)) {
                        throw new EvaluationException("Boolean expected (was: " + result.getClass().getName() + ")!", this.condition);
                    }
                    if (!((Boolean)result).booleanValue()) break block5;
                    int i = 0;
                    while (i < this.thenPart.length) {
                        this.thenPart[i].evaluate(ctx);
                        ++i;
                    }
                    break block6;
                }
                if (this.elseIf == null) break block6;
                this.elseIf.evaluate(ctx);
                break block6;
            }
            int i = 0;
            while (i < this.thenPart.length) {
                this.thenPart[i].evaluate(ctx);
                ++i;
            }
        }
    }

    Statement[] getThenPart() {
        return this.thenPart;
    }
}

