/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.EditingDomainServiceFactory;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.junit.utils.rules.AbstractModelFixture;
import org.junit.Assert;
import org.junit.runner.Description;

public class ModelSetFixture
extends AbstractModelFixture<TransactionalEditingDomain> {
    public ModelSetFixture() {
    }

    public ModelSetFixture(List<String> additionalFileExtension) {
        super(additionalFileExtension);
    }

    public ModelSet getResourceSet() {
        return (ModelSet)super.getResourceSet();
    }

    @Override
    protected TransactionalEditingDomain createEditingDomain() {
        try {
            ServicesRegistry services = this.createServiceRegistry();
            return ((ModelSet)services.getService(ModelSet.class)).getTransactionalEditingDomain();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to initialize service registry and/or editing domain: " + e.getLocalizedMessage()));
            return null;
        }
    }

    @Override
    protected void finished(Description description) {
        ResourceSet rset = ((TransactionalEditingDomain)this.getEditingDomain()).getResourceSet();
        try {
            try {
                ServicesRegistry services = ServiceUtilsForResourceSet.getInstance().getServiceRegistry(rset);
                services.disposeRegistry();
            }
            catch (Exception e) {
                e.printStackTrace();
                super.finished(description);
            }
        }
        finally {
            super.finished(description);
        }
    }

    protected ServicesRegistry createServiceRegistry() throws Exception {
        ServicesRegistry result = new ServicesRegistry();
        result.add(ModelSet.class, 10, (Object)new ModelSet());
        ServiceDescriptor desc = new ServiceDescriptor(TransactionalEditingDomain.class, EditingDomainServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10, Collections.singletonList(ModelSet.class.getName()));
        desc.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        desc.setClassBundleID("org.eclipse.papyrus.infra.core");
        result.add(desc);
        result.startRegistry();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void didLoadResourceSet() {
        block3: {
            try {
                this.getResourceSet().loadModels(this.getModelResourceURI());
                break block3;
            }
            catch (ModelMultiException e) {
                missingResource = Pattern.compile("ResourceException: Resource '.*' does not exist.");
                ** for (next : e.getExceptions())
            }
lbl-1000:
            // 1 sources

            {
                if (next.getMessage() != null && missingResource.matcher(next.getMessage()).find()) continue;
                e.printStackTrace();
                Assert.fail((String)("Failed to initialize ModelSet fixture: " + e.getLocalizedMessage()));
                continue;
            }
        }
    }

    public final <S> S tryService(Class<S> serviceType) {
        try {
            ServicesRegistry services = ServiceUtilsForResourceSet.getInstance().getServiceRegistry((ResourceSet)this.getResourceSet());
            return (S)services.getService(serviceType);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public final <S> S requireService(Class<S> serviceType) {
        try {
            ServicesRegistry services = ServiceUtilsForResourceSet.getInstance().getServiceRegistry((ResourceSet)this.getResourceSet());
            return (S)services.getService(serviceType);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to initialize service registry and/or service: " + e.getLocalizedMessage()));
            return null;
        }
    }
}

