/**
 * Copyright (c) 2006, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Remi Schnekenburger (CEA LIST) - modification for Papyrus MDT
 */
package aspects.impl.diagram.editparts;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.SnippetViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.papyrusgmfgenextension.ExtendedGenView;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import xpt.Common;

/**
 * Revisit: [MG]: @Inject extension same-named-api-class -> template extends api-class?
 */
@Singleton
@SuppressWarnings("all")
public class LinkEditPart extends impl.diagram.editparts.LinkEditPart {
  @Inject
  @Extension
  private Common _common;
  
  public CharSequence extendsListContents(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<ExtendedGenView, Boolean> _function = new Function1<ExtendedGenView, Boolean>() {
        @Override
        public Boolean apply(final ExtendedGenView v) {
          return Boolean.valueOf((v.getGenView().contains(it) && (!Objects.equal(v.getSuperOwnedEditPart(), null))));
        }
      };
      int _size = IteratorExtensions.size(IteratorExtensions.<ExtendedGenView>filter(Iterators.<ExtendedGenView>filter(it.eResource().getAllContents(), ExtendedGenView.class), _function));
      boolean _notEquals = (_size != 0);
      if (_notEquals) {
        {
          final Function1<ExtendedGenView, Boolean> _function_1 = new Function1<ExtendedGenView, Boolean>() {
            @Override
            public Boolean apply(final ExtendedGenView v) {
              return Boolean.valueOf((v.getGenView().contains(it) && (!Objects.equal(v.getSuperOwnedEditPart(), null))));
            }
          };
          Iterable<ExtendedGenView> _iterable = IteratorExtensions.<ExtendedGenView>toIterable(IteratorExtensions.<ExtendedGenView>filter(Iterators.<ExtendedGenView>filter(it.eResource().getAllContents(), ExtendedGenView.class), _function_1));
          for(final ExtendedGenView extendedObject : _iterable) {
            CharSequence _specifyInheritance = this.specifyInheritance(extendedObject);
            _builder.append(_specifyInheritance);
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence specifyInheritance(final ExtendedGenView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _superOwnedEditPart = it.getSuperOwnedEditPart();
    _builder.append(_superOwnedEditPart);
    return _builder;
  }
  
  @Override
  public CharSequence addFixedChild(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _size = it.getLabels().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected boolean addFixedChild(org.eclipse.gef.EditPart childEditPart) {");
        _builder.newLine();
        {
          EList<GenLinkLabel> _labels = it.getLabels();
          for(final GenLinkLabel label : _labels) {
            _builder.append("\t");
            CharSequence _addLabel = this.addLabel(label.getViewmap(), label);
            _builder.append(_addLabel, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence removeFixedChild(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected boolean removeFixedChild(org.eclipse.gef.EditPart childEditPart) {");
        _builder.newLine();
        {
          EList<GenLinkLabel> _labels = it.getLabels();
          for(final GenLinkLabel label : _labels) {
            _builder.append("\t");
            CharSequence _removeLabel = this.removeLabel(label.getViewmap(), label);
            _builder.append(_removeLabel, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence addChildVisual(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void addChildVisual(org.eclipse.gef.EditPart childEditPart, int index) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (addFixedChild(childEditPart)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.addChildVisual(childEditPart, -1);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence removeChildVisual(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void removeChildVisual(org.eclipse.gef.EditPart childEditPart) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (removeFixedChild(childEditPart)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.removeChildVisual(childEditPart);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  protected CharSequence _createLinkFigure(final ModeledViewmap it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @Override
  public CharSequence modeledViewmapFigureFQN(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @Override
  public CharSequence createLinkFigure(final Viewmap it, final GenLink link) {
    if (it instanceof FigureViewmap) {
      return _createLinkFigure((FigureViewmap)it, link);
    } else if (it instanceof InnerClassViewmap) {
      return _createLinkFigure((InnerClassViewmap)it, link);
    } else if (it instanceof ModeledViewmap) {
      return _createLinkFigure((ModeledViewmap)it, link);
    } else if (it instanceof SnippetViewmap) {
      return _createLinkFigure((SnippetViewmap)it, link);
    } else if (it != null) {
      return _createLinkFigure(it, link);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, link).toString());
    }
  }
}
