/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Artem Tikhomirov (Borland) - [235113] alternative parser access
 *                                 [244419] custom parsers
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package parsers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ParserProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private ParsersUtil _parsersUtil;
  
  @Inject
  private impl.parsers.ParserProvider xptImplParserProvider;
  
  public CharSequence className(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _classNameGenParsers = this._parsersUtil.classNameGenParsers(it);
    _builder.append(_classNameGenParsers);
    return _builder;
  }
  
  public CharSequence packageName(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageNameGenParsers = this._parsersUtil.packageNameGenParsers(it);
    _builder.append(_packageNameGenParsers);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      EList<GenTopLevelNode> _topLevelNodes = it.getEditorGen().getDiagram().getTopLevelNodes();
      for(final GenTopLevelNode node : _topLevelNodes) {
        _builder.append("\t");
        CharSequence _dispatch_parsers = this.xptImplParserProvider.dispatch_parsers(node);
        _builder.append(_dispatch_parsers, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenChildNode> _childNodes = it.getEditorGen().getDiagram().getChildNodes();
      for(final GenChildNode node_1 : _childNodes) {
        _builder.append("\t");
        CharSequence _dispatch_parsers_1 = this.xptImplParserProvider.dispatch_parsers(node_1);
        _builder.append(_dispatch_parsers_1, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenLink> _links = it.getEditorGen().getDiagram().getLinks();
      for(final GenLink link : _links) {
        _builder.append("\t");
        CharSequence _dispatch_parsers_2 = this.xptImplParserProvider.dispatch_parsers(link);
        _builder.append(_dispatch_parsers_2, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      boolean _isExtensibleViaService = it.isExtensibleViaService();
      if (_isExtensibleViaService) {
        CharSequence _parserByVisualIdMethod = this.xptImplParserProvider.getParserByVisualIdMethod(it);
        _builder.append(_parserByVisualIdMethod);
        _builder.newLineIfNotEmpty();
        CharSequence _accessorMethod_delegate2providers = this.xptImplParserProvider.accessorMethod_delegate2providers(it);
        _builder.append(_accessorMethod_delegate2providers);
        _builder.newLineIfNotEmpty();
        CharSequence _provider_getParserMethod = this.xptImplParserProvider.provider_getParserMethod(it);
        _builder.append(_provider_getParserMethod);
        _builder.newLineIfNotEmpty();
        CharSequence _provider_providesMethod = this.xptImplParserProvider.provider_providesMethod(it);
        _builder.append(_provider_providesMethod);
        _builder.newLineIfNotEmpty();
        CharSequence _HintAdapterClass = this.xptImplParserProvider.HintAdapterClass(it);
        _builder.append(_HintAdapterClass);
        _builder.newLineIfNotEmpty();
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _accessorMethod_direct = this.xptImplParserProvider.accessorMethod_direct(it);
        _builder.append(_accessorMethod_direct);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isExtensibleViaService = it.isExtensibleViaService();
      if (_isExtensibleViaService) {
        _builder.append(" extends org.eclipse.gmf.runtime.common.core.service.AbstractProvider");
      }
    }
    return _builder;
  }
  
  public CharSequence implementsList(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isExtensibleViaService = it.isExtensibleViaService();
      if (_isExtensibleViaService) {
        _builder.append(" implements org.eclipse.gmf.runtime.common.ui.services.parser.IParserProvider");
      }
    }
    return _builder;
  }
  
  public CharSequence additions(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  /**
   * @param it - aka hintHolder, visual element to present a text (i.e. one of Node's labels)
   * @param elementTypeHolder - model element being displayed
   * @param modelFacet - may be null
   * @param parsedElement - accessor to EObject being edited
   */
  @MetaDef
  public CharSequence accessorCall(final GenCommonBase it, final GenCommonBase elementTypeHolder, final LabelModelFacet labelModelFacet, final String parsedElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isExtensibleViaService = it.getDiagram().getEditorGen().getLabelParsers().isExtensibleViaService();
      if (_isExtensibleViaService) {
        CharSequence _accessorCall_delegate2providers = this.xptImplParserProvider.accessorCall_delegate2providers(it, elementTypeHolder, labelModelFacet, parsedElement);
        _builder.append(_accessorCall_delegate2providers);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _accessorCall_direct = this.xptImplParserProvider.accessorCall_direct(it, elementTypeHolder, labelModelFacet, parsedElement);
        _builder.append(_accessorCall_direct);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
