/**
 * Copyright (c) 2006-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.internal.common.codegen.Conversions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.editor.VisualIDRegistry;

/**
 * XXX: [MG] I don't like dependency from Common -> VisualIdRegistry
 */
@Singleton
@SuppressWarnings("all")
public class Common {
  public CharSequence copyright(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _copyrightText = it.getCopyrightText();
      boolean _notEquals = (!Objects.equal(_copyrightText, null));
      if (_notEquals) {
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        String _replaceAll = it.getCopyrightText().replaceAll("\n", "\n * ");
        _builder.append(_replaceAll, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence xcopyright(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _copyrightText = it.getCopyrightText();
      boolean _notEquals = (!Objects.equal(_copyrightText, null));
      if (_notEquals) {
        _builder.append("<!--");
        _builder.newLine();
        String _escapeXML = this.escapeXML(it.getCopyrightText());
        _builder.append(_escapeXML);
        _builder.newLineIfNotEmpty();
        _builder.append("-->");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public String escapeXML(final CharSequence forXML) {
    return Conversions.escapeXML(forXML.toString());
  }
  
  public CharSequence generatedClassComment() {
    return this.generatedClassComment("");
  }
  
  public CharSequence generatedClassComment(final String comment) {
    return this.doGeneratedComment(comment, "");
  }
  
  public CharSequence generatedMemberComment() {
    return this.doGeneratedComment("", "");
  }
  
  public CharSequence generatedMemberComment(final String comment) {
    return this.doGeneratedComment(comment, "");
  }
  
  public CharSequence generatedMemberComment(final String comment, final String comment2) {
    return this.doGeneratedComment(comment, comment2);
  }
  
  /**
   * XXX: FIXME: merge all generatedXXXcomment to go here
   */
  public CharSequence doGeneratedComment(final String comment, final String comment2) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    {
      int _length = comment.length();
      boolean _greaterThan = (_length > 0);
      if (_greaterThan) {
        _builder.append(" * ");
        String _replaceAll = comment.replaceAll("\n", "\n * ");
        _builder.append(_replaceAll);
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    {
      int _length_1 = comment2.length();
      boolean _greaterThan_1 = (_length_1 > 0);
      if (_greaterThan_1) {
        _builder.append(" * ");
        String _replaceAll_1 = comment2.replaceAll("\n", "\n * ");
        _builder.append(_replaceAll_1);
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence xmlGeneratedTag() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<?gmfgen generated=\"true\"?>");
    return _builder;
  }
  
  public CharSequence nonNLS_All(final Iterable<?> list) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = IterableExtensions.isEmpty(list);
      boolean _not = (!_isEmpty);
      if (_not) {
        {
          int _size = IterableExtensions.size(list);
          IntegerRange _upTo = new IntegerRange(1, _size);
          boolean _hasElements = false;
          for(final Integer i : _upTo) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(" ", "");
            }
            CharSequence _nonNLS = this.nonNLS((i).intValue());
            _builder.append(_nonNLS);
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence nonNLS() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _nonNLS = this.nonNLS(1);
    _builder.append(_nonNLS);
    return _builder;
  }
  
  public CharSequence nonNLS(final Object xptSelf, final int i) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _nonNLS = this.nonNLS(i);
    _builder.append(_nonNLS);
    return _builder;
  }
  
  public CharSequence nonNLS(final int xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("//$NON-NLS-");
    _builder.append(xptSelf);
    _builder.append("$");
    return _builder;
  }
  
  /**
   * Provides handy single point to override generation of assert statements
   * TODO refactor this Common.xpt into different flavours - like CommonCodeStyle (nls, assert), CommonSnippets(pkgStmt, setCharset, getSaveOptions) and so on
   * TODO condition.xpandToCharList()->count('"') / 2 gives better guess about number of nonNLS to generate
   */
  public CharSequence _assert(final String condition) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("assert ");
    _builder.append(condition);
    _builder.append(";");
    {
      int _indexOf = condition.indexOf("\"");
      boolean _greaterThan = (_indexOf > 0);
      if (_greaterThan) {
        _builder.append(" ");
        CharSequence _nonNLS = this.nonNLS();
        _builder.append(_nonNLS);
      }
    }
    return _builder;
  }
  
  public Object addShortcutAnnotation(final GenDiagram it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.emf.ecore.EAnnotation shortcutAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();");
    _builder.newLine();
    _builder.append("shortcutAnnotation.setSource(\"Shortcut\"); ");
    CharSequence _nonNLS = this.nonNLS();
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    _builder.append("shortcutAnnotation.getDetails().put(\"modelID\", ");
    CharSequence _modelID = VisualIDRegistry.modelID(it);
    _builder.append(_modelID);
    _builder.append("); ");
    CharSequence _nonNLS_1 = this.nonNLS();
    _builder.append(_nonNLS_1);
    _builder.newLineIfNotEmpty();
    _builder.append(viewVar);
    _builder.append(".getEAnnotations().add(shortcutAnnotation);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * FIXME: [MG] in some cases old xpand template generated artificial extra line break
   * For now we want to preserve evrything including new line, to simplify checking the diff's against old generated code
   * In future this extra lines should be removed, this is single point of removal
   */
  public CharSequence extraLineBreak() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence hackTripleSpace() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("   ");
    return _builder;
  }
  
  public String tripleSpace(final int amount) {
    StringBuilder b = new StringBuilder();
    int counter = 0;
    while ((counter < amount)) {
      {
        b.append("   ");
        counter = (counter + 1);
      }
    }
    return b.toString();
  }
}
