/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.nattable.handlers;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.nattable.representation.RepresentationFactory;
import org.eclipse.papyrus.toolsmiths.nattable.Activator;
import org.eclipse.papyrus.toolsmiths.nattable.messages.Messages;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.FileSelectionFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class RegisterTableConfigurationInArchitectureFrameworkHandler
extends AbstractHandler {
    private WeakReference<ArchitectureDescriptionLanguage> adl;
    private List<ViewerFilter> filters = new ArrayList<ViewerFilter>();

    public RegisterTableConfigurationInArchitectureFrameworkHandler() {
        this.filters.add((ViewerFilter)new FileSelectionFilter(Collections.singletonList("nattableconfiguration")));
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EditingDomain domain;
        final ArchitectureDescriptionLanguage language = this.getSelectedArchitectureDescriptionLanguage();
        if (language == null) {
            return null;
        }
        ResourceSet resourceSet = language.eResource().getResourceSet();
        TableConfiguration tableConfiguration = this.askForTableConfigurationToReference(resourceSet);
        if (tableConfiguration == null) {
            return null;
        }
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        EditingDomain editingDomain = domain = activeEditor instanceof IEditingDomainProvider ? ((IEditingDomainProvider)activeEditor).getEditingDomain() : null;
        if (domain == null) {
            return null;
        }
        List<ArchitectureViewpoint> viewpoints = this.getViewPointsToContribute(language);
        ArchitectureDomain architectureDomain = (ArchitectureDomain)language.eContainer();
        List<Concern> concerns = this.getConcernContribute(architectureDomain);
        final PapyrusTable pTable = this.createPapyrusTableRepresentation(language, tableConfiguration, concerns);
        CompoundCommand cc = new CompoundCommand("Register an existing Table Configuration Command");
        cc.append(AddCommand.create((EditingDomain)domain, (Object)language, (Object)ArchitecturePackage.eINSTANCE.getArchitectureDescriptionLanguage_RepresentationKinds(), Collections.singletonList(pTable)));
        for (ArchitectureViewpoint currentViewpoint : viewpoints) {
            cc.append(AddCommand.create((EditingDomain)domain, (Object)currentViewpoint, (Object)ArchitecturePackage.eINSTANCE.getArchitectureViewpoint_RepresentationKinds(), Collections.singletonList(pTable)));
        }
        cc.append((Command)new AbstractCommand("Set XMI_ID for PapyrusTable"){

            public void redo() {
            }

            public void execute() {
                ((XMIResource)language.eResource()).setID((EObject)pTable, pTable.getId());
            }

            protected boolean prepare() {
                return true;
            }
        });
        if (cc.canExecute()) {
            domain.getCommandStack().execute((Command)cc);
        }
        URI architectureResourceURI = language.eResource().getURI();
        String AFProjectName = architectureResourceURI.segment(1);
        URI tableResourceURI = tableConfiguration.eResource().getURI();
        String tableResourceProjectName = tableResourceURI.segment(1);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject AFProject = workspaceRoot.getProject(AFProjectName);
        ManifestEditor mfEditor = null;
        try {
            mfEditor = new ManifestEditor(AFProject);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        if (mfEditor != null) {
            mfEditor.init();
            mfEditor.addDependency(tableResourceProjectName);
            mfEditor.save();
        }
        return null;
    }

    private ArchitectureDescriptionLanguage getSelectedArchitectureDescriptionLanguage() {
        if (this.adl == null) {
            return null;
        }
        return (ArchitectureDescriptionLanguage)this.adl.get();
    }

    private TableConfiguration askForTableConfigurationToReference(ResourceSet resourceSet) {
        IFile[] ifile = WorkspaceResourceDialog.openFileSelection((Shell)Display.getCurrent().getActiveShell(), (String)Messages.RegisterTableConfigurationInArchitectureFrameworkHandler_AddExistingTableConfiguration, (String)Messages.RegisterTableConfigurationInArchitectureFrameworkHandler_SelectTheTableconfiguration, (boolean)false, (Object[])new IFile[0], this.filters);
        if (ifile.length == 1) {
            Resource res;
            IFile file = ifile[0];
            String projectName = file.getProject().getName();
            String pathInTheProject = file.getProjectRelativePath().toString();
            URI uri = URI.createPlatformPluginURI((String)projectName, (boolean)true);
            uri = this.getCompleteURI(uri, pathInTheProject);
            if (resourceSet.getURIConverter().exists(uri, null)) {
                res = resourceSet.getResource(uri, true);
            } else {
                uri = URI.createPlatformResourceURI((String)projectName, (boolean)true);
                uri = this.getCompleteURI(uri, pathInTheProject);
                res = resourceSet.getResource(uri, true);
            }
            Object root = res.getContents().get(0);
            if (root instanceof TableConfiguration) {
                return (TableConfiguration)root;
            }
        }
        return null;
    }

    protected URI getCompleteURI(URI initialProjectURI, String pathInTheProject) {
        String[] path = pathInTheProject.split("/");
        URI completURI = initialProjectURI;
        int i = 0;
        while (i < path.length - 1) {
            completURI = completURI.appendSegment(path[i]);
            ++i;
        }
        String fileName = path[path.length - 1].split("\\.")[0];
        completURI = completURI.appendSegment(fileName);
        completURI = completURI.appendFileExtension("nattableconfiguration");
        return completURI;
    }

    private List<ArchitectureViewpoint> getViewPointsToContribute(ArchitectureDescriptionLanguage language) {
        Assert.isNotNull((Object)language);
        ArrayList<ArchitectureViewpoint> selectedViewpoints = new ArrayList<ArchitectureViewpoint>();
        if (language.getViewpoints().size() == 1) {
            selectedViewpoints.add((ArchitectureViewpoint)language.getViewpoints().get(0));
        } else if (language.getViewpoints().size() > 1) {
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)new ArchitectureViewpointContentProvider());
            dialog.setTitle(Messages.RegisterTableConfigurationInArchitectureFrameworkHandler_SelectViewPointsToContribute);
            dialog.setMessage(Messages.RegisterTableConfigurationInArchitectureFrameworkHandler_SeveralViewpointsAreAvailable);
            dialog.setAllowMultiple(true);
            dialog.setInput((Object)language);
            if (dialog.open() == 0) {
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (current instanceof ArchitectureViewpoint) {
                        selectedViewpoints.add((ArchitectureViewpoint)current);
                    }
                    ++n2;
                }
            }
        }
        return selectedViewpoints;
    }

    private List<Concern> getConcernContribute(ArchitectureDomain domain) {
        Assert.isNotNull((Object)domain);
        ArrayList<Concern> selectedViewpoints = new ArrayList<Concern>();
        if (domain.getConcerns().size() == 1) {
            selectedViewpoints.add((Concern)domain.getConcerns().get(0));
        } else if (domain.getConcerns().size() > 1) {
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)new ConcernsContentProvider());
            dialog.setTitle(Messages.RegisterTableConfigurationInArchitectureFrameworkHandler_SelectConcernsToContribute);
            dialog.setMessage(Messages.RegisterTableConfigurationInArchitectureFrameworkHandler_SeveralConcernsAreAvailable);
            dialog.setAllowMultiple(true);
            dialog.setInput((Object)domain);
            if (dialog.open() == 0) {
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (current instanceof Concern) {
                        selectedViewpoints.add((Concern)current);
                    }
                    ++n2;
                }
            }
        }
        return selectedViewpoints;
    }

    private PapyrusTable createPapyrusTableRepresentation(ArchitectureDescriptionLanguage language, TableConfiguration tConfiguration, List<Concern> concerns) {
        String[] camelCaseWords;
        PapyrusTable pTable = RepresentationFactory.eINSTANCE.createPapyrusTable();
        pTable.setDescription(tConfiguration.getDescription());
        pTable.setIcon(tConfiguration.getIconPath());
        pTable.setConfiguration(tConfiguration);
        pTable.getConcerns().addAll(concerns);
        StringBuilder builder = new StringBuilder(language.getName());
        String[] stringArray = camelCaseWords = tConfiguration.getName().split("(?=[A-Z])");
        int n = camelCaseWords.length;
        int n2 = 0;
        while (n2 < n) {
            String current = stringArray[n2];
            builder.append(" ");
            builder.append(current);
            ++n2;
        }
        pTable.setName(builder.toString());
        pTable.setImplementationID(tConfiguration.getType());
        URI languageResourceURI = language.eResource().getURI();
        List segList = languageResourceURI.segmentsList();
        Assert.isTrue((segList.size() >= 2 ? 1 : 0) != 0);
        Assert.isTrue((boolean)"resource".equals(segList.get(0)));
        String pluginName = (String)segList.get(1);
        StringBuilder iDBuilder = new StringBuilder(pluginName);
        iDBuilder.append(".");
        iDBuilder.append("table");
        iDBuilder.append(".");
        iDBuilder.append(tConfiguration.getType());
        pTable.setId(iDBuilder.toString());
        return pTable;
    }

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection selection;
        IEvaluationContext context;
        Object selectionTmp;
        if (evaluationContext instanceof IEvaluationContext && (selectionTmp = (context = (IEvaluationContext)evaluationContext).getVariable("selection")) instanceof IStructuredSelection && (selection = (IStructuredSelection)selectionTmp).size() == 1 && selection.getFirstElement() instanceof ArchitectureDescriptionLanguage) {
            this.adl = new WeakReference<ArchitectureDescriptionLanguage>((ArchitectureDescriptionLanguage)selection.getFirstElement());
            this.setBaseEnabled(true);
            return;
        }
        this.setBaseEnabled(false);
    }

    private static class ArchitectureViewpointContentProvider
    implements ITreeContentProvider {
        private ArchitectureViewpointContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArchitectureDescriptionLanguage) {
                return ((ArchitectureDescriptionLanguage)inputElement).getViewpoints().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ArchitectureDescriptionLanguage) {
                return ((ArchitectureDescriptionLanguage)parentElement).getViewpoints().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ArchitectureDescriptionLanguage) {
                return ((ArchitectureDescriptionLanguage)element).getViewpoints().size() > 0;
            }
            return false;
        }
    }

    private static class ConcernsContentProvider
    implements ITreeContentProvider {
        private ConcernsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArchitectureDomain) {
                return ((ArchitectureDomain)inputElement).getConcerns().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ArchitectureDomain) {
                return ((ArchitectureDomain)parentElement).getConcerns().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ArchitectureDomain) {
                return ((ArchitectureDomain)element).getConcerns().size() > 0;
            }
            return false;
        }
    }
}

