/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.expressions.ExpressionsPackage;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.BooleanExpressionsFactory;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.IBooleanEObjectExpression;
import org.eclipse.papyrus.infra.emf.nattable.manager.axis.AbstractSynchronizedOnEStructuralFeatureAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.IMasterAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.MasterObjectAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.GenericRelationshipMatrixCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.IWrapper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;

public class EObjectColumnMatrixAxisManager
extends AbstractSynchronizedOnEStructuralFeatureAxisManager {
    private static final int STEREOTYPE_APPLIED_TO_ELEMENT = 31;
    private static final int STEREOTYPE_UNAPPLIED_FROM_ELEMENT = 32;
    private final IBooleanEObjectExpression defaultFilter = BooleanExpressionsFactory.eINSTANCE.createLiteralTrueExpression();
    private List<EObject> listenEObjects = new ArrayList<EObject>();
    private List<EObject> listenColumnSourceEObjects = new ArrayList<EObject>();
    private Map<TreeFillingConfiguration, TreeFillingConfigurationHelper> map;
    private Map<EStructuralFeature, TreeFillingConfiguration> featureVSConfiguration;
    private List<EStructuralFeature> tableFeatureToListen = new ArrayList<EStructuralFeature>();
    private Adapter tableConfigurationChangesListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.isTouch()) {
                return;
            }
            Object listenFeature = msg.getFeature();
            boolean toListen = false;
            if (listenFeature instanceof EStructuralFeature) {
                EClass eClass = ((EStructuralFeature)listenFeature).getEContainingClass();
                toListen = ExpressionsPackage.eINSTANCE.getIExpression().isSuperTypeOf(eClass);
            }
            if (toListen || EObjectColumnMatrixAxisManager.this.tableFeatureToListen.contains(msg.getFeature())) {
                EObjectColumnMatrixAxisManager.this.updateAxisAfterConfigurationChange();
                EObjectColumnMatrixAxisManager.this.cleanAndReinitListenObjects();
                EObjectColumnMatrixAxisManager.this.cleanAndFillTreeFillingConfigurationMap();
            }
        }
    };
    private Adapter columnSourceObjectChangesListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.isTouch()) {
                return;
            }
            int eventType = msg.getEventType();
            if ((4 == eventType || 3 == eventType || 5 == eventType || 31 == eventType || 32 == eventType) && EObjectColumnMatrixAxisManager.this.tableAxisShouldBeUpdated()) {
                EObjectColumnMatrixAxisManager.this.updateAxisAfterColumnSourceObjectChanges();
                EObjectColumnMatrixAxisManager.this.cleanAndReinitListenColumnSourceObjects();
            }
        }
    };

    @Override
    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        super.init(manager, rep, provider);
        Assert.isTrue((boolean)(this.getRepresentedContentProvider() instanceof MasterObjectAxisProvider));
        this.listenEObjects = new ArrayList<EObject>();
        this.tableFeatureToListen = new ArrayList<EStructuralFeature>();
        this.tableFeatureToListen.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration());
        this.tableFeatureToListen.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getLocalTableHeaderAxisConfiguration_AxisManagerConfigurations());
        this.tableFeatureToListen.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getTreeFillingConfiguration_AxisUsedAsAxisProvider());
        this.tableFeatureToListen.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getTreeFillingConfiguration_FilterRule());
        this.tableFeatureToListen.add((EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources());
        this.cleanAndReinitListenObjects();
        this.cleanAndReinitListenColumnSourceObjects();
        this.cleanAndFillTreeFillingConfigurationMap();
    }

    private void addListenerOnEObjects(EObject eobject, Adapter adapter, List<EObject> listenEObjectsList) {
        if (eobject != null && !eobject.eAdapters().contains((Object)adapter)) {
            eobject.eAdapters().add((Object)adapter);
            listenEObjectsList.add(eobject);
        }
    }

    private void removeListenersOnEObjects(List<EObject> listenEObjectsList, Adapter adapter) {
        for (EObject current : listenEObjectsList) {
            current.eAdapters().remove((Object)adapter);
        }
    }

    private void cleanAndReinitListenObjects() {
        AbstractAxisProvider rowAxisProvider;
        AbstractAxisProvider axisProvider;
        ICellEditorConfiguration cellEditorConfiguration;
        this.removeListenersOnEObjects(this.listenEObjects, this.tableConfigurationChangesListener);
        Table table = this.getTableManager().getTable();
        if (table == null) {
            return;
        }
        this.addListenerOnEObjects((EObject)table, this.tableConfigurationChangesListener, this.listenEObjects);
        LocalTableHeaderAxisConfiguration columnHeaderAxisConfiguration = table.getLocalColumnHeaderAxisConfiguration();
        if (columnHeaderAxisConfiguration instanceof LocalTableHeaderAxisConfiguration) {
            this.addListenerOnEObjects((EObject)columnHeaderAxisConfiguration, this.tableConfigurationChangesListener, this.listenEObjects);
            for (IAxisConfiguration current : columnHeaderAxisConfiguration.getOwnedAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)current).getDepth() != 1) continue;
                TreeFillingConfiguration treeFillingConfiguration = (TreeFillingConfiguration)current;
                this.addListenerOnEObjects((EObject)treeFillingConfiguration, this.tableConfigurationChangesListener, this.listenEObjects);
                IAxis provider = treeFillingConfiguration.getAxisUsedAsAxisProvider();
                this.addListenerOnEObjects((EObject)provider, this.tableConfigurationChangesListener, this.listenEObjects);
                IBooleanEObjectExpression filterRule = treeFillingConfiguration.getFilterRule();
                this.addListenerOnEObjects((EObject)filterRule, this.tableConfigurationChangesListener, this.listenEObjects);
            }
        }
        if ((cellEditorConfiguration = table.getOwnedCellEditorConfigurations()) != null) {
            this.addListenerOnEObjects((EObject)cellEditorConfiguration, this.tableConfigurationChangesListener, this.listenEObjects);
            if (cellEditorConfiguration instanceof GenericRelationshipMatrixCellEditorConfiguration) {
                GenericRelationshipMatrixCellEditorConfiguration tmp = (GenericRelationshipMatrixCellEditorConfiguration)cellEditorConfiguration;
                IBooleanEObjectExpression filter = tmp.getCellContentsFilter();
                this.addListenerOnEObjects((EObject)filter, this.tableConfigurationChangesListener, this.listenEObjects);
            }
        }
        if ((axisProvider = table.getCurrentColumnAxisProvider()) instanceof IMasterAxisProvider) {
            this.addListenerOnEObjects((EObject)axisProvider, this.tableConfigurationChangesListener, this.listenEObjects);
        }
        if ((rowAxisProvider = table.getCurrentRowAxisProvider()) instanceof IMasterAxisProvider) {
            this.addListenerOnEObjects((EObject)rowAxisProvider, this.tableConfigurationChangesListener, this.listenEObjects);
        }
    }

    private void cleanAndReinitListenColumnSourceObjects() {
        List<EObject> columnSources = this.getColumnSources();
        if (!columnSources.isEmpty()) {
            this.removeListenersOnEObjects(this.listenColumnSourceEObjects, this.columnSourceObjectChangesListener);
            for (EObject columnContainer : columnSources) {
                this.addListenerOnEObjects(columnContainer, this.columnSourceObjectChangesListener, this.listenColumnSourceEObjects);
                for (EObject childObj : columnContainer.eContents()) {
                    this.addListenerOnEObjects(childObj, this.columnSourceObjectChangesListener, this.listenColumnSourceEObjects);
                }
            }
        }
    }

    private void cleanAndFillTreeFillingConfigurationMap() {
        if (this.map == null) {
            this.map = new HashMap<TreeFillingConfiguration, TreeFillingConfigurationHelper>();
        }
        if (this.featureVSConfiguration == null) {
            this.featureVSConfiguration = new HashMap<EStructuralFeature, TreeFillingConfiguration>();
        }
        this.map.clear();
        this.featureVSConfiguration.clear();
        Table table = this.getTableManager().getTable();
        if (table != null) {
            for (TreeFillingConfiguration treeFillingConfiguration : FillingConfigurationUtils.getTreeFillingConfigurationForColumn((Table)table, (AxisManagerRepresentation)this.representedAxisManager)) {
                if (treeFillingConfiguration.getDepth() != 1) continue;
                TreeFillingConfigurationHelper helper = new TreeFillingConfigurationHelper(treeFillingConfiguration);
                this.map.put(treeFillingConfiguration, helper);
                this.featureVSConfiguration.put(helper.getEStructuralFeatureToListen(), treeFillingConfiguration);
            }
        }
    }

    @Override
    protected Collection<EStructuralFeature> getListenFeatures() {
        if (this.map == null) {
            this.cleanAndFillTreeFillingConfigurationMap();
        }
        this.listenFeatures = new HashSet();
        for (TreeFillingConfigurationHelper helper : this.map.values()) {
            EStructuralFeature current = helper.getEStructuralFeatureToListen();
            this.listenFeatures.add(current);
        }
        return this.listenFeatures;
    }

    @Override
    protected void verifyFeatureMultiplicity() {
    }

    @Override
    protected void verifyValues() {
    }

    @Override
    protected List<Object> getFeaturesValue() {
        this.getListenFeatures();
        ArrayList<Object> values = new ArrayList<Object>();
        for (EObject source : this.getColumnSources()) {
            values.addAll(this.getListenFeatureValueFor(source));
        }
        return values;
    }

    protected List<Object> getListenFeatureValueFor(EObject listenObject) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (TreeFillingConfigurationHelper current : this.map.values()) {
            EStructuralFeature feature = current.getEStructuralFeatureToListen();
            IBooleanEObjectExpression exp = current.getFilterRule();
            if (feature == null) continue;
            Object value = listenObject.eGet(feature);
            if (feature.isMany()) {
                for (Object tmp : (Collection)value) {
                    if (!(tmp instanceof EObject) || !((Boolean)exp.evaluate((Object)((EObject)tmp))).booleanValue()) continue;
                    values.add(tmp);
                }
                continue;
            }
            if (!(value instanceof EObject) || !((Boolean)exp.evaluate((Object)((EObject)value))).booleanValue()) continue;
            values.add(value);
        }
        return values;
    }

    public boolean isAllowedContents(Object object) {
        return true;
    }

    public boolean isAllowedContents(Object objectToTest, Object semanticParent, TreeFillingConfiguration conf, int depth) {
        boolean result = false;
        if (semanticParent instanceof EObject && objectToTest instanceof EObject && conf != null && conf.getAxisUsedAsAxisProvider() != null) {
            IBooleanEObjectExpression filter;
            IBooleanEObjectExpression iBooleanEObjectExpression = filter = conf.getFilterRule() != null ? conf.getFilterRule() : this.defaultFilter;
            if (((Boolean)filter.evaluate((Object)((EObject)objectToTest))).booleanValue()) {
                result = CellManagerFactory.INSTANCE.getCrossValueAsCollection(semanticParent, (Object)conf.getAxisUsedAsAxisProvider(), this.tableManager).contains(objectToTest);
            }
        }
        return result;
    }

    @Override
    protected void featureValueHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        EStructuralFeature editedFeature = (EStructuralFeature)(notification.getFeature() instanceof EStructuralFeature ? notification.getFeature() : null);
        if (editedFeature == null) {
            return;
        }
        TreeFillingConfiguration configuration = this.featureVSConfiguration.get(editedFeature);
        if (configuration == null) {
            return;
        }
        int eventType = notification.getEventType();
        EObject editedObject = (EObject)(notification.getNotifier() instanceof EObject ? notification.getNotifier() : null);
        if (editedObject == null) {
            return;
        }
        ArrayList<Object> toAdd = new ArrayList<Object>();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        switch (eventType) {
            case 8: {
                break;
            }
            case 3: {
                Object newValue = notification.getNewValue();
                if (!this.isAllowedContents(newValue, editedObject, configuration, configuration.getDepth()) || this.isAlreadyManaged(newValue)) break;
                toAdd.add(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Object current : newValues) {
                    if (!this.isAllowedContents(current, editedObject, configuration, configuration.getDepth()) || this.isAlreadyManaged(current)) continue;
                    toAdd.add(current);
                }
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                Collection collection = (Collection)((EObject)notification.getNotifier()).eGet((EStructuralFeature)notification.getFeature());
                Collection<EObject> subList = this.getSubFromFirstNotEquals(collection, (Integer)notification.getOldValue(), this.getIndex(collection, (EObject)notification.getNewValue()));
                toRemove.addAll(subList);
                toAdd.addAll(subList);
                break;
            }
            case 4: {
                Object oldValue = notification.getOldValue();
                if (!this.managedObject.contains(oldValue)) break;
                toRemove.add(oldValue);
                break;
            }
            case 6: {
                Collection oldValues = (Collection)notification.getOldValue();
                for (Object current : oldValues) {
                    if (!this.managedObject.contains(oldValues)) continue;
                    toRemove.add(current);
                }
                break;
            }
        }
        if (toAdd.size() > 0 || toRemove.size() > 0) {
            this.updateManagedList(toAdd, toRemove);
        }
    }

    public boolean canBeUsedAsRowManager() {
        return false;
    }

    public boolean canBeUsedAsColumnManager() {
        return true;
    }

    protected List<EObject> getColumnSources() {
        AbstractAxisProvider columnProvider = this.getTableManager().getTable().getCurrentColumnAxisProvider();
        ArrayList<EObject> context = new ArrayList<EObject>();
        if (columnProvider instanceof MasterObjectAxisProvider) {
            for (IWrapper wrapper : ((MasterObjectAxisProvider)columnProvider).getSources()) {
                if (!(wrapper.getElement() instanceof EObject)) continue;
                context.add((EObject)wrapper.getElement());
            }
        }
        return context;
    }

    protected void updateAxisAfterConfigurationChange() {
        if (this.getTableManager() == null || this.getTableManager().getTable() == null || this.getTableManager().getTable().getCurrentColumnAxisProvider() == null) {
            return;
        }
        ArrayList<Object> allAxisToDisplay = new ArrayList<Object>();
        for (IWrapper current : ((IMasterAxisProvider)this.getTableManager().getTable().getCurrentColumnAxisProvider()).getSources()) {
            if (!(current.getElement() instanceof EObject)) continue;
            allAxisToDisplay.addAll(this.getListenFeatureValueFor((EObject)current.getElement()));
        }
        ArrayList<Object> toAdd = new ArrayList<Object>(allAxisToDisplay);
        toAdd.removeAll(this.managedObject);
        ArrayList<Object> toRemove = new ArrayList<Object>(this.managedObject);
        toRemove.removeAll(allAxisToDisplay);
        this.updateManagedList(toAdd, toRemove);
    }

    protected void updateAxisAfterColumnSourceObjectChanges() {
        List<Object> allAxisToDisplay = this.getAllTableAxisToDisplay();
        this.managedObject.clear();
        this.managedObject.addAll(allAxisToDisplay);
        this.getTableManager().updateAxisContents(this.getRepresentedContentProvider());
    }

    protected boolean tableAxisShouldBeUpdated() {
        return !this.managedObject.equals(this.getAllTableAxisToDisplay());
    }

    protected List<Object> getAllTableAxisToDisplay() {
        if (this.getTableManager() == null || this.getTableManager().getTable() == null || this.getTableManager().getTable().getCurrentColumnAxisProvider() == null) {
            return null;
        }
        ArrayList<Object> allAxisToDisplay = new ArrayList<Object>();
        for (IWrapper current : ((IMasterAxisProvider)this.getTableManager().getTable().getCurrentColumnAxisProvider()).getSources()) {
            if (!(current.getElement() instanceof EObject)) continue;
            allAxisToDisplay.addAll(this.getListenFeatureValueFor((EObject)current.getElement()));
        }
        return allAxisToDisplay;
    }

    public void dispose() {
        this.removeListenersOnEObjects(this.listenEObjects, this.tableConfigurationChangesListener);
        this.removeListenersOnEObjects(this.listenColumnSourceEObjects, this.columnSourceObjectChangesListener);
        this.getTableManager().getTable().eAdapters().remove((Object)this.tableConfigurationChangesListener);
        this.tableFeatureToListen.clear();
        this.featureVSConfiguration.clear();
        this.map.clear();
        super.dispose();
    }

    protected class TreeFillingConfigurationHelper {
        private final IBooleanEObjectExpression defaultExpression = BooleanExpressionsFactory.eINSTANCE.createLiteralTrueExpression();
        private final TreeFillingConfiguration fillingConfiguration;

        public TreeFillingConfigurationHelper(TreeFillingConfiguration configuration) {
            this.fillingConfiguration = configuration;
        }

        public IBooleanEObjectExpression getFilterRule() {
            return this.fillingConfiguration.getFilterRule() == null ? this.defaultExpression : this.fillingConfiguration.getFilterRule();
        }

        private Object getFeatureToListen() {
            if (this.fillingConfiguration.getAxisUsedAsAxisProvider() != null) {
                return this.fillingConfiguration.getAxisUsedAsAxisProvider().getElement();
            }
            return null;
        }

        public EStructuralFeature getEStructuralFeatureToListen() {
            return (EStructuralFeature)(this.getFeatureToListen() instanceof EStructuralFeature ? this.getFeatureToListen() : null);
        }
    }
}

