/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.extensionpoint.GeneratorExtensionPoint;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.AbstractCreateContextPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CreateContextMainPage
extends AbstractCreateContextPage
implements Listener {
    private CCombo combo;
    private final List<IGenerator> generators = new GeneratorExtensionPoint().getGenerators();

    public CreateContextMainPage() {
        super(Messages.CreateContextMainPage_title);
    }

    public void dispose() {
        try {
            for (IGenerator next : this.generators) {
                next.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(1, false));
        this.combo = new CCombo(root, 2048);
        for (IGenerator generator : this.generators) {
            this.combo.add(generator.getName());
        }
        this.combo.setEditable(false);
        this.combo.setBackground(new Color((Device)this.combo.getDisplay(), 255, 255, 255));
        this.combo.select(0);
        this.combo.addListener(13, (Listener)this);
        this.combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setControl((Control)root);
        this.setDescription(Messages.CreateContextMainPage_description);
        this.getWizard().getCurrentlySelectedFile().ifPresent(this::selectGenerator);
    }

    public IWizardPage getNextPage() {
        int selection = this.combo.getSelectionIndex();
        this.getWizard().setGenerator(this.generators.get(selection));
        return this.getWizard().generatorPage;
    }

    public void handleEvent(Event event) {
        super.setPageComplete(true);
    }

    private void selectGenerator(IFile selectedFile) {
        IContentType contentType = null;
        try {
            IContentDescription description = selectedFile.getContentDescription();
            contentType = description != null ? description.getContentType() : null;
        }
        catch (CoreException e) {
            Activator.log.error("Failed to determine content type of " + selectedFile, (Throwable)e);
        }
        IContentType _contentType = contentType;
        this.generators.stream().filter(gen -> gen.canGenerate(selectedFile, _contentType)).findFirst().ifPresent(gen -> this.combo.select(this.generators.indexOf(gen)));
    }
}

