/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource.index;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.internal.resource.InternalIndexUtil;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IIndexSaveParticipant;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IndexManager;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IndexPersistenceManager;
import org.eclipse.papyrus.infra.emf.internal.resource.index.InternalModelIndex;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexListener;

public class WorkspaceModelIndex<T>
extends InternalModelIndex {
    private static final long INDEX_RECORD_SERIAL_VERSION = 1L;
    private final IndexHandler<? extends T> indexer;
    private final PersistentIndexHandler<T> pIndexer;
    private final String indexName;
    private final IContentType contentType;
    private final IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
    private final SetMultimap<IProject, IFile> index = HashMultimap.create();
    private final Set<String> fileExtensions;
    private boolean started;

    public WorkspaceModelIndex(String name, String contentType, IndexHandler<? extends T> indexer) {
        this(name, contentType, indexer, 0);
    }

    public WorkspaceModelIndex(String name, String contentType, IndexHandler<? extends T> indexer, int maxConcurrentJobs) {
        this(name, contentType, Platform.getContentTypeManager().getContentType(contentType).getFileSpecs(8), indexer, maxConcurrentJobs);
    }

    public WorkspaceModelIndex(String name, String contentType, String[] fileExtensions, IndexHandler<? extends T> indexer, int maxConcurrentJobs) {
        this(name, contentType, fileExtensions, indexer, null, maxConcurrentJobs);
    }

    public WorkspaceModelIndex(String name, String contentType, PersistentIndexHandler<T> indexer) {
        this(name, contentType, indexer, 0);
    }

    public WorkspaceModelIndex(String name, String contentType, PersistentIndexHandler<T> indexer, int maxConcurrentJobs) {
        this(name, contentType, Platform.getContentTypeManager().getContentType(contentType).getFileSpecs(8), indexer, maxConcurrentJobs);
    }

    public WorkspaceModelIndex(String name, String contentType, String[] fileExtensions, PersistentIndexHandler<T> indexer, int maxConcurrentJobs) {
        this(name, contentType, fileExtensions, indexer, indexer, maxConcurrentJobs);
    }

    private WorkspaceModelIndex(String name, String contentType, String[] fileExtensions, IndexHandler<? extends T> indexer, PersistentIndexHandler<T> pIndexer, int maxConcurrentJobs) {
        super(new QualifiedName("org.eclipse.papyrus.infra.emf", "index:" + name), maxConcurrentJobs);
        this.indexName = name;
        this.contentType = Platform.getContentTypeManager().getContentType(contentType);
        this.indexer = indexer;
        this.pIndexer = pIndexer;
        this.fileExtensions = fileExtensions != null && fileExtensions.length > 0 ? ImmutableSet.copyOf((Object[])fileExtensions) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.pIndexer != null) {
            IndexPersistenceManager.INSTANCE.removeIndex(this);
        }
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            for (IFile next : this.index.values()) {
                try {
                    next.setSessionProperty(this.getIndexKey(), null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            this.index.clear();
        }
    }

    @Override
    protected final void start() {
        InputStream storeInput;
        if (this.started) {
            throw new IllegalStateException("index already started: " + this.getName());
        }
        this.started = true;
        if (this.pIndexer != null && (storeInput = IndexPersistenceManager.INSTANCE.addIndex(this, this.createSaveParticipant())) != null) {
            try {
                this.loadIndex(storeInput);
            }
            catch (IOException e) {
                Activator.log.error("Failed to load index data for " + this.getName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndex(InputStream storeInput) throws IOException {
        List<IndexRecord> store = this.loadStore(storeInput);
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            for (IndexRecord record : store) {
                if (!record.file.isAccessible()) continue;
                try {
                    record.file.setSessionProperty(this.getIndexKey(), (Object)record);
                    this.index.put((Object)record.file.getProject(), (Object)record.file);
                }
                catch (CoreException e) {
                    Activator.log.log(e.getStatus());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<IndexRecord> loadStore(InputStream storeInput) throws IOException {
        List<IndexRecord> result = Collections.emptyList();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream outer = storeInput;
            try {
                try (ObjectInputStream input = this.createObjectInput(outer);){
                    long version = input.readLong();
                    if (version != 1L) {
                        throw new IOException("Unexpected index record serial version " + version);
                    }
                    int count = input.readInt();
                    result = new ArrayList(count);
                    int i = 0;
                    while (i < count) {
                        try {
                            result.add(this.readIndexRecord(input));
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException(e);
                        }
                        ++i;
                    }
                }
                if (outer == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (outer == null) throw throwable;
                outer.close();
                throw throwable;
            }
            outer.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private IndexRecord readIndexRecord(ObjectInput in) throws IOException, ClassNotFoundException {
        Path path = new Path((String)in.readObject());
        IFile file = this.wsRoot.getFile((IPath)path);
        Object index = in.readObject();
        return new IndexRecord(file, index);
    }

    private IIndexSaveParticipant createSaveParticipant() {
        return new IIndexSaveParticipant(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void save(WorkspaceModelIndex<?> index, OutputStream storeOutput) throws IOException, CoreException {
                if (index == WorkspaceModelIndex.this) {
                    List<IndexRecord> store;
                    WorkspaceModelIndex<?> workspaceModelIndex = index;
                    synchronized (workspaceModelIndex) {
                        store = index.index.values().stream().filter(IResource::isAccessible).map(f -> {
                            IndexRecord result = null;
                            try {
                                IndexRecord __;
                                result = __ = (IndexRecord)f.getSessionProperty(WorkspaceModelIndex.this.getIndexKey());
                            }
                            catch (CoreException e) {
                                Activator.log.log(e.getStatus());
                            }
                            return result;
                        }).collect(Collectors.toList());
                    }
                    WorkspaceModelIndex.this.saveStore(store, storeOutput);
                }
            }
        };
    }

    private void saveStore(List<IndexRecord> store, OutputStream storeOutput) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectOutputStream output = new ObjectOutputStream(storeOutput);){
            output.writeLong(1L);
            output.writeInt(store.size());
            for (IndexRecord next : store) {
                this.writeIndexRecord(next, output);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeIndexRecord(IndexRecord record, ObjectOutput out) throws IOException {
        out.writeObject(record.file.getFullPath().toPortableString());
        out.writeObject(record.index);
    }

    public final String getName() {
        return this.indexName;
    }

    public String toString() {
        return String.format("WorkspaceModelIndex(%s)", this.getName());
    }

    public <V> ListenableFuture<V> afterIndex(Function<? super Map<IFile, T>, V> function) {
        return Futures.transform(this.getIndex(), function, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public <V> ListenableFuture<V> afterIndex(Callable<V> callable) {
        return super.afterIndex(() -> {
            SetMultimap<IProject, IFile> setMultimap = this.index;
            synchronized (setMultimap) {
                return callable.call();
            }
        });
    }

    @Override
    public final <V> V ifAvailable(Callable<V> callable) throws CoreException {
        return super.ifAvailable(callable);
    }

    public void afterIndex(final Runnable runnable) {
        this.afterIndex(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public ListenableFuture<Map<IFile, T>> getIndex() {
        return this.afterIndex(new Callable<Map<IFile, T>>(){

            @Override
            public Map<IFile, T> call() {
                return WorkspaceModelIndex.this.map();
            }
        });
    }

    private Map<IFile, T> map() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (IFile next : this.index.values()) {
            try {
                IndexRecord record = (IndexRecord)next.getSessionProperty(this.getIndexKey());
                if (record == null) continue;
                result.put((Object)next, record.index);
            }
            catch (CoreException e) {
                Activator.log.error("Failed to access index data for file " + next.getFullPath(), (Throwable)e);
            }
        }
        return result.build();
    }

    @Override
    protected final void process(IFile file) throws CoreException {
        IProject project = file.getProject();
        if (this.match(file)) {
            IndexRecord record = (IndexRecord)file.getSessionProperty(this.getIndexKey());
            if (record == null || record.isObsolete()) {
                this.add(project, file);
            } else if (this.pIndexer == null) {
                this.add(project, file);
            } else {
                this.init(project, file, record);
            }
        } else {
            this.remove(project, file);
        }
    }

    @Override
    protected final boolean match(IFile file) {
        IContentType[] contentTypes;
        boolean result = false;
        if (file.isAccessible() && (this.fileExtensions == null || this.fileExtensions.contains(file.getFileExtension())) && file.isSynchronized(0) && (contentTypes = this.getContentTypes(file)) != null) {
            int i = 0;
            while (i < contentTypes.length && !result) {
                result = contentTypes[i].isKindOf(this.contentType);
                ++i;
            }
        }
        result = result && this.indexer.shouldIndex(file);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(IProject project, IFile file, IndexRecord record) throws CoreException {
        if (InternalIndexUtil.isTracing()) {
            InternalIndexUtil.detailf("indexer/files", "Loading initial index %s for %s", this.getIndexKey().getLocalName(), file.getFullPath());
        }
        if (this.pIndexer.load(file, record.index)) {
            SetMultimap<IProject, IFile> setMultimap = this.index;
            synchronized (setMultimap) {
                this.index.put((Object)project, (Object)file);
                file.setSessionProperty(this.getIndexKey(), (Object)record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(IProject project, IFile file) throws CoreException {
        if (InternalIndexUtil.isTracing()) {
            InternalIndexUtil.detailf("indexer/files", "Computing index %s for %s", this.getIndexKey().getLocalName(), file.getFullPath());
        }
        T data = this.indexer.index(file);
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            this.index.put((Object)project, (Object)file);
            file.setSessionProperty(this.getIndexKey(), (Object)new IndexRecord(file, data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void remove(IProject project, IFile file) throws CoreException {
        boolean unindex;
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            unindex = this.index.remove((Object)project, (Object)file);
        }
        if (unindex) {
            try {
                this.indexer.unindex(file);
            }
            finally {
                if (file.exists()) {
                    file.setSessionProperty(this.getIndexKey(), null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void remove(IProject project) throws CoreException {
        Set files;
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            files = this.index.containsKey((Object)project) ? this.index.removeAll((Object)project) : null;
        }
        if (files != null) {
            files.forEach(this.indexer::unindex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasIndex(IProject project) {
        SetMultimap<IProject, IFile> setMultimap = this.index;
        synchronized (setMultimap) {
            return this.index.containsKey((Object)project);
        }
    }

    public void addListener(final IWorkspaceModelIndexListener listener) {
        Futures.addCallback(this.getManager(), (FutureCallback)new FutureCallback<IndexManager>(){

            public void onSuccess(IndexManager result) {
                result.addListener(WorkspaceModelIndex.this, listener);
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void removeListener(final IWorkspaceModelIndexListener listener) {
        Futures.addCallback(this.getManager(), (FutureCallback)new FutureCallback<IndexManager>(){

            public void onSuccess(IndexManager result) {
                result.removeListener(WorkspaceModelIndex.this, listener);
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static interface IndexHandler<T> {
        public T index(IFile var1);

        public void unindex(IFile var1);

        default public boolean shouldIndex(IFile file) {
            return true;
        }
    }

    private final class IndexRecord {
        private IFile file;
        private long generation;
        private T index;

        IndexRecord(IFile file, T index) {
            this.file = file;
            this.generation = file.getModificationStamp();
            this.index = index;
        }

        boolean isObsolete() {
            return this.file.getModificationStamp() != this.generation;
        }
    }

    public static interface PersistentIndexHandler<T>
    extends IndexHandler<T> {
        public boolean load(IFile var1, T var2);
    }
}

