/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.core.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.uml.diagram.common.groups.Activator;
import org.eclipse.papyrus.uml.diagram.common.groups.Messages;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChangeGraphicalParentCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.commands.ChangeModelParentCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.core.PendingGroupNotificationsManager;
import org.eclipse.papyrus.uml.diagram.common.groups.core.ui.NotificationConfigurator;
import org.eclipse.papyrus.uml.diagram.common.groups.core.ui.utils.CreatorUtils;
import org.eclipse.papyrus.uml.diagram.common.groups.core.utils.Utils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ChooseParentNotificationConfigurator
extends NotificationConfigurator {
    private List<IGraphicalEditPart> parents;
    private boolean mode;
    private Map<Button, IGraphicalEditPart> childCheckBoxes;
    private IGraphicalEditPart mainEditPart;
    private IGraphicalEditPart host;

    public ChooseParentNotificationConfigurator(List<IGraphicalEditPart> parents, IGraphicalEditPart _childPart, Boolean mode, IGraphicalEditPart getHost, PendingGroupNotificationsManager _manager, NotificationConfigurator.Mode messageMode, String label) {
        super(_childPart, _manager, label, messageMode);
        this.parents = parents;
        this.childCheckBoxes = new HashMap<Button, IGraphicalEditPart>();
        this.mainEditPart = _childPart;
        this.mode = mode;
        this.host = getHost;
    }

    public Composite createComposite(Composite parent, FormToolkit toolkit) {
        if (toolkit == null) {
            toolkit = new FormToolkit(parent.getDisplay());
        }
        Composite top = toolkit.createComposite(parent, 0);
        top.setLayout((Layout)new FormLayout());
        FormText textLabel = toolkit.createFormText(top, false);
        textLabel.setText(String.valueOf(Messages.ChooseParentNotificationCommand_ChooseGraphicalParentMessage) + CreatorUtils.getLabel(this.mainEditPart), false, true);
        FormData data = new FormData();
        textLabel.setLayoutData((Object)data);
        FormText previousElement = textLabel;
        this.createCheckBoxes(toolkit, top, (Control)previousElement);
        return top;
    }

    public IGraphicalEditPart getChildPart() {
        return this.mainEditPart;
    }

    private void createCheckBoxes(FormToolkit toolkit, Composite top, Control previousElement) {
        for (IGraphicalEditPart parentEditPart : this.parents) {
            String label = CreatorUtils.getLabel(parentEditPart);
            Button checkBox = toolkit.createButton(top, label, 16);
            EditPart childParent = this.mainEditPart.getParent();
            if (childParent != null && childParent.equals(parentEditPart)) {
                checkBox.setSelection(true);
            } else {
                checkBox.setSelection(false);
            }
            FormData data = CreatorUtils.getFormDataUnder(previousElement);
            checkBox.setLayoutData((Object)data);
            previousElement = checkBox;
            this.childCheckBoxes.put(checkBox, parentEditPart);
            checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ChooseParentNotificationConfigurator.this.childCheckBoxes.remove(e.widget);
                }
            });
        }
    }

    public void run(IContext context) {
        IGraphicalEditPart newParent = null;
        for (Button checkBoxButton : this.childCheckBoxes.keySet()) {
            if (!checkBoxButton.getSelection()) continue;
            newParent = this.childCheckBoxes.get(checkBoxButton);
        }
        if (newParent != null) {
            TransactionalEditingDomain editingDomain = this.mainEditPart.getEditingDomain();
            this.changeModelParent(newParent, editingDomain);
            this.changeGraphicalParent(newParent, editingDomain);
        }
        this.closeNotitfication(context);
    }

    private void changeGraphicalParent(IGraphicalEditPart newParent, TransactionalEditingDomain editingDomain) {
        String label = "Change graphical parent of " + CreatorUtils.getLabel(this.mainEditPart) + " to " + CreatorUtils.getLabel(newParent);
        ChangeGraphicalParentCommand reassignParent = new ChangeGraphicalParentCommand(editingDomain, label, (EditPart)newParent, (EditPart)this.mainEditPart, this.host);
        if (reassignParent != null && reassignParent.canExecute()) {
            editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)reassignParent));
        }
    }

    private void changeModelParent(IGraphicalEditPart newParent, TransactionalEditingDomain editingDomain) {
        if (!this.mode) {
            EObject childObject = this.mainEditPart.resolveSemanticElement();
            EObject parentObject = newParent.resolveSemanticElement();
            if (parentObject != null && childObject != null) {
                EReference ref = Utils.getContainmentEReference(parentObject.eClass(), childObject.eClass());
                if (ref != null) {
                    HashMap<EObject, EReference> chilrendToMove = new HashMap<EObject, EReference>();
                    chilrendToMove.put(childObject, ref);
                    ChangeModelParentCommand reassignModelparent = new ChangeModelParentCommand(editingDomain, (IAdaptable)newParent, chilrendToMove, newParent);
                    if (reassignModelparent != null && reassignModelparent.canExecute()) {
                        editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)reassignModelparent));
                    }
                }
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.uml.diagram.common.groups", "One of the needed element is unavailable"));
            }
        }
    }

    @Override
    protected void closeNotitfication(IContext context) {
        this.papyrusNotificationView.dispose();
        this.notification.delete();
        this.manager.removeChooseParentNotification(this.mainEditPart);
    }
}

