/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix;

import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractMissingAttributeMarkerResolution;
import org.eclipse.papyrus.toolsmiths.validation.profile.Activator;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix.ProfileMarkerResolutionUtils;
import org.eclipse.uml2.uml.Profile;

public class NoLocationUMLGenPackageMarkerResolution
extends AbstractMissingAttributeMarkerResolution {
    NoLocationUMLGenPackageMarkerResolution() {
        super(16715847, "location");
    }

    public String getLabel() {
        return Messages.NoLocationUMLGenPackageMarkerResolution_label;
    }

    public String getDescription() {
        return Messages.NoLocationUMLGenPackageMarkerResolution_description;
    }

    protected String getAttributeValue(IMarker marker) {
        IFile umlModelFile;
        String uriFragment;
        block4: {
            Optional<Profile> profileOptional = ProfileMarkerResolutionUtils.getProfile(marker);
            if (profileOptional.isEmpty()) {
                return null;
            }
            Profile profile = profileOptional.get();
            Resource resource = profile.eResource();
            uriFragment = resource.getURIFragment((EObject)profile);
            try {
                umlModelFile = ProfileMarkerResolutionUtils.getUMLModelFile(marker);
                if (umlModelFile != null) break block4;
                return null;
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }
        return String.valueOf(ResourceUtils.mapAndEncodePath((IFile)umlModelFile)) + "#" + uriFragment;
    }
}

