/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.providers;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.properties.environment.PropertyEditorType;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.BooleanToggle;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.providers.AbstractTreeFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PropertyEditorTypeContentProvider
extends EMFGraphicalContentProvider
implements ICommitListener {
    private PropertyEditor source;
    private BooleanToggle filterButton;
    private PropertyEditorTypeViewerFilter currentFilter;

    public PropertyEditorTypeContentProvider(IStructuredContentProvider semanticProvider, PropertyEditor source) {
        super(semanticProvider, source.eResource().getResourceSet(), PropertyEditorTypeContentProvider.getHistoryId(source));
        this.source = source;
        this.currentFilter = new PropertyEditorTypeViewerFilter();
    }

    private static String getHistoryId(PropertyEditor source) {
        return "history_propertyEditorType_" + source.eResource().getURI();
    }

    public void createBefore(Composite parent) {
        Composite self = new Composite(parent, 0);
        self.setLayout((Layout)new PropertiesLayout());
        this.filterButton = new BooleanToggle(self);
        this.filterButton.setText("Filter");
        this.filterButton.setValue(this.currentFilter.getFilter());
        this.filterButton.addCommitListener((ICommitListener)this);
        super.createBefore(self);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer != null) {
            this.viewer.removeFilter((ViewerFilter)this.currentFilter);
        }
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer.addFilter((ViewerFilter)this.currentFilter);
    }

    public void commit(AbstractEditor editor) {
        this.currentFilter.setFilter(this.filterButton.getValue());
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    private class PropertyEditorTypeViewerFilter
    extends AbstractTreeFilter {
        private boolean filter = true;

        private PropertyEditorTypeViewerFilter() {
        }

        public boolean isVisible(Viewer viewer, Object parentElement, Object element) {
            if (!this.filter) {
                return true;
            }
            Object adaptedValue = PropertyEditorTypeContentProvider.this.getAdaptedValue(element);
            if (adaptedValue instanceof PropertyEditorType) {
                PropertyEditorType editorType = (PropertyEditorType)adaptedValue;
                if (PropertyEditorTypeContentProvider.this.source.getProperty() == null) {
                    return true;
                }
                return editorType.getType() == PropertyEditorTypeContentProvider.this.source.getProperty().getType() && this.isMultiplicityEquivalent(editorType.getMultiplicity(), PropertyEditorTypeContentProvider.this.source.getProperty().getMultiplicity());
            }
            return false;
        }

        private boolean isMultiplicityEquivalent(int multiplicity, int multiplicity2) {
            if (multiplicity < 0 || multiplicity > 1) {
                return multiplicity2 < 0 || multiplicity2 > 1;
            }
            return multiplicity == 1 && multiplicity2 == 1;
        }

        public boolean getFilter() {
            return this.filter;
        }

        public void setFilter(boolean filter) {
            this.filter = filter;
            this.clearCache();
        }
    }
}

